/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.filterImpl;

import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.filterImpl.FieldFilter;
import kd.bos.dataentity.utils.StringUtils;

public class RangeFilter
implements FieldFilter {
    private final boolean includeTo;
    private final String field;
    private final Object from;
    private final boolean includeFrom;
    private final Object to;
    private float boost = -1.0f;

    public RangeFilter(String fieldName, Object from, boolean includeFrom, Object to, boolean includeTo) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("filed is empty");
        }
        if (from == null && to == null) {
            throw new IllegalArgumentException("form and to can't null both");
        }
        this.field = fieldName;
        this.from = from;
        this.includeFrom = includeFrom;
        this.to = to;
        this.includeTo = includeTo;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f || boost > 1.0f) {
            throw new IllegalArgumentException("boost must less than 1 and great than 0");
        }
        this.boost = boost;
    }

    public boolean isIncludeTo() {
        return this.includeTo;
    }

    @Override
    public String getFieldName() {
        return this.field;
    }

    public Object getFrom() {
        return this.from;
    }

    public boolean isIncludeFrom() {
        return this.includeFrom;
    }

    public Object getTo() {
        return this.to;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("range(");
        sb.append(this.field);
        sb.append(",");
        if (this.getFrom() != null) {
            sb.append(">");
            if (this.isIncludeFrom()) {
                sb.append("=");
            }
            sb.append(this.getFrom());
            sb.append(",");
        }
        if (this.getTo() != null) {
            sb.append("<");
            if (this.isIncludeTo()) {
                sb.append("=");
            }
            sb.append(this.getTo());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(",").append(this.boost);
        sb.append(")");
        return sb.toString();
    }
}

