/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.filterImpl;

import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.filterImpl.FieldFilter;
import kd.ai.vdb.objects.TokenizeType;
import kd.bos.dataentity.utils.StringUtils;

public class TextMatchFilter
implements FieldFilter {
    private final String fieldName;
    private final String text;
    private float boost = -1.0f;
    private boolean matchAny;
    private TokenizeType tokenizeType;

    public TextMatchFilter(String fieldName, String text) {
        this(fieldName, text, TokenizeType.NONE);
    }

    public TextMatchFilter(String fieldName, String text, TokenizeType tokenizeType) {
        this(fieldName, text, tokenizeType, true);
    }

    public TextMatchFilter(String fieldName, String text, TokenizeType tokenizeType, boolean matchAny) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("fieldName is empty");
        }
        this.fieldName = fieldName;
        this.text = text;
        this.tokenizeType = tokenizeType;
        this.matchAny = matchAny;
    }

    public boolean getMatchAny() {
        return this.matchAny;
    }

    public void setMatchAny(boolean byPhrase) {
        this.matchAny = byPhrase;
    }

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f || boost > 1.0f) {
            throw new IllegalArgumentException("boost must less than 1 and great than 0");
        }
        this.boost = boost;
    }

    public String getText() {
        return this.text;
    }

    public TokenizeType getTokenizeType() {
        return this.tokenizeType;
    }

    public void setTokenizeType(TokenizeType tokenizeType) {
        this.tokenizeType = tokenizeType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return String.format("match:(%s,%s,%s,%s)", new Object[]{this.fieldName, this.text, this.tokenizeType, Float.valueOf(this.boost)});
    }
}

