/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.filterImpl;

import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.filterImpl.FieldFilter;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;

public class VectorFilter
implements FieldFilter {
    private final String field;
    private final double[] vectors;
    private final int topK;
    private float boost = -1.0f;

    @Override
    public float getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(float boost) {
        if (boost < 0.0f || boost > 1.0f) {
            throw new IllegalArgumentException("boost must less than 1 and great than 0");
        }
        this.boost = boost;
    }

    public VectorFilter(String fieldName, double[] vectors, int topK) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("fieldName is empty");
        }
        if (ArrayUtils.isEmpty((double[])vectors)) {
            throw new IllegalArgumentException("vectors can't be empty");
        }
        if (topK <= 0) {
            throw new IllegalArgumentException("topk must big than 0");
        }
        this.field = fieldName;
        this.vectors = vectors;
        this.topK = topK;
    }

    @Override
    public String getFieldName() {
        return this.field;
    }

    public double[] getVectors() {
        return this.vectors;
    }

    public int getTopK() {
        return this.topK;
    }

    @Override
    public <T> T accept(FilterVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return String.format("vector:(%s,%d,%s,%s)", this.field, this.topK, this.vectorToString(), Float.valueOf(this.boost));
    }

    private String vectorToString() {
        if (ArrayUtils.isEmpty((double[])this.vectors)) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int maxLen = 10;
        int to = Math.min(maxLen, this.vectors.length);
        for (int i = 0; i < to; ++i) {
            sb.append(this.vectors[i]).append(",");
        }
        if (this.vectors.length > maxLen) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }
}

