/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import kd.ai.vdb.ArrayTools;
import kd.ai.vdb.NotSupportedException;
import kd.ai.vdb.VDBConfig;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.storage.CollectionDataMode;
import kd.ai.vdb.objects.storage.RowCollectionData;

public final class CollectionData {
    private final CollectionMeta meta;
    private final boolean rowBased;
    private final CollectionDataMode collectionDataMode;

    public CollectionData(CollectionMeta collection) {
        this(collection, 10, true);
    }

    public CollectionData(CollectionMeta collection, int initCapacity) {
        this(collection, initCapacity, true);
    }

    public CollectionData(CollectionMeta collection, int initCapacity, boolean rowBased) {
        if (Objects.isNull(collection)) {
            throw new IllegalArgumentException("collection is null");
        }
        if (initCapacity <= 0) {
            throw new IllegalArgumentException("initCapacity must big than zero");
        }
        this.meta = collection;
        this.rowBased = rowBased;
        if (!rowBased) {
            throw new NotSupportedException();
        }
        this.collectionDataMode = new RowCollectionData(collection, initCapacity);
    }

    public CollectionMeta getMeta() {
        return this.meta;
    }

    public int size() {
        return this.collectionDataMode.size();
    }

    public void append(Object[] rowData) {
        if (rowData == null || rowData.length == 0) {
            throw new IllegalArgumentException("values is null");
        }
        FieldMeta[] fields = this.meta.getFields();
        if (rowData.length != fields.length) {
            throw new IllegalArgumentException("values length not match fields length");
        }
        for (int i = 0; i < rowData.length; ++i) {
            FieldMeta fieldMeta = fields[i];
            fieldMeta.checkValue(rowData[i]);
            if (rowData[i] != null) continue;
            if (!VDBConfig.current().assignDefaultValueWhenNull()) break;
            rowData[i] = fields[i].getDefaultValue();
            break;
        }
        this.collectionDataMode.append(rowData);
    }

    public Object getValue(int row, String fieldName) {
        if (this.size() == 0) {
            throw new IllegalArgumentException("no data");
        }
        if (row < 0 || row >= this.size()) {
            throw new IllegalArgumentException("row index out of bound");
        }
        if (!this.meta.contains(fieldName)) {
            throw new IllegalArgumentException("meta not contains field:" + fieldName);
        }
        return this.collectionDataMode.getValue(row, fieldName);
    }

    public byte getByte(int row, String fieldName) {
        return (Byte)this.getValue(row, fieldName);
    }

    public int getInt(int row, String fieldName) {
        return (Integer)this.getValue(row, fieldName);
    }

    public long getLong(int row, String fieldName) {
        return (Long)this.getValue(row, fieldName);
    }

    public String getString(int row, String fieldName) {
        return (String)this.getValue(row, fieldName);
    }

    public Date getDate(int row, String fieldName) {
        return (Date)this.getValue(row, fieldName);
    }

    public float getFloat(int row, String fieldName) {
        return ((Float)this.getValue(row, fieldName)).floatValue();
    }

    public double getDouble(int row, String fieldName) {
        return (Double)this.getValue(row, fieldName);
    }

    public float[] getFloatVector(int row, String fieldName) {
        return (float[])this.getValue(row, fieldName);
    }

    public double[] getDoubleVector(int row, String fieldName) {
        if (this.meta.getVectorField(fieldName).getVectorType() == DataType.FLOAT) {
            float[] floatVector = this.getFloatVector(row, fieldName);
            return ArrayTools.toDouble(floatVector);
        }
        return (double[])this.getValue(row, fieldName);
    }

    public void setValue(int row, String fieldName, Object value) {
        if (!this.meta.contains(fieldName)) {
            throw new IllegalArgumentException("field not found: " + fieldName);
        }
        if (row < 0 || row >= this.size()) {
            throw new IllegalArgumentException("row must big than 0 and less than size");
        }
        this.collectionDataMode.setValue(row, fieldName, value);
    }

    public String toString() {
        int i;
        int size = this.collectionDataMode.size();
        StringBuilder sb = new StringBuilder();
        sb.append("Total: ").append(size).append("\n");
        for (i = 0; i < this.meta.getFields().length; ++i) {
            sb.append(this.meta.getFields()[i].getName()).append("\t");
        }
        sb.append("\n");
        for (i = 0; i < size; ++i) {
            for (FieldMeta fieldMeta : this.meta.getFields()) {
                Object value = this.getValue(i, fieldMeta.getName());
                String originText = fieldMeta.valueToString(value);
                sb.append(originText).append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Object getId(int row) {
        if (this.meta.getIdField() == null) {
            throw new IllegalArgumentException("Id field not found");
        }
        return this.getValue(row, this.meta.getIdField().getName());
    }

    public Object[][] getData() {
        return this.collectionDataMode.getData();
    }

    public Object[] getRow(int row) {
        if (row < 0 || row >= this.size()) {
            throw new IllegalArgumentException("illegally row index");
        }
        return this.collectionDataMode.getRow(row);
    }

    public Object[] getColumn(String fieldName) {
        if (!this.meta.contains(fieldName)) {
            throw new IllegalArgumentException("meta not contains field:" + fieldName);
        }
        return this.collectionDataMode.getColumn(fieldName);
    }

    public List<Object> getColumnAsList(String fieldName) {
        return Arrays.asList(this.getColumn(fieldName));
    }

    public <T> List<T> castColumnData(String fieldName, Function<Object, T> cast) {
        Object[] columnData = this.getColumn(fieldName);
        ArrayList<T> items = new ArrayList<T>(columnData.length);
        for (Object v : columnData) {
            items.add(cast.apply(v));
        }
        return items;
    }

    public void setIdValue(int row, Object id) {
        if (this.meta.getIdField() == null) {
            throw new IllegalArgumentException("Id field not found");
        }
        this.setValue(row, this.meta.getIdField().getName(), id);
    }

    public void setScoreValue(int row, float score) {
        if (this.meta.getScoreField() == null) {
            throw new IllegalArgumentException("Score field not found");
        }
        this.setValue(row, this.meta.getScoreField().getName(), Float.valueOf(score));
    }

    public float getScoreValue(int row) {
        if (this.meta.getScoreField() == null) {
            throw new IllegalArgumentException("Score field not found");
        }
        return this.getFloat(row, this.meta.getScoreField().getName());
    }
}

