/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.ai.vdb.ArrayTools;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.IdFieldMeta;
import kd.ai.vdb.objects.ScoreFieldMeta;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;

public class CollectionMeta {
    private final Map<String, Integer> fieldIndex = new HashMap<String, Integer>();
    private String name;
    private FieldMeta[] fields;
    private IdFieldMeta idField;
    private ScoreFieldMeta scoreField;
    private int shards = -1;
    private int replicas = -1;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getShards() {
        return this.shards;
    }

    public void setShards(int shards) {
        this.shards = shards;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    public void addField(FieldMeta field) {
        if (field instanceof IdFieldMeta) {
            if (this.idField != null) {
                throw new IllegalArgumentException("Id field already exists");
            }
            this.idField = (IdFieldMeta)field;
        } else if (field instanceof ScoreFieldMeta) {
            if (this.scoreField != null) {
                throw new IllegalArgumentException("Score field already exists");
            }
            this.scoreField = (ScoreFieldMeta)field;
        }
        if (this.fields == null) {
            this.fields = new FieldMeta[1];
            this.fields[0] = field;
            this.fieldIndex.put(field.getName(), 0);
        } else {
            if (this.fieldIndex.containsKey(field.getName())) {
                throw new IllegalArgumentException("Field already exists:" + field.getName());
            }
            FieldMeta[] newFields = ArrayTools.increaseOne(this.fields, FieldMeta.class);
            newFields[this.fields.length] = field;
            this.fields = newFields;
            this.fieldIndex.put(field.getName(), this.fields.length - 1);
        }
    }

    public void addFields(FieldMeta[] fields) {
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new IllegalArgumentException("fields is empty");
        }
        for (FieldMeta field : fields) {
            this.addField(field);
        }
    }

    public CollectionMeta subOf(String[] fieldNames) {
        if (ArrayUtils.isEmpty((Object[])fieldNames)) {
            throw new IllegalArgumentException("filedNames is empty");
        }
        CollectionMeta subMeta = new CollectionMeta();
        subMeta.name = this.name;
        subMeta.replicas = this.replicas;
        subMeta.shards = this.shards;
        subMeta.addField(this.idField);
        if (this.scoreField != null) {
            subMeta.addField(this.scoreField);
        }
        for (String filedName : fieldNames) {
            if (!this.contains(filedName)) {
                throw new IllegalArgumentException("not contains filed:" + filedName);
            }
            subMeta.addField(this.getField(filedName));
        }
        return subMeta;
    }

    public FieldMeta[] getFields() {
        return this.fields;
    }

    public String[] getFieldNames(boolean withOutSystemFields) {
        return (String[])Arrays.stream(this.fields).filter(field -> !withOutSystemFields || !field.isSystemField()).map(FieldMeta::getName).toArray(String[]::new);
    }

    public FieldMeta getField(String fieldName) {
        if (!this.contains(fieldName)) {
            throw new IllegalArgumentException("Field not found: " + fieldName);
        }
        int idx = this.getFieldIndex(fieldName);
        return this.fields[idx];
    }

    public VectorFieldMeta getVectorField(String fieldName) {
        FieldMeta field = this.getField(fieldName);
        if (!(field instanceof VectorFieldMeta)) {
            throw new IllegalArgumentException("Field is not a vector field: " + fieldName);
        }
        return (VectorFieldMeta)field;
    }

    public VectorFieldMeta[] getVectorFields() {
        ArrayList<VectorFieldMeta> vectorFieldMetaList = new ArrayList<VectorFieldMeta>();
        for (FieldMeta fieldMeta : this.fields) {
            if (!(fieldMeta instanceof VectorFieldMeta)) continue;
            vectorFieldMetaList.add((VectorFieldMeta)fieldMeta);
        }
        return vectorFieldMetaList.toArray(new VectorFieldMeta[0]);
    }

    public boolean hasVector() {
        for (FieldMeta field : this.fields) {
            if (!(field instanceof VectorFieldMeta)) continue;
            return true;
        }
        return false;
    }

    public int getFieldIndex(String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("fieldNam is empty");
        }
        return this.fieldIndex.get(fieldName);
    }

    public boolean contains(String fieldName) {
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("fieldNam is empty");
        }
        return this.fieldIndex.containsKey(fieldName);
    }

    public IdFieldMeta getIdField() {
        return this.idField;
    }

    public ScoreFieldMeta getScoreField() {
        return this.scoreField;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Collection: ").append(this.name).append("\n");
        if (this.fields != null) {
            for (FieldMeta field : this.fields) {
                sb.append(field).append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int hc1 = Objects.hash(this.name, this.shards, this.replicas);
        int hc2 = 0;
        for (FieldMeta fieldMeta : this.fields) {
            hc2 ^= fieldMeta.hashCode();
        }
        return hc1 + 17 * hc2;
    }
}

