/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.objects;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import kd.ai.vdb.BiTuple;
import kd.ai.vdb.NotSupportedException;

public enum DataType {
    STRING,
    BYTE,
    INT,
    INT64,
    FLOAT,
    DOUBLE,
    VECTOR,
    BOOL,
    DATETIME,
    TEXT;

    public static final String DATETIMEFORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATEFORMAT = "yyyy-MM-dd";

    public static boolean supportVectorType(DataType dt) {
        return dt == FLOAT || dt == DOUBLE;
    }

    public static Class<?> getType(DataType dt) {
        switch (dt) {
            case TEXT: 
            case STRING: {
                return String.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case INT: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case VECTOR: {
                return Object[].class;
            }
            case BOOL: {
                return Boolean.class;
            }
            case DATETIME: {
                return Date.class;
            }
        }
        throw new NotSupportedException();
    }

    public static DataType fromString(String type) {
        switch (type.toLowerCase()) {
            case "string": {
                return STRING;
            }
            case "byte": {
                return BYTE;
            }
            case "int32": {
                return INT;
            }
            case "int64": {
                return INT64;
            }
            case "float": {
                return FLOAT;
            }
            case "double": {
                return DOUBLE;
            }
            case "vector": {
                return VECTOR;
            }
            case "bool": {
                return BOOL;
            }
            case "datetime": {
                return DATETIME;
            }
            case "json": {
                return TEXT;
            }
        }
        throw new NotSupportedException();
    }

    public static Date parseDate(String strDate) {
        BiTuple<Boolean, Date> parseDate = DataType.tryParseDate(strDate, DATETIMEFORMAT);
        if (parseDate.getKey().booleanValue()) {
            return parseDate.getValue();
        }
        parseDate = DataType.tryParseDate(strDate, DATEFORMAT);
        if (parseDate.getKey().booleanValue()) {
            return parseDate.getValue();
        }
        throw new IllegalArgumentException("can't parse date " + strDate + ",format must be:" + DATETIMEFORMAT + " or " + DATEFORMAT);
    }

    private static BiTuple<Boolean, Date> tryParseDate(String strDate, String fmt) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(fmt);
            Date date = format.parse(strDate);
            return new BiTuple<Boolean, Date>(true, date);
        }
        catch (ParseException e) {
            return new BiTuple<Boolean, Object>(false, null);
        }
    }

    public static String dateToString(Date date) {
        return new SimpleDateFormat(DATETIMEFORMAT).format(date);
    }

    public static String getTimeZoneOffset() {
        ZoneId systemZoneId = ZoneId.systemDefault();
        ZoneOffset zoneOffset = ZoneOffset.from(systemZoneId.getRules().getOffset(Instant.now()));
        return zoneOffset.getId();
    }

    public static boolean isNumberType(DataType dt) {
        return dt == FLOAT || dt == DOUBLE || dt == INT || dt == INT64 || dt == BYTE;
    }

    public void checkValueType(Object value) {
        switch (this) {
            case TEXT: 
            case STRING: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case BYTE: {
                if (value instanceof Byte) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case INT: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case INT64: {
                if (value instanceof Long) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case FLOAT: {
                if (value instanceof Float) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case DOUBLE: {
                if (value instanceof Double) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case VECTOR: {
                if (value instanceof ArrayList || value.getClass().isArray()) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case BOOL: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            case DATETIME: {
                if (value instanceof Date) break;
                throw new IllegalArgumentException("value type not match field type");
            }
            default: {
                throw new NotSupportedException();
            }
        }
    }

    public Object getDefaultValue() {
        switch (this) {
            case TEXT: 
            case STRING: {
                return "";
            }
            case BYTE: {
                return (byte)0;
            }
            case INT: {
                return 0;
            }
            case INT64: {
                return 0L;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case VECTOR: {
                return new float[0];
            }
            case BOOL: {
                return false;
            }
            case DATETIME: {
                return new Date();
            }
        }
        throw new NotSupportedException();
    }
}

