/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.objects;

import java.util.Date;
import java.util.Objects;
import kd.ai.vdb.NotSupportedException;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.IdFieldMeta;
import kd.ai.vdb.objects.TextFieldMeta;
import kd.ai.vdb.objects.TokenizeType;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import kd.bos.util.StringUtils;

public class FieldMeta {
    private final boolean isSystemField;
    private int maxLength = 0;
    private String name;
    private DataType dataType;
    private boolean nullable;
    private Object defaultValue;

    public FieldMeta(String name, DataType dataType) {
        this(name, dataType, false);
    }

    public FieldMeta(String name, DataType dataType, boolean nullable, boolean isSystemField) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
        this.dataType = dataType;
        this.isSystemField = isSystemField;
        this.nullable = nullable;
    }

    public static IdFieldMeta id(DataType dataType) {
        return new IdFieldMeta(dataType);
    }

    public static FieldMeta string(String name, int maxLength) {
        FieldMeta fieldMeta = new FieldMeta(name, DataType.STRING);
        fieldMeta.maxLength = maxLength;
        return fieldMeta;
    }

    public static FieldMeta of(String name, DataType dataType) {
        return new FieldMeta(name, dataType);
    }

    public static VectorFieldMeta vector(String name, DataType vectorType, int dims, VectorSimilarity similarity) {
        return new VectorFieldMeta(name, vectorType, dims, similarity);
    }

    public static TextFieldMeta text(String name, TokenizeType tokenizeType) {
        return new TextFieldMeta(name, tokenizeType);
    }

    public static TextFieldMeta text(String name) {
        return new TextFieldMeta(name, TokenizeType.DEFAULT);
    }

    public FieldMeta(String name, DataType dataType, boolean nullable) {
        this(name, dataType, nullable, false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSystemField() {
        return this.isSystemField;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (this.dataType == DataType.DATETIME) {
            return DataType.dateToString((Date)value);
        }
        return value.toString();
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("must big than 0");
        }
        this.maxLength = maxLength;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    private Object getDefaultValueByType() {
        switch (this.dataType) {
            case BOOL: {
                return false;
            }
            case DATETIME: {
                return null;
            }
            case STRING: {
                return "";
            }
            case TEXT: {
                return "{}";
            }
            case BYTE: {
                return (byte)0;
            }
            case INT: {
                return 0;
            }
            case INT64: {
                return 0L;
            }
            case DOUBLE: {
                return 0.0;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
        }
        throw new NotSupportedException();
    }

    public void checkValue(Object value) {
        if (value == null) {
            if (!this.isNullable()) {
                throw new IllegalArgumentException("field " + this.getName() + " can not be null");
            }
        } else {
            Class<?> clazz = DataType.getType(this.getDataType());
            if (clazz.isArray() ? !value.getClass().isArray() : !clazz.isInstance(value)) {
                throw new IllegalArgumentException("values type not match fields type");
            }
            if (this.getDataType() == DataType.STRING && this.getMaxLength() > 0 && value.toString().length() > this.getMaxLength()) {
                throw new IllegalArgumentException("String [" + value + "]\u2018s length is big than " + this.getMaxLength());
            }
        }
    }

    public String toString() {
        return "field:{name:" + this.name + ", type:" + (Object)((Object)this.dataType) + ", nullabe:" + this.nullable + ", maxlen:" + this.maxLength + ", system:" + this.isSystemField + '}';
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dataType, this.maxLength, this.isSystemField, this.nullable, this.defaultValue});
    }
}

