/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.objects;

import java.lang.reflect.Array;
import kd.ai.vdb.NotSupportedException;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;

public class VectorFieldMeta
extends FieldMeta {
    private final VectorSimilarity similarity;
    private int dims;
    private DataType vectorType;

    public VectorFieldMeta(String name, int dims, VectorSimilarity similarity) {
        this(name, DataType.DOUBLE, dims, similarity);
    }

    public VectorFieldMeta(String name, DataType vectorType, int dims) {
        this(name, vectorType, dims, VectorSimilarity.COSINE);
    }

    public VectorFieldMeta(String name, DataType vectorType, int dims, VectorSimilarity similarity) {
        super(name, DataType.VECTOR, false);
        if (dims <= 0) {
            throw new IllegalArgumentException("dims must big than 0");
        }
        this.dims = dims;
        this.similarity = similarity;
        this.setVectorType(vectorType);
    }

    public int getDims() {
        return this.dims;
    }

    public void setDims(int dims) {
        this.dims = dims;
    }

    public DataType getVectorType() {
        return this.vectorType;
    }

    public void setVectorType(DataType vectorType) {
        if (!DataType.supportVectorType(vectorType)) {
            throw new IllegalArgumentException("unsupported vector type: " + (Object)((Object)vectorType));
        }
        this.vectorType = vectorType;
    }

    public VectorSimilarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public Object getDefaultValue() {
        switch (this.vectorType) {
            case INT: {
                return new int[0];
            }
            case INT64: {
                return new long[0];
            }
            case FLOAT: {
                return new float[0];
            }
            case DOUBLE: {
                return new double[0];
            }
        }
        throw new NotSupportedException("not supported type %s", new Object[]{this.vectorType});
    }

    @Override
    public String valueToString(Object value) {
        int maxLen = 100;
        switch (this.getVectorType()) {
            case FLOAT: {
                return this.floatToString(value, maxLen);
            }
            case DOUBLE: {
                return this.doubleToString(value, maxLen);
            }
        }
        throw new NotSupportedException();
    }

    public String doubleToString(Object value, int maxLen) {
        if (value == null) {
            return "[]";
        }
        double[] doubles = (double[])value;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < doubles.length; ++i) {
            sb.append(doubles[i]);
            if (i < doubles.length - 1) {
                sb.append(",");
            }
            if (sb.length() < maxLen) continue;
            sb.append("...");
            break;
        }
        return sb.append("]").toString();
    }

    public String floatToString(Object value, int maxLen) {
        if (value == null) {
            return "[]";
        }
        float[] floats = (float[])value;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < floats.length; ++i) {
            sb.append(floats[i]);
            if (i < floats.length - 1) {
                sb.append(",");
            }
            if (sb.length() < maxLen) continue;
            sb.append("...");
            break;
        }
        return sb.append("]").toString();
    }

    @Override
    public void checkValue(Object value) {
        if (!this.isNullable() && value == null) {
            throw new IllegalArgumentException("field " + this.getName() + " can not be null");
        }
        if (value != null) {
            if (!value.getClass().isArray()) {
                throw new IllegalArgumentException("value must be array");
            }
            if (Array.getLength(value) != this.getDims()) {
                throw new IllegalArgumentException("value length must be equal to dims");
            }
        }
    }

    @Override
    public String toString() {
        return "vectorField:{name:" + this.getName() + ", type:" + (Object)((Object)this.getDataType()) + ", vectorType:" + (Object)((Object)this.vectorType) + ", dims:" + this.dims + ", similarity:" + (Object)((Object)this.similarity) + '}';
    }
}

