/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.objects.storage;

import kd.ai.vdb.ArrayTools;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.storage.CollectionDataMode;

public final class RowCollectionData
implements CollectionDataMode {
    private final CollectionMeta meta;
    private int _size = 0;
    private Object[][] rowsData;

    public RowCollectionData(CollectionMeta collection, int initCapacity) {
        this.meta = collection;
        FieldMeta[] fields = collection.getFields();
        this.rowsData = new Object[initCapacity][fields.length];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void append(Object[] rowData) {
        this.ensureCapacity(this._size + 1);
        this.rowsData[this._size] = rowData;
        ++this._size;
    }

    private void ensureCapacity(int currentSize) {
        if (currentSize >= this.rowsData.length) {
            int capacity = 100;
            if (currentSize - this.rowsData.length > capacity) {
                capacity = currentSize - this.rowsData.length;
            }
            this.rowsData = ArrayTools.increase(this.rowsData, this.rowsData.length + capacity);
        }
    }

    @Override
    public Object getValue(int row, String fieldName) {
        int fieldIdx = this.meta.getFieldIndex(fieldName);
        return this.rowsData[row][fieldIdx];
    }

    @Override
    public void setValue(int row, String fieldName, Object value) {
        int fieldIdx = this.meta.getFieldIndex(fieldName);
        FieldMeta field = this.meta.getFields()[fieldIdx];
        field.getDataType().checkValueType(value);
        this.ensureCapacity(row + 1);
        if (row >= this._size) {
            this._size = row + 1;
        }
        this.rowsData[row][fieldIdx] = value;
    }

    @Override
    public Object[][] getData() {
        Object[][] result = new Object[this._size][];
        System.arraycopy(this.rowsData, 0, result, 0, this._size);
        return result;
    }

    @Override
    public Object[] getRow(int row) {
        return this.rowsData[row];
    }

    @Override
    public Object[] getColumn(String fieldName) {
        if (this.size() == 0) {
            return new Object[0];
        }
        int columnIndex = this.meta.getFieldIndex(fieldName);
        Object[] ret = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.rowsData[i][columnIndex];
        }
        return ret;
    }
}

