/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.service.rx.SSESubscriber;
import kd.ai.httpsse.utils.HttpUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;

public class SSEClient {
    private static final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(){

        public void shutdown() {
        }
    };
    private static final CookieStore cookieStore = new BasicCookieStore();
    private final URI baseUri;
    private final Map<String, String> defaultCookies;

    public SSEClient(URI baseUri) {
        this(baseUri, new HashMap<String, String>());
    }

    public SSEClient(URI baseUri, Map<String, String> defaultCookies) {
        this.baseUri = baseUri;
        this.defaultCookies = defaultCookies;
    }

    private URI joinUri(URI baseUri, String path, String query) throws Exception {
        String basePath = baseUri.getPath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return new URI(baseUri.getScheme(), baseUri.getAuthority(), basePath + path, query, null);
    }

    public void post(SSEServiceInfo svcInfo, String json, SSESubscriber<? super String> sub) {
        String segment = svcInfo.getAppId() + "/" + svcInfo.getServiceClass();
        this.postUrl(segment, json, sub);
    }

    public void post(String serviceClazz, String json, SSESubscriber<? super String> sub) {
        SSEServiceInfo svcInfo = new SSEServiceInfo("gai", serviceClazz);
        this.post(svcInfo, json, sub);
    }

    public void postUrl(String segment, String json, SSESubscriber<? super String> sub) {
        this.postUrl(segment, null, json, sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUrl(String segment, String query, String json, SSESubscriber<? super String> sub) {
        block47: {
            for (Map.Entry<String, String> entry : this.defaultCookies.entrySet()) {
                BasicClientCookie cookie = new BasicClientCookie(entry.getKey(), entry.getValue());
                cookie.setDomain(this.baseUri.getHost());
                cookie.setPath("/");
                cookieStore.addCookie((Cookie)cookie);
            }
            HttpRequestRetryHandler retryHandler = (exception, executionCount, context) -> {
                if (executionCount > 3) {
                    return false;
                }
                return exception instanceof NoHttpResponseException;
            };
            try (CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setRetryHandler(retryHandler).setDefaultCookieStore(cookieStore).build();){
                URI urlAll = this.joinUri(this.baseUri, segment, query);
                HttpPost request = new HttpPost(urlAll);
                if (this.defaultCookies.size() > 0) {
                    StringBuilder cookieHeader = new StringBuilder();
                    for (Map.Entry<String, String> cookie : this.defaultCookies.entrySet()) {
                        if (cookieHeader.length() > 0) {
                            cookieHeader.append("; ");
                        }
                        cookieHeader.append(cookie.getKey()).append("=").append(cookie.getValue());
                    }
                    request.setHeader("Cookie", cookieHeader.toString());
                }
                RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
                request.setConfig(requestConfig);
                HttpUtils.setRequestHeaders((HttpUriRequest)request);
                StringEntity postEntity = new StringEntity(json);
                request.setEntity((HttpEntity)postEntity);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                    int stateCode = response.getStatusLine().getStatusCode();
                    if (stateCode == 200) {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) break block47;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                sub.onNext(line);
                            }
                            break block47;
                        }
                    }
                    sub.onError(new RuntimeException("reponse status :" + stateCode));
                }
                finally {
                    request.releaseConnection();
                }
            }
            catch (Exception e) {
                sub.onError(e);
            }
        }
        sub.onComplete();
    }

    static {
        connManager.setMaxTotal(SSEConfig.current().getSSEClientMaxTotal());
        connManager.setDefaultMaxPerRoute(SSEConfig.current().getSSEClientDefaultMaxPerRoute());
    }
}

