/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.ai.httpsse.core.Repo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ClassRepo<T>
implements Repo<T> {
    private final Log log = LogFactory.getLog(ClassRepo.class);
    public Map<String, Class<T>> classContainer = new ConcurrentHashMap<String, Class<T>>();
    private static final Map<String, Class<?>> staticClassContainer = new ConcurrentHashMap();

    public static boolean isImplementedBy(String clazzName, Class<?> interfaceClazz) {
        try {
            Class<?> clazz = ClassRepo.getOrCreateClass(clazzName);
            return interfaceClazz.isAssignableFrom(clazz);
        }
        catch (Throwable th) {
            return false;
        }
    }

    private static Class<?> getOrCreateClass(String clazzName) {
        if (!staticClassContainer.containsKey(clazzName)) {
            try {
                staticClassContainer.put(clazzName, Class.forName(clazzName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return staticClassContainer.get(clazzName);
    }

    @Override
    public T getOrCreate(String clazzName) {
        Class<T> clazz = this.getOrCreateType(clazzName);
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<T> getOrCreateType(String clazzName) {
        if (staticClassContainer.containsKey(clazzName)) {
            this.classContainer.put(clazzName, staticClassContainer.get(clazzName));
        } else if (!this.classContainer.containsKey(clazzName)) {
            this.classContainer.put(clazzName, this.createServiceType(clazzName));
        }
        return this.classContainer.get(clazzName);
    }

    private synchronized Class<T> createServiceType(String clazzName) {
        if (this.classContainer.containsKey(clazzName)) {
            return this.classContainer.get(clazzName);
        }
        try {
            return Class.forName(clazzName);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            this.log.error((Throwable)e);
            throw new RuntimeException("Create service type[" + clazzName + "] error!");
        }
    }
}

