/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;

public class SSEConfig {
    private static final SSEConfig _current = new SSEConfig();
    private static final int systemcorecount = Runtime.getRuntime().availableProcessors();

    private SSEConfig() {
    }

    public static SSEConfig current() {
        return _current;
    }

    public boolean getSSEDevEnv() {
        return this.getBoolConfigItem("bos.sse.dev.env", false);
    }

    public String getContextUrl() {
        return this.getProperty("domain.contextUrl", "http://localhost:8080/ierp");
    }

    public String getSSEServletPrefix() {
        return this.getProperty("bos.sse.servletprefix", "sse");
    }

    public boolean getSSEServerAsync() {
        return this.getBoolConfigItem("bos.sse.server.async", false);
    }

    public boolean getDisableSSEServiceClassName() {
        return this.getBoolConfigItem("bos.sse.server.disableclassname", true);
    }

    public int getAsyncContextTimeout() {
        return this.getIntConfigItem("bos.web.http.asynccontexttimeout", 300000);
    }

    public Map<String, String> getSSEServerResponseOtherHeaders() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String headers = this.getProperty("bos.sse.server.otherheaders", "Cache-Control:no-cache;X-Accel-Buffering:no");
        for (String header : headers.split(";")) {
            String[] name_value = header.split(":");
            if (name_value.length != 2) continue;
            ret.put(name_value[0], name_value[1]);
        }
        return ret;
    }

    @Deprecated
    public String getSSEServerMode() {
        return this.getProperty("bos.sse.server.mode", "normal");
    }

    public int getSSERxProducerCoreThreads() {
        return this.getIntConfigItem("bos.sse.rx.corethreads", 1);
    }

    public int getSSERxProducerMaxThreads() {
        return this.getIntConfigItem("bos.sse.rx.maxthreads", systemcorecount * 2);
    }

    public boolean getSingletonService() {
        return this.getBoolConfigItem("bos.sse.server.singeltonservice", true);
    }

    public String getEventErrorFormat() {
        return this.getProperty("bos.sse.server.errorformat", "error:%s" + System.lineSeparator() + System.lineSeparator());
    }

    public String getEventMessageFormat() {
        return this.getProperty("bos.sse.server.messageformat", "data:%s" + System.lineSeparator() + System.lineSeparator());
    }

    public int getSSEClientMaxTotal() {
        return this.getIntConfigItem("bos.sse.client.maxtotal", 100);
    }

    public int getSSEClientDefaultMaxPerRoute() {
        return this.getIntConfigItem("bos.sse.client.defaultmaxperroute", 20);
    }

    public int getSSERouterMaxTotal() {
        return this.getIntConfigItem("bos.sse.router.maxtotal", 100);
    }

    public int getSSERouterDefaultMaxPerRoute() {
        return this.getIntConfigItem("bos.sse.router.defaultmaxperroute", 20);
    }

    private int getIntConfigItem(String key, int defaultValue) {
        String v = this.getProperty(key, String.valueOf(defaultValue));
        return Integer.parseInt(v);
    }

    private boolean getBoolConfigItem(String key, boolean defaultValue) {
        String v = this.getProperty(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(v);
    }

    public Boolean getDisableClusterProperties() {
        String disable = this.getClusterProperty("ai.sse.clusterproperties.disable", "false");
        return Boolean.parseBoolean(disable);
    }

    public Set<String> getSSERouterIgnoredHeaders() {
        String headers = this.getClusterProperty("ai.sse.router.ignore-headers", "Content-Length,Host");
        return new HashSet<String>(Arrays.asList(headers.split(",")));
    }

    protected String getClusterProperty(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    protected String getProperty(String key, String defaultValue) {
        String tenantId = RequestContext.get().getTenantId();
        String pValue = System.getProperty(tenantId + "_" + key);
        if (!this.getDisableClusterProperties().booleanValue() && StringUtils.isEmpty((CharSequence)pValue)) {
            pValue = System.getProperty(key);
        }
        if (StringUtils.isEmpty((CharSequence)pValue)) {
            return defaultValue;
        }
        return pValue;
    }
}

