/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.server;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.server.SSEServer;
import kd.ai.httpsse.server.SSEServletBehavior;
import kd.ai.httpsse.utils.HttpUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

@WebServlet(asyncSupported=true)
public class SSEServlet
extends HttpServlet {
    private final Log log = LogFactory.getLog(SSEServlet.class);

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        SSEServer.current().start();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log.info("SSEServlet: GET " + request.getRequestURL());
        SSEServiceInfo svcInfo = HttpUtils.getService(request);
        SSEServletBehavior.getImpl(svcInfo, HttpUtils.getForwarded(request)).doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.log.info("SSEServlet: POST " + request.getRequestURL());
        SSEServiceInfo svcInfo = HttpUtils.getService(request);
        SSEServletBehavior.getImpl(svcInfo, HttpUtils.getForwarded(request)).doPost(request, response);
    }
}

