/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.server;

import java.io.IOException;
import java.security.SecureRandom;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.server.HealthServiceUtils;
import kd.ai.httpsse.server.impl.SSEServiceExecute;
import kd.ai.httpsse.server.impl.SSEServiceRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class SSEServletBehavior {
    private static final Log log = LogFactory.getLog(SSEServletBehavior.class);
    private static int executedRequestCount = 0;

    public static SSEServletBehavior getImpl(SSEServiceInfo svcInfo, boolean isForwarded) {
        if (SSEConfig.current().getSSEDevEnv()) {
            log.info("!!!sse thread id:" + Thread.currentThread().getId());
            log.info("!!!sse thread name:" + Thread.currentThread().getName());
            boolean toExecute = new SecureRandom().nextBoolean();
            if (toExecute) {
                log.info("!!!execute directly!!!,times:" + ++executedRequestCount);
            } else {
                log.info("!!!execute by router");
            }
            if (isForwarded || toExecute) {
                return new SSEServiceExecute(svcInfo);
            }
        } else if (isForwarded || SSEServletBehavior.executeDirectly(svcInfo.getAppId())) {
            return new SSEServiceExecute(svcInfo);
        }
        return new SSEServiceRoute(svcInfo);
    }

    private static boolean executeDirectly(String appId) {
        boolean isStandaloneWebNode = HealthServiceUtils.isStandaloneWebNode();
        if (!isStandaloneWebNode) {
            return HealthServiceUtils.isDeployApp(appId);
        }
        return false;
    }

    public abstract void doGet(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void doPost(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
}

