/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.server.impl;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.server.ServletHandler;
import kd.ai.httpsse.service.rx.AsyncHttpSubscriber;
import kd.ai.httpsse.service.rx.PublisherRepo;
import kd.ai.httpsse.service.rx.SSEProducer;
import kd.ai.httpsse.service.rx.SSEPublisher;
import kd.ai.httpsse.utils.ExHandler;
import kd.ai.httpsse.utils.HttpUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RxServletHandler
implements ServletHandler {
    private final Log log = LogFactory.getLog(RxServletHandler.class);

    @Override
    public void callSSEService(String publisherName, String json, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpUtils.setResponseHeaders(response, SSEConfig.current().getSSEServerResponseOtherHeaders());
        AsyncContext ctx = request.startAsync();
        try {
            ctx.setTimeout((long)SSEConfig.current().getAsyncContextTimeout());
            AsyncHttpSubscriber sub = new AsyncHttpSubscriber(ctx);
            SSEPublisher<String> pub = PublisherRepo.current().getOrCreate(publisherName);
            new SSEProducer<String>(sub, pub).on(json);
        }
        catch (Throwable th) {
            this.log.error(th);
            response.setStatus(500);
            String friendlyMessage = ExHandler.getFriendlyMessage(th);
            HttpUtils.outputOnce(ctx.getResponse().getOutputStream(), friendlyMessage, "%s");
            ctx.complete();
        }
    }
}

