/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.server.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.server.SSEServletBehavior;
import kd.ai.httpsse.server.ServletHandler;
import kd.ai.httpsse.utils.ExHandler;
import kd.ai.httpsse.utils.HttpUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SSEServiceExecute
extends SSEServletBehavior {
    private final Log log = LogFactory.getLog(SSEServiceExecute.class);
    private final SSEServiceInfo serviceInfo;

    public SSEServiceExecute(SSEServiceInfo svcInfo) {
        this.serviceInfo = svcInfo;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String json = HttpUtils.getQueryString(request, "args", "[]");
        this.callHandler(json, request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String json = HttpUtils.getRequestBody(request);
        this.callHandler(json, request, response);
    }

    private void callHandler(String json, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.log.info("execute sse service: " + request.getRequestURL());
            String serviceName = this.serviceInfo.getServiceClass();
            ServletHandler handler = ServletHandler.getImpl(serviceName);
            handler.callSSEService(serviceName, json, request, response);
        }
        catch (Exception ex) {
            response.setStatus(500);
            try {
                String friendlyMessage = ExHandler.getFriendlyMessage(ex);
                HttpUtils.outputOnce(response.getOutputStream(), friendlyMessage, SSEConfig.current().getEventErrorFormat());
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
    }
}

