/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.server.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.MServiceNode;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.server.HealthServiceUtils;
import kd.ai.httpsse.server.SSEServletBehavior;
import kd.ai.httpsse.utils.HttpUtils;
import kd.ai.httpsse.utils.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SSEServiceRoute
extends SSEServletBehavior {
    private static final Log log = LogFactory.getLog(SSEServiceRoute.class);
    private final SSEServiceInfo serviceInfo;

    public SSEServiceRoute(SSEServiceInfo svcInfo) {
        this.serviceInfo = svcInfo;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        new Router(request, response).forwardRequest();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        new Router(request, response).forwardRequest();
    }

    private static class Router {
        private static final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(){

            public void shutdown() {
            }
        };
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final SSEServiceInfo serviceInfo;

        public Router(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.serviceInfo = HttpUtils.getService(request);
        }

        public void forwardRequest() throws IOException {
            block40: {
                BasicCookieStore cookieStore = new BasicCookieStore();
                try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();){
                    HttpGet forwardRequest;
                    String targetUrl = this.getForwardUrl();
                    if (this.request.getMethod().equalsIgnoreCase("POST")) {
                        HttpPost postRequest = new HttpPost(targetUrl);
                        String requestContent = HttpUtils.readRequest(this.request);
                        StringEntity entity = new StringEntity(requestContent, "UTF-8");
                        postRequest.setEntity((HttpEntity)entity);
                        forwardRequest = postRequest;
                    } else {
                        forwardRequest = new HttpGet(targetUrl);
                    }
                    Map<String, String> headers = this.getFilteredHeaders();
                    headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)forwardRequest).setHeader(arg_0, arg_1));
                    forwardRequest.addHeader("IS_Forwarded", "true");
                    String traceId = RequestContext.get().getTraceId();
                    if (!StringUtils.isEmpty(traceId)) {
                        forwardRequest.addHeader("traceId", traceId);
                    }
                    HttpUtils.setRequestHeaders((HttpUriRequest)forwardRequest);
                    HttpUtils.setResponseHeaders(this.response, new HashMap<String, String>());
                    try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)forwardRequest);){
                        this.response.setStatus(resp.getStatusLine().getStatusCode());
                        HttpEntity entity = resp.getEntity();
                        if (entity == null) break block40;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                this.response.getOutputStream().println(line);
                                this.response.getOutputStream().flush();
                            }
                        }
                    }
                }
            }
        }

        public Map<String, String> getFilteredHeaders() {
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerNames = this.request.getHeaderNames();
            Set<String> ignoredHeaders = SSEConfig.current().getSSERouterIgnoredHeaders();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (ignoredHeaders.contains(headerName)) continue;
                Enumeration headerValues = this.request.getHeaders(headerName);
                ArrayList values = Collections.list(headerValues);
                headers.put(headerName, String.join((CharSequence)", ", values));
            }
            return headers;
        }

        private String getForwardUrl() {
            try {
                MServiceNode node = SSEConfig.current().getSSEDevEnv() ? new MServiceNode("127.0.0.1", this.serviceInfo.getAppId(), String.valueOf(this.request.getServerPort())) : HealthServiceUtils.getHealthMServiceNode(this.serviceInfo.getAppId());
                String requestURI = this.request.getRequestURI();
                if (StringUtils.isEmpty(requestURI)) {
                    throw new RuntimeException("Request URI is empty");
                }
                URI originalUri = new URI(requestURI);
                String newHost = node.getHost();
                String portStr = node.getPort();
                if (StringUtils.isEmpty(newHost) || StringUtils.isEmpty(portStr)) {
                    throw new RuntimeException("Invalid node configuration: host or port is empty");
                }
                int newPort = Integer.parseInt(portStr);
                String schema = originalUri.getScheme();
                if (StringUtils.isEmpty(schema)) {
                    schema = "http";
                }
                String queryString = this.request.getQueryString();
                String path = originalUri.getPath();
                if (StringUtils.isEmpty(path)) {
                    path = "/";
                }
                URI newUri = new URI(schema, originalUri.getUserInfo(), newHost, newPort, path, queryString, originalUri.getFragment());
                log.info("Forwarding request from {} to {}", (Object)originalUri, (Object)newUri);
                return newUri.toString();
            }
            catch (URISyntaxException e) {
                log.error("Failed to construct forward URL", (Throwable)e);
                throw new RuntimeException("Failed to construct forward URL: " + e.getMessage(), e);
            }
            catch (NumberFormatException e) {
                log.error("Invalid port number", (Throwable)e);
                throw new RuntimeException("Invalid port number: " + e.getMessage(), e);
            }
            catch (Exception e) {
                log.error("Unexpected error while constructing forward URL", (Throwable)e);
                throw new RuntimeException("Unexpected error while constructing forward URL: " + e.getMessage(), e);
            }
        }

        static {
            connManager.setMaxTotal(SSEConfig.current().getSSERouterMaxTotal());
            connManager.setDefaultMaxPerRoute(SSEConfig.current().getSSERouterDefaultMaxPerRoute());
        }
    }
}

