/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.utils.ResourceUtils;

public class ServiceInfoRepo {
    private static final ServiceInfoRepo _current = new ServiceInfoRepo();
    Map<String, SSEServiceInfo> serviceInfoMap = new HashMap<String, SSEServiceInfo>(10);

    public static ServiceInfoRepo current() {
        return _current;
    }

    private ServiceInfoRepo() {
        Properties props = ResourceUtils.loadProperties("sseservices.properties");
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            String[] segments = value.split(",");
            this.serviceInfoMap.put(key, new SSEServiceInfo(segments[0], segments[1]));
        }
    }

    public void register(String svcName, Class<?> svcClazz, String appId) {
        if (this.serviceInfoMap.containsKey(svcName)) {
            throw new IllegalArgumentException("the svcName " + svcName + " is exists");
        }
        this.serviceInfoMap.put(svcName, new SSEServiceInfo(appId, svcClazz.getName()));
    }

    public boolean exists(String svcName) {
        return this.serviceInfoMap.containsKey(svcName);
    }

    public SSEServiceInfo getServiceInfo(String svcName) {
        return this.serviceInfoMap.get(svcName);
    }
}

