/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.service.rx;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.service.rx.SSESubscriber;
import kd.ai.httpsse.utils.ExHandler;
import kd.ai.httpsse.utils.HttpUtils;

public class AsyncHttpSubscriber
implements SSESubscriber<String> {
    private final ServletOutputStream output;
    private final AsyncContext ctx;

    public AsyncHttpSubscriber(AsyncContext ctx) throws IOException {
        this.ctx = ctx;
        this.output = ctx.getResponse().getOutputStream();
    }

    @Override
    public void onNext(String msg) {
        String msgFormat = SSEConfig.current().getEventMessageFormat();
        try {
            HttpUtils.outputOnce(this.output, msg, msgFormat);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onError(Throwable ex) {
        String msgFormat = SSEConfig.current().getEventErrorFormat();
        try {
            String friendlyMessage = ExHandler.getFriendlyMessage(ex);
            HttpUtils.outputOnce(this.output, friendlyMessage, msgFormat);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ctx.complete();
        }
    }

    @Override
    public void onComplete() {
        this.ctx.complete();
    }
}

