/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.httpsse.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.service.ServiceInfoRepo;
import kd.ai.httpsse.utils.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpUtils {
    public static final String FORWARD_KEY = "IS_Forwarded";
    public static final String TRACEID_KEY = "traceId";

    public static boolean getForwarded(HttpServletRequest request) {
        String forwarded = request.getHeader(FORWARD_KEY);
        return Boolean.parseBoolean(forwarded);
    }

    public static void setRequestHeaders(HttpUriRequest request) {
        if (!request.containsHeader("Accept")) {
            request.addHeader("Accept", "text/event-stream");
        }
        if (!request.containsHeader("Cache-Control")) {
            request.addHeader("Cache-Control", "no-cache");
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
        if (!request.containsHeader("Content-Type")) {
            request.addHeader("Content-Type", "application/json;charset=utf-8");
        }
    }

    public static String getQueryString(HttpServletRequest request, String key, String defaultValue) {
        Map map = request.getParameterMap();
        if (map.containsKey(key)) {
            return ((String[])map.get(key))[0];
        }
        return defaultValue;
    }

    public static String getRequestBody(HttpServletRequest request) {
        try {
            return HttpUtils.readRequest(request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSEServiceInfo getService(HttpServletRequest request) {
        String[] items = request.getRequestURI().split("/");
        if (items.length > 1) {
            SSEServiceInfo svcInfo;
            String svcName = request.getParameter("svc");
            if (StringUtils.isEmpty(svcName)) {
                svcName = items[items.length - 1].trim();
            }
            if (StringUtils.isEmpty(svcName)) {
                throw new IllegalArgumentException("Service name is empty");
            }
            if (!StringUtils.validateName(svcName)) {
                throw new IllegalArgumentException("svc name is illegal");
            }
            if (ServiceInfoRepo.current().exists(svcName)) {
                svcInfo = ServiceInfoRepo.current().getServiceInfo(svcName);
            } else {
                if (SSEConfig.current().getDisableSSEServiceClassName()) {
                    throw new RuntimeException("SSEService " + svcName + " is not registered");
                }
                String appId = items[items.length - 2].trim();
                svcInfo = new SSEServiceInfo(appId, svcName);
            }
            return svcInfo;
        }
        throw new IllegalArgumentException("URL illegal, no suitable service name or appId found");
    }

    public static void setResponseHeaders(HttpServletResponse response, Map<String, String> otherHeaders) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/event-stream");
        response.setHeader("Connection", "keep-alive");
        for (Map.Entry<String, String> entry : otherHeaders.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void outputOnce(ServletOutputStream outputStream, String msg, String format) throws IOException {
        if (!StringUtils.isEmpty(format)) {
            msg = String.format(format, msg);
        }
        outputStream.write(StringUtils.toBytes(msg));
        outputStream.flush();
    }

    public static String readRequest(HttpServletRequest request) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
        return HttpUtils.readReader(reader);
    }

    public static String readReader(BufferedReader reader) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }
}

