/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.ai.httpsse.core.SSEConfig;
import kd.ai.httpsse.core.SSEServiceInfo;
import kd.ai.httpsse.server.SSEServer;
import kd.ai.httpsse.server.SSEServletBehavior;
import kd.ai.httpsse.server.ServletHandler;
import kd.ai.httpsse.service.ServiceInfoRepo;
import kd.ai.httpsse.utils.ExHandler;
import kd.ai.httpsse.utils.HttpUtils;
import kd.ai.httpsse.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.spi.ICustomApiServlet;

public class SSEServletApi
implements ICustomApiServlet {
    private static final Log log = LogFactory.getLog(SSEServletApi.class);
    private final ServletHandler handler = ServletHandler.getImpl();

    public String getInputParameter() {
        return null;
    }

    public String getOutputParameter() {
        return null;
    }

    public void doAction(HttpServletRequest request, HttpServletResponse response) {
        try {
            SSEServiceInfo svcInfo;
            String svcName = request.getParameter("svc");
            if (StringUtils.isEmpty(svcName)) {
                throw new IllegalArgumentException("svc is null");
            }
            if (!StringUtils.validateName(svcName)) {
                throw new IllegalArgumentException("svc name is illegal");
            }
            if (ServiceInfoRepo.current().exists(svcName)) {
                svcInfo = ServiceInfoRepo.current().getServiceInfo(svcName);
            } else {
                if (!SSEConfig.current().getDisableSSEServiceClassName()) {
                    throw new RuntimeException("SSEService " + svcName + " is not registered");
                }
                String appId = request.getParameter("appid");
                if (StringUtils.isEmpty(appId)) {
                    appId = "gai";
                }
                svcInfo = new SSEServiceInfo(appId, svcName);
            }
            String method = request.getMethod().toUpperCase();
            log.info("SSEApi request: " + method + ";" + request.getRequestURL());
            SSEServletBehavior behavior = SSEServletBehavior.getImpl(svcInfo, HttpUtils.getForwarded(request));
            if (method.equals("GET")) {
                behavior.doGet(request, response);
            } else if (method.equals("POST")) {
                behavior.doPost(request, response);
            } else {
                response.setStatus(405);
            }
        }
        catch (Throwable th) {
            log.error(th);
            try {
                String friendlyMessage = ExHandler.getFriendlyMessage(th);
                HttpUtils.outputOnce(response.getOutputStream(), friendlyMessage, SSEConfig.current().getEventErrorFormat());
            }
            catch (IOException e) {
                log.error(th);
            }
            response.setStatus(500);
        }
    }

    static {
        SSEServer.current().start();
    }
}

