/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.drivers.common.BOSESConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class BOSESClientManager {
    private Log log = LogFactory.getLog(BOSESClientManager.class);
    private final Map<Integer, RestHighLevelClient> vdbClients = new HashMap<Integer, RestHighLevelClient>();
    private static final BOSESClientManager _current = new BOSESClientManager();

    private BOSESClientManager() {
    }

    public static BOSESClientManager current() {
        return _current;
    }

    public synchronized RestHighLevelClient getOrCreate(VDBClientConfig config, RestClientBuilder restClientBuilder) {
        int hc = BOSESClientManager.getClientHashCode(config);
        if (!this.vdbClients.containsKey(hc)) {
            RestHighLevelClient esclient = new RestHighLevelClient(restClientBuilder);
            this.vdbClients.put(hc, esclient);
        }
        return this.vdbClients.get(hc);
    }

    public synchronized void release(VDBClientConfig config, boolean forced) {
        int hc = BOSESClientManager.getClientHashCode(config);
        if (this.vdbClients.containsKey(hc)) {
            try {
                RestHighLevelClient esClient = this.vdbClients.remove(hc);
                if (forced) {
                    esClient.getLowLevelClient().close();
                    esClient.close();
                }
            }
            catch (IOException ex) {
                this.log.error("close esClient error", (Throwable)ex);
            }
        }
    }

    private static int getClientHashCode(VDBClientConfig config) {
        return Objects.hash(new Object[]{BOSESConfig.current(), config});
    }
}

