/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import kd.ai.vdb.VDBConfig;

public class BOSESConfig
extends VDBConfig {
    private static final BOSESConfig _current = new BOSESConfig();

    protected BOSESConfig() {
    }

    public static BOSESConfig current() {
        return _current;
    }

    public int getBOSEsKeepAliveDuration() {
        return this.getIntProperty("elasticsearch.server.keepAliveDuration", -1);
    }

    public int getBOSEsConnectTimeOut() {
        return this.getIntProperty("elasticsearch.server.connectTimeOut", 5000);
    }

    public int getBOSEsSocketTimeOut() {
        return this.getIntProperty("elasticsearch.server.socketTimeOut", 300000);
    }

    public int getBOSEsMaxRetryTimeOut() {
        return this.getIntProperty("elasticsearch.server.maxRetryTimeOut", 300000);
    }

    public int getMaxConnPerRoute() {
        return this.getIntProperty("ai.vdb.max_conn_per_route", 20);
    }

    public int getMaxConnTotal() {
        return this.getIntProperty("ai.vdb.max_conn_total", 60);
    }

    public int getRequestLogSize() {
        return this.getIntProperty("ai.vdb.request_log_size", 20480);
    }

    public boolean getThrowExWhenInvalidVersion() {
        return this.getBoolProperty("ai.vdb.throwex_when_invalid_vserion", false);
    }

    public String getDefaultTokenizeType() {
        return this.getProperty("ai.vdb.defaulttokenizetype", "ik_max_word");
    }

    public String getDefaultScoreMethod() {
        return this.getProperty("ai.vdb.defaultscoremethod", "BM25");
    }

    public int hashCode() {
        return this.getDefaultScoreMethod().hashCode() * 47 ^ this.getDefaultTokenizeType().hashCode() * 43 ^ this.getBOSEsKeepAliveDuration() * 41 ^ this.getBOSEsConnectTimeOut() * 37 ^ this.getBOSEsSocketTimeOut() * 31 ^ this.getBOSEsMaxRetryTimeOut() * 29 ^ this.getMaxConnPerRoute() * 27 ^ this.getMaxConnTotal() ^ 23 + 19 * (this.getThrowExWhenInvalidVersion() ? 1 : 0);
    }
}

