/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import java.util.ArrayList;
import kd.ai.vdb.BoolOperator;
import kd.ai.vdb.Filter;
import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.drivers.common.BOSESRangeQueryBuilder;
import kd.ai.vdb.drivers.common.FilterTypeChecker;
import kd.ai.vdb.drivers.common.IKTokenizeType;
import kd.ai.vdb.filterImpl.BoolFilter;
import kd.ai.vdb.filterImpl.EqualFilter;
import kd.ai.vdb.filterImpl.InFilter;
import kd.ai.vdb.filterImpl.RangeFilter;
import kd.ai.vdb.filterImpl.TextMatchFilter;
import kd.ai.vdb.filterImpl.VectorFilter;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.TokenizeType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;

public abstract class BOSESFilterVisitor
implements FilterVisitor<QueryBuilder> {
    private final CollectionMeta meta;
    private final FilterTypeChecker checker;

    public BOSESFilterVisitor(CollectionMeta meta) {
        this.meta = meta;
        this.checker = new FilterTypeChecker(meta);
    }

    public QueryBuilder visit(EqualFilter filter) {
        this.checker.checkDataType(filter.getFieldName(), new Object[]{filter.getValue()}, new DataType[]{DataType.STRING, DataType.DOUBLE, DataType.INT, DataType.BYTE, DataType.INT64, DataType.FLOAT, DataType.BOOL, DataType.DATETIME, DataType.TEXT});
        TermQueryBuilder qb = new TermQueryBuilder(filter.getFieldName(), filter.getValue());
        this.setBoost((QueryBuilder)qb, (Filter)filter);
        return qb;
    }

    public QueryBuilder visit(RangeFilter filter) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (filter.getFrom() != null) {
            values.add(filter.getFrom());
        }
        if (filter.getTo() != null) {
            values.add(filter.getTo());
        }
        this.checker.checkDataType(filter.getFieldName(), values.toArray(), new DataType[]{DataType.INT, DataType.BYTE, DataType.INT64, DataType.FLOAT, DataType.BOOL, DataType.DATETIME, DataType.DOUBLE});
        BOSESRangeQueryBuilder rangeQueryBuilder = new BOSESRangeQueryBuilder(this.meta.getField(filter.getFieldName()), filter.getFrom(), filter.isIncludeFrom(), filter.getTo(), filter.isIncludeTo());
        this.setBoost((QueryBuilder)rangeQueryBuilder, (Filter)filter);
        return rangeQueryBuilder;
    }

    public QueryBuilder visit(InFilter filter) {
        this.checker.checkDataType(filter.getFieldName(), filter.getValues(), new DataType[]{DataType.DOUBLE, DataType.INT, DataType.BYTE, DataType.INT64, DataType.FLOAT, DataType.BOOL, DataType.DATETIME, DataType.DOUBLE, DataType.STRING, DataType.TEXT});
        TermsQueryBuilder qb = new TermsQueryBuilder(filter.getFieldName(), filter.getValues());
        this.setBoost((QueryBuilder)qb, (Filter)filter);
        return qb;
    }

    public QueryBuilder visit(BoolFilter filter) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        this.setBoost((QueryBuilder)boolQueryBuilder, (Filter)filter);
        if (filter.getOperator() == BoolOperator.AND) {
            for (Filter f : filter.getFilters()) {
                boolQueryBuilder.must((QueryBuilder)f.accept((FilterVisitor)this));
            }
        } else {
            for (Filter f : filter.getFilters()) {
                boolQueryBuilder.should((QueryBuilder)f.accept((FilterVisitor)this));
            }
        }
        return boolQueryBuilder;
    }

    public QueryBuilder visit(TextMatchFilter filter) {
        this.checker.checkDataType(filter.getFieldName(), new Object[]{filter.getText()}, new DataType[]{DataType.STRING, DataType.TEXT});
        MatchQueryBuilder qb = this.createMatchQueryBuilder(filter);
        this.setBoost((QueryBuilder)qb, (Filter)filter);
        return qb;
    }

    private MatchQueryBuilder createMatchQueryBuilder(TextMatchFilter filter) {
        MatchQueryBuilder qb = new MatchQueryBuilder(filter.getFieldName(), (Object)filter.getText());
        if (filter.getMatchAny()) {
            qb.operator(Operator.OR);
        } else {
            qb.operator(Operator.AND);
        }
        if (filter.getTokenizeType() != TokenizeType.NONE) {
            qb.analyzer(this.getTokenizeType(filter.getTokenizeType()));
        }
        return qb;
    }

    private MatchPhraseQueryBuilder createMatchPhraseQueryBuilder(TextMatchFilter filter) {
        MatchPhraseQueryBuilder qb = new MatchPhraseQueryBuilder(filter.getFieldName(), (Object)filter.getText());
        if (filter.getTokenizeType() != TokenizeType.NONE) {
            qb.analyzer(this.getTokenizeType(filter.getTokenizeType()));
        }
        return qb;
    }

    protected String getTokenizeType(TokenizeType tokenizeType) {
        return IKTokenizeType.from(tokenizeType);
    }

    public QueryBuilder visit(VectorFilter filter) {
        QueryBuilder qb = this.createVectorQueryBuilder(this.meta, filter);
        this.setBoost(qb, (Filter)filter);
        return qb;
    }

    private void setBoost(QueryBuilder qb, Filter filter) {
        if (filter.getBoost() >= 0.0f) {
            qb.boost(filter.getBoost());
        }
    }

    protected abstract QueryBuilder createVectorQueryBuilder(CollectionMeta var1, VectorFilter var2);
}

