/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import java.io.IOException;
import java.util.HashMap;
import kd.ai.vdb.drivers.es.ESVectorSimilarity;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;

public class BOSESRangeQueryBuilder
extends AbstractQueryBuilder<BOSESRangeQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "range";
    private final FieldMeta field;
    private final boolean includeTo;
    private final Object from;
    private final boolean includeFrom;
    private final Object to;

    public BOSESRangeQueryBuilder(FieldMeta field, Object from, boolean includeFrom, Object to, boolean inlcudeTo) {
        if (field == null) {
            throw new IllegalArgumentException("filed must not be null");
        }
        if (from == null && to == null) {
            throw new IllegalArgumentException("any of from to can't be null");
        }
        this.field = field;
        this.from = from;
        this.includeFrom = includeFrom;
        this.to = to;
        this.includeTo = inlcudeTo;
    }

    public static Script buildScript(String destVectorFieldName, double[] destVector, VectorSimilarity similarity) {
        HashMap<String, double[]> params = new HashMap<String, double[]>();
        String func = ESVectorSimilarity.getFunction(similarity);
        params.put("vector", destVector);
        StringBuilder scriptBuilder = new StringBuilder();
        if (similarity == VectorSimilarity.COSINE) {
            scriptBuilder.append("(").append(func).append("(params.vector,'").append(destVectorFieldName).append("') + 1.0) / 2");
        } else if (similarity == VectorSimilarity.L2) {
            scriptBuilder.append("1 / (1 + ").append("Math.pow(").append(func).append("(params.vector, '").append(destVectorFieldName).append("'), 2))");
        }
        return new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", scriptBuilder.toString(), params);
    }

    protected void doWriteTo(StreamOutput streamOutput) throws IOException {
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.field.getName());
        if (this.from != null) {
            if (this.includeFrom) {
                builder.field("gte", this.from);
            } else {
                builder.field("gt", this.from);
            }
        }
        if (this.to != null) {
            if (this.includeTo) {
                builder.field("lte", this.to);
            } else {
                builder.field("lt", this.to);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext queryShardContext) throws IOException {
        return null;
    }

    protected boolean doEquals(BOSESRangeQueryBuilder vectorQueryBuilder) {
        return false;
    }

    protected int doHashCode() {
        return 0;
    }

    public String fieldName() {
        return this.field.getName();
    }

    public String getWriteableName() {
        return null;
    }
}

