/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.vdb.drivers.common.ResponseInfo;

public class BulkResponseInfo {
    @JsonProperty(value="took")
    private int took;
    @JsonProperty(value="errors")
    private boolean errors;
    @JsonProperty(value="items")
    private ResponseInfo[] items;

    public BulkResponseInfo() {
    }

    public BulkResponseInfo(int took, boolean errors, ResponseInfo[] items) {
        this.took = took;
        this.errors = errors;
        this.items = items;
    }

    public int getTook() {
        return this.took;
    }

    public boolean isErrors() {
        return this.errors;
    }

    public ResponseInfo[] getItems() {
        return this.items;
    }

    public String getErrorInfo(boolean simple) {
        HashMap<String, List> errors = new HashMap<String, List>();
        for (ResponseInfo item : this.items) {
            if (item.getIndex() == null || item.getIndex().getError() == null) continue;
            if (simple) {
                errors.computeIfAbsent(item.getIndex().getError().getType(), k -> new ArrayList()).add(item.getIndex().getId());
                continue;
            }
            errors.computeIfAbsent(item.getIndex().getError().getType(), k -> new ArrayList()).add(item.getIndex().getId() + ":" + item.getIndex().getError().getReason());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : errors.entrySet()) {
            sb.append((String)entry.getKey()).append(":").append(String.join((CharSequence)",", (Iterable)entry.getValue())).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

