/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import kd.ai.vdb.objects.CollectionData;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.VectorFieldMeta;
import org.elasticsearch.client.Response;

public class CollectionDataParser {
    public static CollectionData parseQuery(CollectionMeta meta, Response response) throws IOException {
        JsonParser jsonParser = new JsonFactory().createParser(response.getEntity().getContent());
        CollectionData data = new CollectionData(meta);
        String targetField = "hits";
        CollectionDataParser.findNextField(jsonParser, targetField);
        CollectionDataParser.findNextField(jsonParser, targetField);
        CollectionDataParser.parseHits(jsonParser, data);
        return data;
    }

    public static CollectionData parseDocs(CollectionMeta meta, Response response) throws IOException {
        JsonParser jsonParser = new JsonFactory().createParser(response.getEntity().getContent());
        CollectionData data = new CollectionData(meta);
        String targetField = "docs";
        CollectionDataParser.findNextField(jsonParser, targetField);
        CollectionDataParser.parseHits(jsonParser, data);
        return data;
    }

    private static JsonToken findNextField(JsonParser jsonParser, String targetField) throws IOException {
        JsonToken currentToken;
        while ((currentToken = jsonParser.nextToken()) != null) {
            String fieldName;
            if (currentToken != JsonToken.FIELD_NAME || !targetField.equals(fieldName = jsonParser.getCurrentName())) continue;
            return jsonParser.nextToken();
        }
        throw new IllegalStateException("target field not found");
    }

    private static void parseHits(JsonParser jsonParser, CollectionData data) throws IOException {
        JsonToken token = jsonParser.currentToken();
        if (token != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Expected start of array, got: " + token);
        }
        while ((token = jsonParser.nextToken()) != null && token != JsonToken.END_ARRAY) {
            Object[] value = CollectionDataParser.parseRowData(jsonParser, data.getMeta());
            if (value.length <= 0) continue;
            data.append(value);
        }
    }

    private static Object[] parseRowData(JsonParser jsonParser, CollectionMeta meta) throws IOException {
        JsonToken token;
        HashMap<String, Object> map = new HashMap<String, Object>();
        block0: while ((token = jsonParser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                Object value;
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                if (fieldName.equals("_source")) {
                    while ((token = jsonParser.nextToken()) != null) {
                        if (token == JsonToken.FIELD_NAME) {
                            fieldName = jsonParser.getCurrentName();
                            jsonParser.nextToken();
                            if (!meta.contains(fieldName)) continue;
                            value = CollectionDataParser.parseValue(jsonParser, meta.getField(fieldName));
                            map.put(fieldName, value);
                            continue;
                        }
                        if (token != JsonToken.END_OBJECT) continue;
                        continue block0;
                    }
                    continue;
                }
                if (!meta.contains(fieldName)) continue;
                value = CollectionDataParser.parseValue(jsonParser, meta.getField(fieldName));
                map.put(fieldName, value);
                continue;
            }
            if (token != JsonToken.END_OBJECT) continue;
        }
        ArrayList list = new ArrayList();
        if (!map.isEmpty()) {
            for (FieldMeta field : meta.getFields()) {
                list.add(map.get(field.getName()));
            }
        }
        return list.toArray();
    }

    private static Object parseValue(JsonParser jsonParser, FieldMeta field) throws IOException {
        if (jsonParser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        DataType dataType = field.getDataType();
        switch (dataType) {
            case STRING: 
            case TEXT: {
                return jsonParser.getText();
            }
            case BYTE: {
                return jsonParser.getByteValue();
            }
            case INT: {
                return jsonParser.getIntValue();
            }
            case INT64: {
                return jsonParser.getLongValue();
            }
            case FLOAT: {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            case DOUBLE: {
                return jsonParser.getDoubleValue();
            }
            case BOOL: {
                return jsonParser.getBooleanValue();
            }
            case DATETIME: {
                return DataType.parseDate((String)jsonParser.getText());
            }
            case VECTOR: {
                return CollectionDataParser.parseVector(jsonParser, (VectorFieldMeta)field);
            }
        }
        throw new IllegalStateException("Unexpected token: " + jsonParser.currentToken());
    }

    private static Object parseVector(JsonParser jsonParser, VectorFieldMeta field) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Expected start of array, got: " + jsonToken.name());
        }
        DataType vectorType = field.getVectorType();
        if (!DataType.supportVectorType((DataType)vectorType)) {
            throw new IllegalStateException("Unsupported vector type: " + vectorType);
        }
        switch (vectorType) {
            case BYTE: {
                return CollectionDataParser.parseByteVector(jsonParser, field);
            }
            case INT: {
                return CollectionDataParser.parseIntVector(jsonParser, field);
            }
            case INT64: {
                return CollectionDataParser.parseInt64Vector(jsonParser, field);
            }
            case FLOAT: {
                return CollectionDataParser.parseFloatVector(jsonParser, field);
            }
            case DOUBLE: {
                return CollectionDataParser.parseDoubleVector(jsonParser, field);
            }
        }
        throw new IllegalStateException("Unexpected vector type: " + vectorType);
    }

    private static byte[] parseByteVector(JsonParser jsonParser, VectorFieldMeta field) throws IOException {
        JsonToken jsonToken;
        int idx = 0;
        byte[] bytes = new byte[field.getDims()];
        while ((jsonToken = jsonParser.nextToken()) != null && jsonToken != JsonToken.END_ARRAY) {
            bytes[idx++] = jsonParser.getByteValue();
        }
        return bytes;
    }

    private static int[] parseIntVector(JsonParser jsonParser, VectorFieldMeta field) throws IOException {
        JsonToken jsonToken;
        int idx = 0;
        int[] ints = new int[field.getDims()];
        while ((jsonToken = jsonParser.nextToken()) != null && jsonToken != JsonToken.END_ARRAY) {
            ints[idx++] = jsonParser.getIntValue();
        }
        return ints;
    }

    private static long[] parseInt64Vector(JsonParser jsonParser, VectorFieldMeta field) throws IOException {
        JsonToken jsonToken;
        int idx = 0;
        long[] longs = new long[field.getDims()];
        while ((jsonToken = jsonParser.nextToken()) != null && jsonToken != JsonToken.END_ARRAY) {
            longs[idx++] = jsonParser.getLongValue();
        }
        return longs;
    }

    private static float[] parseFloatVector(JsonParser jsonParser, VectorFieldMeta field) throws IOException {
        JsonToken jsonToken;
        int idx = 0;
        float[] floats = new float[field.getDims()];
        while ((jsonToken = jsonParser.nextToken()) != null && jsonToken != JsonToken.END_ARRAY) {
            floats[idx++] = jsonParser.getFloatValue();
        }
        return floats;
    }

    private static double[] parseDoubleVector(JsonParser jsonParser, VectorFieldMeta field) throws IOException {
        JsonToken jsonToken;
        int idx = 0;
        double[] doubles = new double[field.getDims()];
        while ((jsonToken = jsonParser.nextToken()) != null && jsonToken != JsonToken.END_ARRAY) {
            doubles[idx++] = jsonParser.getDoubleValue();
        }
        return doubles;
    }
}

