/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import java.util.HashMap;
import java.util.Map;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;

public class FilterTypeChecker {
    private static final Map<Class<?>, Integer> numericTypeMap = new HashMap();
    private final CollectionMeta meta;

    public FilterTypeChecker(CollectionMeta collectionMeta) {
        this.meta = collectionMeta;
    }

    public void checkDataType(String fieldName, Object[] values, DataType[] dataTypes) {
        FieldMeta field = this.meta.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field not found: " + fieldName);
        }
        if (values == null) {
            throw new IllegalArgumentException("Value is null");
        }
        Class clazz = DataType.getType((DataType)field.getDataType());
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("some value is null");
            }
            if (DataType.isNumberType((DataType)field.getDataType())) {
                if (!numericTypeMap.containsKey(value.getClass())) {
                    throw new IllegalArgumentException("Unsupported data type: " + value.getClass().getName());
                }
                if (numericTypeMap.get(clazz) >= numericTypeMap.get(value.getClass())) continue;
                throw new IllegalArgumentException("Value type mismatch: " + value.getClass().getName() + " expected: " + clazz.getName());
            }
            if (value.getClass().isAssignableFrom(clazz)) continue;
            if (field.getDataType() == DataType.DATETIME && value instanceof String) {
                DataType.parseDate((String)((String)value));
                continue;
            }
            throw new IllegalArgumentException("Value type mismatch: " + value.getClass().getName() + " expected: " + clazz.getName());
        }
        boolean found = false;
        for (DataType dataType : dataTypes) {
            if (field.getDataType() != dataType) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Unsupported data type: " + field.getDataType());
        }
    }

    static {
        int idx = 0;
        numericTypeMap.put(Byte.class, idx++);
        numericTypeMap.put(Short.class, idx++);
        numericTypeMap.put(Integer.class, idx++);
        numericTypeMap.put(Long.class, idx++);
        numericTypeMap.put(Float.class, idx++);
        numericTypeMap.put(Double.class, idx);
    }
}

