/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import java.util.Objects;
import kd.ai.vdb.drivers.es.ES68Config;
import kd.ai.vdb.objects.TokenizeType;
import kd.bos.util.StringUtils;

public class IKTokenizeType {
    public static String from(TokenizeType tokenizeType) {
        if (Objects.requireNonNull(tokenizeType) == TokenizeType.DEFAULT) {
            return ES68Config.current().getDefaultTokenizeType();
        }
        throw new IllegalArgumentException("tokenizeType can't  be NONE");
    }

    public static TokenizeType to(String tokenizeType) {
        if (StringUtils.isEmpty((String)tokenizeType)) {
            return TokenizeType.NONE;
        }
        if (tokenizeType.equalsIgnoreCase(ES68Config.current().getDefaultTokenizeType())) {
            return TokenizeType.DEFAULT;
        }
        throw new IllegalArgumentException("Unsupported tokenizeType:" + tokenizeType);
    }
}

