/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.ai.vdb.JsonUtils;
import org.elasticsearch.client.Response;

public class ResponseParser {
    public static <T> T parse(Response response, Class<T> clazz) {
        try {
            return (T)JsonUtils.toObject((InputStream)response.getEntity().getContent(), clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON object", e);
        }
    }

    public static Map<String, Object> parse(JsonParser jsonParser) {
        try {
            return ResponseParser.parseObject(jsonParser);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse JSON object", e);
        }
    }

    public static Map<String, Object> parseObject(JsonParser jsonParser) throws IOException {
        JsonToken token;
        HashMap<String, Object> map = new HashMap<String, Object>();
        while ((token = jsonParser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                String fieldName = jsonParser.getCurrentName();
                token = jsonParser.nextToken();
                Object value = ResponseParser.parseValue(jsonParser, token);
                map.put(fieldName, value);
                continue;
            }
            if (token != JsonToken.END_OBJECT) continue;
            break;
        }
        return map;
    }

    private static Object parseValue(JsonParser jsonParser, JsonToken token) throws IOException {
        switch (token) {
            case VALUE_STRING: {
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                return jsonParser.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                return ResponseParser.parseObject(jsonParser);
            }
            case START_ARRAY: {
                return ResponseParser.parseArray(jsonParser);
            }
        }
        throw new IllegalStateException("Unexpected token: " + token);
    }

    private static Object[] parseArray(JsonParser jsonParser) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        JsonToken token = jsonParser.nextToken();
        if (token != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Expected start of array, got: " + token);
        }
        while ((token = jsonParser.nextToken()) != null && token != JsonToken.END_ARRAY) {
            Object value = ResponseParser.parseValue(jsonParser, token);
            list.add(value);
        }
        return list.toArray();
    }
}

