/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.common;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import kd.ai.vdb.ArrayTools;
import kd.ai.vdb.EncryptUtils;
import kd.ai.vdb.Filter;
import kd.ai.vdb.JsonUtils;
import kd.ai.vdb.MapUtils;
import kd.ai.vdb.QueryParameters;
import kd.ai.vdb.VDBClient;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.VDBConfig;
import kd.ai.vdb.VDBException;
import kd.ai.vdb.drivers.common.BOSESClientManager;
import kd.ai.vdb.drivers.common.BOSESConfig;
import kd.ai.vdb.drivers.common.BulkResponseInfo;
import kd.ai.vdb.drivers.common.CollectionDataParser;
import kd.ai.vdb.drivers.common.ResponseParser;
import kd.ai.vdb.misc.VDBTraceSpan;
import kd.ai.vdb.objects.CollectionData;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.IdFieldMeta;
import kd.ai.vdb.objects.ScoreFieldMeta;
import kd.ai.vdb.objects.TextFieldMeta;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;

public abstract class VDBBOSESClient
implements VDBClient {
    protected final Log log = LogFactory.getLog(this.getClass());
    private RestHighLevelClient client;
    protected static final String shardsKey = "shardsnumber";
    protected static final String replicasKey = "replicasnumber";
    private static final PoolingNHttpClientConnectionManager connectionManager;
    private VDBClientConfig vdbClientConfig;

    public void init(VDBClientConfig vdbClientConfig) {
        block2: {
            this.vdbClientConfig = vdbClientConfig;
            this.client = this.createClient(vdbClientConfig);
            try {
                this.checkVersion();
            }
            catch (VDBException ex) {
                this.log.error((Throwable)ex);
                if (!BOSESConfig.current().getThrowExWhenInvalidVersion()) break block2;
                throw ex;
            }
        }
    }

    protected abstract void checkVersion();

    protected abstract RestHighLevelClient createClient(VDBClientConfig var1);

    protected int getIntConfig(String item, int defaultValue) {
        if (StringUtils.isEmpty((String)item)) {
            return defaultValue;
        }
        return Integer.parseInt(item);
    }

    protected RestClientBuilder createRestClientBuilder(VDBClientConfig config, Consumer<HttpAsyncClientBuilder> buildActions) {
        return RestClient.builder((HttpHost[])config.getHttpHosts()).setMaxRetryTimeoutMillis(BOSESConfig.current().getBOSEsMaxRetryTimeOut()).setHttpClientConfigCallback(httpClientBuilder -> {
            buildActions.accept(httpClientBuilder);
            int keepAliveDuration = BOSESConfig.current().getBOSEsKeepAliveDuration();
            if (keepAliveDuration > 0) {
                httpClientBuilder.setKeepAliveStrategy((httpResponse, httpContext) -> TimeUnit.SECONDS.toMillis(keepAliveDuration));
            }
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setMaxConnPerRoute(BOSESConfig.current().getMaxConnPerRoute()).setMaxConnTotal(BOSESConfig.current().getMaxConnTotal());
            if (!StringUtils.isEmpty((String)config.getUser())) {
                CredentialsProvider credentialsProvider = this.createCredentialsProvider(config.getUser(), config.getPassword());
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
            return httpClientBuilder;
        }).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(BOSESConfig.current().getBOSEsConnectTimeOut()).setSocketTimeout(BOSESConfig.current().getBOSEsSocketTimeOut()));
    }

    protected CredentialsProvider createCredentialsProvider(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, EncryptUtils.decrypt((String)password)));
        return credentialsProvider;
    }

    protected abstract String buildSearchRequest(CollectionMeta var1, String var2, double[] var3, int var4, Filter var5);

    public void createCollection(CollectionMeta collection) {
        try {
            Request request = new Request("PUT", "/" + this.getIndexName(collection.getName()));
            String mappingJson = Strings.toString((XContentBuilder)this.createFieldMapping(collection));
            request.setJsonEntity(mappingJson);
            Response response = this.performRequest(request);
            Map map = ResponseParser.parse(response, Map.class);
            boolean acknowledged = map.getOrDefault("acknowledged", false);
            if (!acknowledged) {
                throw new VDBException("create collection error");
            }
            if (!this.healthCheck(collection.getName())) {
                throw new VDBException("collection " + collection.getName() + " health status is not yellow or green");
            }
        }
        catch (IOException e) {
            throw new VDBException("create collection error", (Throwable)e);
        }
    }

    protected boolean healthCheck(String collectionName) {
        try {
            ClusterHealthResponse healthResponse = this.client.cluster().health(new ClusterHealthRequest(new String[]{this.getIndexName(collectionName)}).waitForYellowStatus().timeout(TimeValue.timeValueSeconds((long)5L)), RequestOptions.DEFAULT);
            if (healthResponse.getStatus() == ClusterHealthStatus.GREEN) {
                return true;
            }
            if (healthResponse.getStatus() == ClusterHealthStatus.YELLOW) {
                this.log.warn("collection " + collectionName + " health status is yellow");
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract XContentBuilder createFieldMapping(CollectionMeta var1) throws IOException;

    protected abstract XContentBuilder createAddFieldsMapping(String var1, FieldMeta[] var2) throws IOException;

    protected String getIndexName(String collectionName) {
        return (collectionName + "_" + RequestContext.get().getAccountId()).toLowerCase();
    }

    public void dropCollection(String collectionName) {
        Request request = new Request("DELETE", "/" + this.getIndexName(collectionName));
        Response response = this.performRequest(request);
        this.log.warn("dropped collection " + collectionName);
        Map map = ResponseParser.parse(response, Map.class);
        boolean acknowledged = map.getOrDefault("acknowledged", true);
        if (!acknowledged) {
            throw new VDBException("drop collection error");
        }
    }

    public void appendFields(String collectionName, FieldMeta[] fields) {
        try {
            Request request = new Request("PUT", "/" + this.getIndexName(collectionName) + "/_mapping/");
            String mappingJson = Strings.toString((XContentBuilder)this.createAddFieldsMapping(collectionName, fields));
            request.setJsonEntity(mappingJson);
            this.performRequest(request);
        }
        catch (IOException e) {
            throw new VDBException("add fields error", (Throwable)e);
        }
    }

    protected Response performRequest(Request request) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("VDBReq:").append(request.getMethod()).append(":").append(request.getEndpoint());
            if (request.getEntity() != null) {
                sb.append(System.lineSeparator());
                sb.append(this.getEntityContent(request.getEntity()));
            }
            this.log.info(sb.toString());
            Response response = this.client.getLowLevelClient().performRequest(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new VDBException("performRequest error: " + response.getStatusLine().getReasonPhrase());
            }
            if (response.hasWarnings()) {
                sb.setLength(0);
                sb.append("____vdb performRequest Warnings____");
                response.getWarnings().forEach(sb::append);
                this.log.warn(sb.toString());
            }
            return response;
        }
        catch (ElasticsearchStatusException ex) {
            StringBuilder sb = new StringBuilder();
            int status = ex.status().getStatus();
            sb.append("____vdb performRequest error(ElasticsearchStatusExceptionEx)____").append(System.lineSeparator()).append("VDBResp status:").append(status);
            this.log.error(sb.toString());
            throw new VDBException("perform request error:" + status, (Throwable)ex);
        }
        catch (ResponseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("____vdb performRequest error(ResponseEx)____").append(System.lineSeparator()).append("VBDResp:").append(this.getEntityContent(e.getResponse().getEntity()));
            this.log.error(sb.toString());
            sb.setLength(0);
            if (e.getResponse().getStatusLine().getStatusCode() != 200) {
                throw new VDBException("performRequest error: " + e.getResponse().getStatusLine().getReasonPhrase(), (Throwable)e);
            }
            throw new VDBException("performRequest error", (Throwable)e);
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("____vdb performRequest error(IO Ex)____");
            this.log.error(sb.toString());
            sb.setLength(0);
            throw new VDBException("performRequest error", (Throwable)e);
        }
    }

    String getEntityContent(HttpEntity entity) {
        String requestContent = "";
        try {
            if (entity != null) {
                requestContent = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            this.log.error("getEntityContent error", (Throwable)e);
        }
        int maxLen = BOSESConfig.current().getRequestLogSize();
        if (maxLen > 0 && requestContent.length() > maxLen) {
            return requestContent.substring(0, maxLen) + "...";
        }
        return requestContent;
    }

    public CollectionMeta queryMeta(String collectionName) {
        return this.queryMeta(collectionName, null, true);
    }

    public long count(String collectionName) {
        Request request = new Request("GET", "/" + this.getIndexName(collectionName) + "/_count");
        Response response = this.performRequest(request);
        Map map = ResponseParser.parse(response, Map.class);
        return ((Integer)map.get("count")).intValue();
    }

    public void insert(String collectionName, String[] fields, Object[][] rows) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("fields is null");
        }
        if (!fields[0].equals("_id")) {
            throw new IllegalArgumentException("id field must be first field");
        }
        String[] queryFields = new String[fields.length - 1];
        System.arraycopy(fields, 1, queryFields, 0, queryFields.length);
        CollectionMeta meta = this.queryMeta(collectionName, queryFields, false);
        CollectionData data = new CollectionData(meta);
        for (Object[] row : rows) {
            data.append(row);
        }
        this.insert(data);
    }

    public void insert(CollectionData collectionData) {
        if (collectionData == null) {
            throw new IllegalArgumentException("collectionData is null");
        }
        if (collectionData.getMeta().getIdField() == null) {
            throw new IllegalArgumentException("id field not found");
        }
        if (collectionData.size() == 0) {
            throw new IllegalArgumentException("collectionData size is zero");
        }
        Request request = new Request("POST", "/_bulk");
        StringBuilder sb = this.buildBulkInsertRequest(collectionData);
        request.setJsonEntity(sb.toString());
        try (VDBTraceSpan vts = new VDBTraceSpan("ai.vdb.insert", this.buildInsertParameter(collectionData));){
            Response response = this.performRequest(request);
            sb.setLength(0);
            BulkResponseInfo info = ResponseParser.parse(response, BulkResponseInfo.class);
            if (info.isErrors()) {
                this.log.error("vdb insert data error:" + JsonUtils.toJson((Object)info));
                throw new VDBException("insert data error:" + info.getErrorInfo(true));
            }
        }
    }

    private String buildInsertParameter(CollectionData collectionData) {
        return "{meta:" + collectionData.getMeta().toString() + ",rows:" + collectionData.size() + "}";
    }

    private StringBuilder buildBulkInsertRequest(CollectionData collectionData) {
        StringBuilder sb = new StringBuilder();
        String indexName = this.getIndexName(collectionData.getMeta().getName());
        for (int i = 0; i < collectionData.size(); ++i) {
            sb.append("{ \"index\": { \"_index\": \"").append(indexName).append("\", \"_id\": \"").append(collectionData.getId(i)).append("\" } }").append(System.lineSeparator());
            sb.append("{");
            FieldMeta[] fieldMetas = collectionData.getMeta().getFields();
            for (int j = 0; j < fieldMetas.length; ++j) {
                FieldMeta field = fieldMetas[j];
                if (field.isSystemField()) continue;
                String fieldName = field.getName();
                String fieldValue = JsonUtils.getJsonValue((FieldMeta)collectionData.getMeta().getField(fieldName), (Object)collectionData.getValue(i, fieldName));
                sb.append("\"").append(fieldName).append("\":").append(fieldValue);
                if (j != fieldMetas.length - 1) {
                    sb.append(",");
                    continue;
                }
                sb.append("}").append(System.lineSeparator());
            }
            sb.append(System.lineSeparator());
        }
        return sb;
    }

    public void delete(String collectionName, Object[] ids) {
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (ArrayUtils.isEmpty((Object[])ids)) {
            throw new IllegalArgumentException("ids is empty");
        }
        StringBuilder sb = new StringBuilder();
        Request request = new Request("POST", "/_bulk");
        for (Object id : ids) {
            sb.append("{\"delete\": {\"_index\": \"").append(this.getIndexName(collectionName)).append("\", \"_id\": \"").append(id).append("\"}}").append(System.lineSeparator());
        }
        request.setJsonEntity(sb.toString());
        sb.setLength(0);
        try (VDBTraceSpan vts = new VDBTraceSpan("ai.vdb.delete", "ids:" + Arrays.toString(ids));){
            Response response = this.performRequest(request);
            this.log.warn("delete ids [" + Arrays.toString(ids) + "] by" + RequestContext.get().getUserName());
            BulkResponseInfo info = ResponseParser.parse(response, BulkResponseInfo.class);
            if (info.isErrors()) {
                this.log.error("delete data error:" + JsonUtils.toJson((Object)info));
                throw new VDBException("delete data error:" + info.getErrorInfo(true));
            }
        }
    }

    public long delete(String collectionName, Filter filter) {
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        CollectionMeta collectionAll = this.queryMeta(collectionName, null, false);
        QueryBuilder qb = this.createFilterQueryBuilder(collectionAll, filter);
        String sb = "{\"query\":" + qb.toString() + "}";
        return this.deleteByFilterExp(collectionName, sb);
    }

    public long deleteAll(String collectionName) {
        String query = "{\"query\": {\"match_all\": {}}}";
        return this.deleteByFilterExp(collectionName, query);
    }

    private long deleteByFilterExp(String collectionName, String filterExp) {
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (StringUtils.isEmpty((String)filterExp)) {
            throw new IllegalArgumentException("filter is empty");
        }
        String path = "/" + this.getIndexName(collectionName) + "/_delete_by_query";
        Request request = new Request("POST", path);
        request.setJsonEntity(filterExp);
        try (VDBTraceSpan vts = new VDBTraceSpan("ai.vdb.delete", "deleteAll");){
            Response response = this.performRequest(request);
            Map map = ResponseParser.parse(response, Map.class);
            long total = ((Integer)map.get("deleted")).intValue();
            this.log.warn("deleted by query:{},{},{}", new Object[]{collectionName, filterExp, total});
            long l = total;
            return l;
        }
    }

    public void close(boolean forced) {
        if (forced || this.canBeClose()) {
            BOSESClientManager.current().release(this.vdbClientConfig, forced);
        }
    }

    public void close() {
        if (this.canBeClose()) {
            this.close(false);
        }
    }

    protected abstract boolean canBeClose();

    public CollectionData search(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields) {
        return this.search(collectionName, destVectorFieldName, destVector, topk, selectFields, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CollectionData search(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields, Filter filter) {
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (StringUtils.isEmpty((String)destVectorFieldName)) {
            throw new IllegalArgumentException("search VectorField name is empty");
        }
        if (destVector == null) throw new IllegalArgumentException("search vector is empty");
        if (destVector.length == 0) {
            throw new IllegalArgumentException("search vector is empty");
        }
        if (topk <= 0) {
            throw new IllegalArgumentException("topk must big than zero");
        }
        try {
            CollectionMeta collectionAll = this.queryMeta(collectionName, null, true);
            CollectionMeta collection = ArrayUtils.isEmpty((Object[])selectFields) ? collectionAll : collectionAll.subOf(selectFields);
            String traceParameter = this.buildSearchParameter(collectionName, destVectorFieldName, destVector, topk, selectFields, filter);
            try (VDBTraceSpan vts = new VDBTraceSpan("ai.vdb.search", traceParameter);){
                Request request = new Request("POST", "/" + this.getIndexName(collection.getName()) + "/_search");
                String script = this.buildSearchRequest(collectionAll, destVectorFieldName, destVector, topk, filter);
                request.setJsonEntity(script);
                Response response = this.performRequest(request);
                CollectionData collectionData = CollectionDataParser.parseQuery(collection, response);
                return collectionData;
            }
        }
        catch (IOException e) {
            throw new VDBException("search vector error", (Throwable)e);
        }
    }

    private String buildSearchParameter(String collectionName, String destVectorFieldName, double[] destVector, int topk, String[] selectFields, Filter filter) {
        int maxDims = VDBConfig.current().getTraceMaxDims();
        return collectionName + "{" + destVectorFieldName + ":" + ArrayTools.arrayToString((double[])destVector, (int)maxDims) + ",topk:" + topk + ",selectFields:" + Arrays.toString(selectFields) + ",filter:" + (filter == null ? "" : filter.toString()) + "}";
    }

    public CollectionData query(String collectionName, int top, String[] selectFields) {
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (top <= 0) {
            throw new IllegalArgumentException("top must big than zero");
        }
        return this.query(collectionName, top, 0, selectFields);
    }

    public CollectionData query(String collectionName, int limit, int offset, String[] selectFields) {
        return this.query(new QueryParameters(collectionName, offset, limit, selectFields));
    }

    public CollectionData queryByIds(String collectionName, Object[] ids, String[] selectFields) {
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (ArrayUtils.isEmpty((Object[])ids)) {
            throw new IllegalArgumentException("ids is null");
        }
        try {
            CollectionMeta meta = this.queryMeta(collectionName, selectFields, true);
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
            jsonBuilder.startObject();
            jsonBuilder.startArray("docs");
            for (Object id : ids) {
                jsonBuilder.startObject();
                jsonBuilder.field("_id", id);
                if (!ArrayUtils.isEmpty((Object[])selectFields)) {
                    jsonBuilder.field("_source", (Object)selectFields);
                }
                jsonBuilder.endObject();
            }
            jsonBuilder.endArray();
            jsonBuilder.endObject();
            Request request = new Request("GET", "/" + this.getIndexName(collectionName) + "/_mget");
            request.setJsonEntity(Strings.toString((XContentBuilder)jsonBuilder));
            Response response = this.performRequest(request);
            return CollectionDataParser.parseDocs(meta, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CollectionData query(QueryParameters parameters) {
        String collectionName = parameters.getCollectionName();
        int limit = parameters.getLimit();
        int offset = parameters.getOffset();
        Object[] selectFields = parameters.getSelectFields();
        if (StringUtils.isEmpty((String)collectionName)) {
            throw new IllegalArgumentException("collection name is empty");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must big than zero");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must big than zero");
        }
        CollectionMeta collectionAll = this.queryMeta(collectionName, null, true);
        CollectionMeta collection = ArrayUtils.isEmpty((Object[])selectFields) ? collectionAll : collectionAll.subOf((String[])selectFields);
        try {
            Request request = new Request("POST", "/" + this.getIndexName(collectionName) + "/_search?from=" + offset + "&size=" + limit);
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (!ArrayUtils.isEmpty((Object[])parameters.getSelectFields())) {
                sb.append("\"_source\":{");
                sb.append("\"includes\":");
                sb.append(JsonUtils.jsonArray((String[])parameters.getSelectFields()));
                sb.append("}");
                sb.append(",");
            }
            if (parameters.getFilter() != null) {
                QueryBuilder qb = this.createFilterQueryBuilder(collectionAll, parameters.getFilter());
                sb.append("\"query\":");
                sb.append(qb.toString());
            } else {
                sb.append("\"query\": {\"match_all\": {}}");
            }
            sb.append("}");
            request.setJsonEntity(sb.toString());
            try (VDBTraceSpan vts = new VDBTraceSpan("ai.vdb.query", parameters.toString());){
                Response response = this.performRequest(request);
                CollectionData collectionData = CollectionDataParser.parseQuery(collection, response);
                return collectionData;
            }
        }
        catch (IOException e) {
            throw new VDBException("query data error", (Throwable)e);
        }
    }

    protected abstract QueryBuilder createFilterQueryBuilder(CollectionMeta var1, Filter var2);

    private CollectionMeta queryMeta(String collectionName, String[] fields, boolean withScoreField) {
        Map mappings;
        String indexName = this.getIndexName(collectionName);
        Request request = new Request("GET", "/" + indexName + "/_mapping");
        Response response = this.performRequest(request);
        CollectionMeta collection = new CollectionMeta();
        collection.setName(collectionName);
        collection.addField((FieldMeta)new IdFieldMeta());
        if (withScoreField) {
            collection.addField((FieldMeta)new ScoreFieldMeta());
        }
        if (MapUtils.isEmpty((Map)(mappings = ResponseParser.parse(response, Map.class)))) {
            throw new VDBException("collection not found");
        }
        Map properties = (Map)MapUtils.getNestedMapValue((Map)mappings, (String[])new String[]{indexName, "mappings", "properties"});
        if (MapUtils.isEmpty((Map)properties)) {
            throw new VDBException("properties not found");
        }
        if (fields == null) {
            fields = properties.keySet().toArray(new String[0]);
        }
        for (String field : fields) {
            Map mapping = (Map)properties.get(field);
            if (mapping == null) {
                throw new VDBException("field " + field + " not found");
            }
            DataType dataType = this.getDataType(mapping.get("type").toString());
            if (dataType == DataType.VECTOR) {
                collection.addField((FieldMeta)this.buildVectorField(mapping, field));
                continue;
            }
            if (dataType == DataType.TEXT) {
                collection.addField((FieldMeta)this.buildTextField(mapping, field));
                continue;
            }
            collection.addField(new FieldMeta(field, dataType, true));
        }
        return collection;
    }

    public boolean existsCollection(String collectionName) {
        String indexName = this.getIndexName(collectionName);
        Request request = new Request("HEAD", "/" + indexName);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            return response.getStatusLine().getStatusCode() == 200;
        }
        catch (IOException e) {
            throw new VDBException("existsCollection error", (Throwable)e);
        }
    }

    protected String getVersion() {
        Request request = new Request("GET", "/");
        Response response = this.performRequest(request);
        Map map = ResponseParser.parse(response, Map.class);
        Object version = map.get("version");
        if (version instanceof Map) {
            return (String)((Map)version).get("number");
        }
        throw new VDBException("version info can't be validated:" + JsonUtils.toJson((Object)map));
    }

    protected boolean containsPlugin(String pluginName) {
        Request request = new Request("GET", "/_cat/plugins");
        Response response = this.performRequest(request);
        try {
            String pluginsInfo = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            return pluginsInfo.contains(pluginName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract DataType getDataType(String var1);

    protected abstract VectorFieldMeta buildVectorField(Map<String, Object> var1, String var2);

    protected abstract TextFieldMeta buildTextField(Map<String, Object> var1, String var2);

    static {
        try {
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 10).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            connectionManager.setMaxTotal(BOSESConfig.current().getMaxConnTotal());
        }
        catch (IOReactorException e) {
            throw new VDBException("create PoolingNHttpClientConnectionManager error", (Throwable)e);
        }
    }
}

