/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import kd.ai.vdb.Filter;
import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.VDBException;
import kd.ai.vdb.drivers.common.BOSESClientManager;
import kd.ai.vdb.drivers.common.IKTokenizeType;
import kd.ai.vdb.drivers.common.VDBBOSESClient;
import kd.ai.vdb.drivers.es.ES68Config;
import kd.ai.vdb.drivers.es.ESDataType;
import kd.ai.vdb.drivers.es.ESFilterVisitor;
import kd.ai.vdb.drivers.es.ESVectorQueryBuilder;
import kd.ai.vdb.drivers.es.ESVectorSimilarity;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.ServerFeatures;
import kd.ai.vdb.objects.TextFieldMeta;
import kd.ai.vdb.objects.TokenizeType;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.elasticsearch.factory.ElasticSearchFactory;
import kd.bos.util.StringUtils;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;

public class ES68Client
extends VDBBOSESClient {
    private boolean isSingleInstance = false;
    private int defaultShards = 5;
    private int defaultReplicas = 2;

    @Override
    protected RestHighLevelClient createClient(VDBClientConfig vdbClientConfig) {
        RestHighLevelClient client;
        String region = vdbClientConfig.getProperty("ai.es.region");
        int defaultShards = 5;
        int defaultReplicas = 2;
        this.isSingleInstance = true;
        if (!StringUtils.isEmpty((String)region)) {
            client = ElasticSearchFactory.getEsClient((String)region);
            Map bosConfig = ElasticSearchFactory.getServerConfig((String)region);
            this.defaultShards = this.getIntConfig((String)bosConfig.get("shardsnumber"), defaultShards);
            this.defaultReplicas = this.getIntConfig((String)bosConfig.get("replicasnumber"), defaultReplicas);
        } else {
            client = this.createHighLevelClient(vdbClientConfig);
            this.defaultShards = this.getIntConfig(vdbClientConfig.getProperty("shardsnumber"), defaultShards);
            this.defaultReplicas = this.getIntConfig(vdbClientConfig.getProperty("replicasnumber"), defaultReplicas);
        }
        if (this.defaultShards < 1) {
            throw new IllegalArgumentException("shards can't less than 1");
        }
        if (this.defaultReplicas < 0) {
            throw new IllegalArgumentException("replicas must big than 0");
        }
        try {
            if (!client.ping(RequestOptions.DEFAULT)) {
                throw new VDBException("ping server failed");
            }
            return client;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RestHighLevelClient createHighLevelClient(VDBClientConfig config) {
        if (ArrayUtils.isEmpty((Object[])config.getHosts())) {
            throw new IllegalArgumentException("must have one host at least ");
        }
        RestClientBuilder restClientBuilder = this.createRestClientBuilder(config, httpAsyncClientBuilder -> {
            if (StringUtils.isEmpty((String)config.getUser())) {
                httpAsyncClientBuilder.disableAuthCaching();
            } else {
                httpAsyncClientBuilder.setDefaultCredentialsProvider(this.createCredentialsProvider(config.getUser(), config.getPassword()));
            }
            httpAsyncClientBuilder.setSSLContext(this.createSslContext(config));
        });
        return BOSESClientManager.current().getOrCreate(config, restClientBuilder);
    }

    private SSLContext createSslContext(VDBClientConfig config) {
        SSLContext sslContext;
        try {
            if (config.getHosts()[0].isHttps()) {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                sslContext = sslContextBuilder.build();
            } else {
                sslContext = null;
            }
        }
        catch (Exception e) {
            sslContext = null;
        }
        return sslContext;
    }

    @Override
    protected void checkVersion() {
        this.validVersion();
    }

    protected boolean validVersion() {
        boolean valid;
        String verNumber = this.getVersion();
        boolean bl = valid = verNumber.startsWith("8.15") || verNumber.startsWith("8.16") || verNumber.startsWith("8.17");
        if (!valid) {
            this.log.warn("invalidate ES version:" + verNumber + " , only support 8.15.x, 8.16.x, 8.17.x");
        }
        return valid;
    }

    public Set<ServerFeatures> getFeatures() {
        String ikPluginName;
        HashSet<ServerFeatures> features = new HashSet<ServerFeatures>();
        if (this.validVersion()) {
            features.add(ServerFeatures.VECTOR_SEARCH);
        }
        if (this.containsPlugin(ikPluginName = "analysis-ik")) {
            features.add(ServerFeatures.KEYWORD_SEARCH);
        }
        return features;
    }

    @Override
    protected String buildSearchRequest(CollectionMeta collection, String destVectorFieldName, double[] destVector, int topk, Filter filter) {
        String fmt = "{\"size\":%d,\"query\": {\"script_score\": {\"query\": %s,\"script\":%s }}}";
        VectorSimilarity similarity = collection.getVectorField(destVectorFieldName).getSimilarity();
        Script script = ESVectorQueryBuilder.buildScript(destVectorFieldName, destVector, similarity);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("source", script.getIdOrCode());
        jsonMap.put("params", script.getParams());
        ObjectMapper mapper = new ObjectMapper();
        try {
            String query = filter == null ? "{\"match_all\": {}}" : ((QueryBuilder)filter.accept((FilterVisitor)new ESFilterVisitor(collection))).toString();
            String jsonScript = mapper.writeValueAsString(jsonMap);
            return String.format(fmt, topk, query, jsonScript);
        }
        catch (IOException e) {
            throw new VDBException("buildRequestJson error", (Throwable)e);
        }
    }

    @Override
    protected XContentBuilder createFieldMapping(CollectionMeta collection) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        int shards = this.defaultShards;
        if (collection.getShards() > 0) {
            shards = collection.getShards();
        }
        int replicas = this.defaultReplicas;
        if (collection.getReplicas() >= 0) {
            replicas = collection.getReplicas();
        }
        builder.startObject();
        builder.startObject("settings").field("number_of_shards", shards).field("number_of_replicas", replicas);
        builder.startObject("similarity").startObject("default").field("type", ES68Config.current().getDefaultScoreMethod()).endObject().endObject();
        builder.endObject();
        builder.startObject("mappings");
        builder.startObject("properties");
        ES68Client.appendFieldMetas(builder, collection.getFields());
        builder.endObject();
        builder.field("dynamic", ES68Config.current().getDynamicMode());
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static void appendFieldMetas(XContentBuilder builder, FieldMeta[] fields) throws IOException {
        for (FieldMeta field : fields) {
            if (field instanceof VectorFieldMeta && ((VectorFieldMeta)field).getVectorType() != DataType.DOUBLE) {
                throw new VDBException("ES vector field must be double type");
            }
            if (field.isSystemField()) continue;
            builder.startObject(field.getName());
            builder.field("type", ESDataType.from(field.getDataType()));
            if (field instanceof VectorFieldMeta) {
                builder.field("dims", ((VectorFieldMeta)field).getDims());
                builder.field("similarity", ESVectorSimilarity.toStoreSimilarity(((VectorFieldMeta)field).getSimilarity()));
            } else if (field instanceof TextFieldMeta) {
                TokenizeType tokenizeType = ((TextFieldMeta)field).getTokenizeType();
                if (tokenizeType == TokenizeType.NONE) {
                    builder.field("index", false);
                } else {
                    builder.field("index", true);
                    builder.field("analyzer", IKTokenizeType.from(((TextFieldMeta)field).getTokenizeType()));
                }
            }
            builder.endObject();
        }
    }

    @Override
    protected XContentBuilder createAddFieldsMapping(String collectionName, FieldMeta[] fields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject("properties");
        ES68Client.appendFieldMetas(builder, fields);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    protected boolean canBeClose() {
        return !this.isSingleInstance;
    }

    @Override
    protected QueryBuilder createFilterQueryBuilder(CollectionMeta meta, Filter filter) {
        return (QueryBuilder)filter.accept((FilterVisitor)new ESFilterVisitor(meta));
    }

    @Override
    protected DataType getDataType(String dataType) {
        return ESDataType.to(dataType);
    }

    @Override
    protected VectorFieldMeta buildVectorField(Map<String, Object> mapping, String field) {
        int dims = (Integer)mapping.get("dims");
        String similarity = (String)mapping.get("similarity");
        VectorSimilarity vectorSimilarity = ESVectorSimilarity.fromStoreSimilarity(similarity);
        return new VectorFieldMeta(field, DataType.FLOAT, dims, vectorSimilarity);
    }

    @Override
    protected TextFieldMeta buildTextField(Map<String, Object> mapping, String field) {
        boolean index = (Boolean)mapping.getOrDefault("index", true);
        if (index) {
            String analyzer = (String)mapping.get("analyzer");
            return FieldMeta.text((String)field, (TokenizeType)IKTokenizeType.to(analyzer));
        }
        return FieldMeta.text((String)field, (TokenizeType)TokenizeType.NONE);
    }
}

