/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.es;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.ai.vdb.NotSupportedException;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.VectorFieldMeta;

public class ESDataType {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    public static String from(DataType dataType) {
        switch (dataType) {
            case BYTE: {
                return "byte";
            }
            case INT: {
                return "integer";
            }
            case INT64: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: {
                return "keyword";
            }
            case TEXT: {
                return "text";
            }
            case DATETIME: {
                return "date";
            }
            case BOOL: {
                return "boolean";
            }
            case VECTOR: {
                return "dense_vector";
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    public static DataType to(String esDataType) {
        switch (esDataType) {
            case "byte": {
                return DataType.BYTE;
            }
            case "integer": {
                return DataType.INT;
            }
            case "long": {
                return DataType.INT64;
            }
            case "float": {
                return DataType.FLOAT;
            }
            case "double": {
                return DataType.DOUBLE;
            }
            case "keyword": {
                return DataType.STRING;
            }
            case "text": {
                return DataType.TEXT;
            }
            case "date": {
                return DataType.DATETIME;
            }
            case "boolean": {
                return DataType.BOOL;
            }
            case "dense_vector": {
                return DataType.VECTOR;
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + esDataType);
    }

    public static Object getRealValue(FieldMeta field, Object value) {
        DataType dt = field.getDataType();
        if (value == null) {
            return dt.getDefaultValue();
        }
        switch (dt) {
            case STRING: 
            case TEXT: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case BYTE: {
                if (value instanceof Integer) {
                    return ((Integer)value).byteValue();
                }
                if (!(value instanceof Byte)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case INT: {
                if (!(value instanceof Integer)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case INT64: {
                if (!(value instanceof Long)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case FLOAT: {
                if (!(value instanceof Float)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case DOUBLE: {
                if (!(value instanceof Double)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case VECTOR: {
                if (field instanceof VectorFieldMeta) {
                    VectorFieldMeta vcf = (VectorFieldMeta)field;
                    double[] ret = new double[vcf.getDims()];
                    Object[] sourceItems = ((ArrayList)value).toArray();
                    if (sourceItems.length != vcf.getDims()) {
                        throw new IllegalArgumentException("vector dims not match field dims");
                    }
                    for (int i = 0; i < vcf.getDims(); ++i) {
                        ret[i] = (Double)sourceItems[i];
                    }
                    return ret;
                }
                throw new IllegalArgumentException("field type must be VectorColField");
            }
            case BOOL: {
                if (!(value instanceof Boolean)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
            case DATETIME: {
                if (value instanceof String) {
                    try {
                        return dateFormat.parse(value.toString());
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!(value instanceof Date)) {
                    throw new IllegalArgumentException("value type not match field type");
                }
                return value;
            }
        }
        throw new NotSupportedException();
    }
}

