/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.es;

import java.io.IOException;
import java.util.HashMap;
import kd.ai.vdb.drivers.es.ESVectorSimilarity;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;

public class ESVectorQueryBuilder
extends AbstractQueryBuilder<ESVectorQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "knn";
    private final double[] findVector;
    private final VectorFieldMeta vectorField;
    private final int topK;

    public ESVectorQueryBuilder(VectorFieldMeta vectorField, double[] vectors, int topK, float boost) {
        if (vectorField == null) {
            throw new IllegalArgumentException("vectorField must not be null");
        }
        if (vectors == null) {
            throw new IllegalArgumentException("vectors must not be null");
        }
        if (topK <= 0) {
            throw new IllegalArgumentException("topK must be greater than 0");
        }
        if (vectors.length != vectorField.getDims()) {
            throw new IllegalArgumentException("vectors length must be equal to vectorField dimension");
        }
        this.vectorField = vectorField;
        this.findVector = vectors;
        this.topK = topK;
        this.boost(boost);
    }

    public static Script buildScript(String destVectorFieldName, double[] destVector, VectorSimilarity similarity) {
        HashMap<String, double[]> params = new HashMap<String, double[]>();
        String func = ESVectorSimilarity.getFunction(similarity);
        params.put("vector", destVector);
        StringBuilder scriptBuilder = new StringBuilder();
        if (similarity == VectorSimilarity.COSINE) {
            scriptBuilder.append("(").append(func).append("(params.vector,'").append(destVectorFieldName).append("') + 1.0) / 2");
        } else if (similarity == VectorSimilarity.L2) {
            scriptBuilder.append("1 / (1 + ").append("Math.pow(").append(func).append("(params.vector, '").append(destVectorFieldName).append("'), 2))");
        }
        return new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", scriptBuilder.toString(), params);
    }

    protected void doWriteTo(StreamOutput streamOutput) throws IOException {
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field("field", this.vectorField.getName());
        builder.field("query_vector", (Object)this.findVector);
        builder.field("k", this.topK);
        builder.field("num_candidates", this.topK * 5);
        if (this.boost >= 0.0f) {
            this.printBoostAndQueryName(builder);
        }
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext queryShardContext) throws IOException {
        return null;
    }

    protected boolean doEquals(ESVectorQueryBuilder vectorQueryBuilder) {
        return false;
    }

    protected int doHashCode() {
        return 0;
    }

    public String fieldName() {
        return this.vectorField.getName();
    }

    public String getWriteableName() {
        return null;
    }
}

