/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.hw;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.ai.vdb.Filter;
import kd.ai.vdb.FilterVisitor;
import kd.ai.vdb.VDBClientConfig;
import kd.ai.vdb.VDBException;
import kd.ai.vdb.drivers.common.BOSESClientManager;
import kd.ai.vdb.drivers.common.IKTokenizeType;
import kd.ai.vdb.drivers.common.VDBBOSESClient;
import kd.ai.vdb.drivers.hw.HWOS13Config;
import kd.ai.vdb.drivers.hw.HWOSDataType;
import kd.ai.vdb.drivers.hw.HWOSFilterVisitor;
import kd.ai.vdb.drivers.hw.HWOSVectorQueryBuilder;
import kd.ai.vdb.drivers.hw.HWOSVectorSimilarity;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.ai.vdb.objects.ServerFeatures;
import kd.ai.vdb.objects.TextFieldMeta;
import kd.ai.vdb.objects.TokenizeType;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;

public class HWOS13Client
extends VDBBOSESClient {
    private int defaultShards = 5;
    private int defaultReplicas = 2;
    private final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    @Override
    protected void checkVersion() {
    }

    @Override
    protected RestHighLevelClient createClient(VDBClientConfig config) {
        SSLContext sc;
        this.defaultShards = this.getIntConfig(config.getProperty("shardsnumber"), this.defaultShards);
        this.defaultReplicas = this.getIntConfig(config.getProperty("replicasnumber"), this.defaultReplicas);
        try {
            sc = SSLContext.getInstance("TLS");
            sc.init(null, this.trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new VDBException("init hw opensearch client error", (Throwable)e);
        }
        SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sc, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        RestClientBuilder builder = this.createRestClientBuilder(config, httpClientBuilder -> {
            httpClientBuilder.disableAuthCaching();
            if (config.getHosts()[0].isHttps()) {
                httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
            }
            httpClientBuilder.setDefaultCredentialsProvider(this.createCredentialsProvider(config.getUser(), config.getPassword()));
        });
        RestHighLevelClient client = BOSESClientManager.current().getOrCreate(config, builder);
        try {
            if (!client.ping(RequestOptions.DEFAULT)) {
                throw new VDBException("ping huawei opensearch failed");
            }
            return client;
        }
        catch (IOException e) {
            throw new VDBException("connect huawei opensearch error", (Throwable)e);
        }
    }

    @Override
    protected String buildSearchRequest(CollectionMeta collection, String destVectorFieldName, double[] destVector, int topk, Filter filter) {
        String fmt = "{\"size\":%d,\"query\": {\"script_score\": {\"query\": %s,\"script\":%s }}}";
        VectorSimilarity similarity = collection.getVectorField(destVectorFieldName).getSimilarity();
        Script script = HWOSVectorQueryBuilder.buildScript(destVectorFieldName, destVector, similarity);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("source", script.getIdOrCode());
        jsonMap.put("params", script.getParams());
        ObjectMapper mapper = new ObjectMapper();
        try {
            String query = filter == null ? "{\"match_all\": {}}" : ((QueryBuilder)filter.accept((FilterVisitor)new HWOSFilterVisitor(collection))).toString();
            String jsonScript = mapper.writeValueAsString(jsonMap);
            return String.format(fmt, topk, query, jsonScript);
        }
        catch (IOException e) {
            throw new VDBException("buildRequestJson error", (Throwable)e);
        }
    }

    @Override
    protected XContentBuilder createFieldMapping(CollectionMeta collection) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        int shards = this.defaultShards;
        if (collection.getShards() > 0) {
            shards = collection.getShards();
        }
        int replicas = this.defaultReplicas;
        if (collection.getReplicas() >= 0) {
            replicas = collection.getReplicas();
        }
        builder.startObject();
        builder.startObject("settings").field("index.vector", collection.hasVector()).field("index.number_of_shards", shards).field("index.number_of_replicas", replicas).endObject();
        builder.startObject("mappings");
        builder.field("dynamic", HWOS13Config.current().getDynamicMode());
        builder.startObject("properties");
        HWOS13Client.appendFieldMetas(builder, collection.getFields());
        builder.endObject().endObject().endObject();
        return builder;
    }

    private static void appendFieldMetas(XContentBuilder builder, FieldMeta[] fields) throws IOException {
        for (FieldMeta field : fields) {
            if (field instanceof VectorFieldMeta && ((VectorFieldMeta)field).getVectorType() != DataType.DOUBLE) {
                throw new VDBException("vector field must be double type");
            }
            if (field.isSystemField()) continue;
            builder.startObject(field.getName());
            builder.field("type", HWOSDataType.from(field.getDataType()));
            if (field instanceof VectorFieldMeta) {
                builder.field("indexing", true);
                builder.field("dimension", ((VectorFieldMeta)field).getDims());
                builder.field("metric", HWOSVectorSimilarity.toStoreSimilarity(((VectorFieldMeta)field).getSimilarity()));
                builder.field("algorithm", "GRAPH");
            } else if (field instanceof TextFieldMeta) {
                TokenizeType tokenizeType = ((TextFieldMeta)field).getTokenizeType();
                if (tokenizeType == TokenizeType.NONE) {
                    builder.field("index", false);
                } else {
                    builder.field("index", true);
                    builder.field("analyzer", IKTokenizeType.from(((TextFieldMeta)field).getTokenizeType()));
                }
            }
            builder.endObject();
        }
    }

    @Override
    protected XContentBuilder createAddFieldsMapping(String collectionName, FieldMeta[] fields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject("properties");
        HWOS13Client.appendFieldMetas(builder, fields);
        builder.endObject().endObject();
        return builder;
    }

    @Override
    protected QueryBuilder createFilterQueryBuilder(CollectionMeta collection, Filter filter) {
        return (QueryBuilder)filter.accept((FilterVisitor)new HWOSFilterVisitor(collection));
    }

    @Override
    protected VectorFieldMeta buildVectorField(Map<String, Object> mapping, String field) {
        int dims = Integer.parseInt((String)mapping.get("dimension"));
        String similarity = (String)mapping.get("metric");
        VectorSimilarity vectorSimilarity = HWOSVectorSimilarity.fromStoreSimilarity(similarity);
        String dimType = (String)mapping.get("dim_type");
        DataType vectorType = HWOSDataType.to(dimType);
        return new VectorFieldMeta(field, vectorType, dims, vectorSimilarity);
    }

    @Override
    protected TextFieldMeta buildTextField(Map<String, Object> mapping, String field) {
        return FieldMeta.text((String)field, (TokenizeType)TokenizeType.NONE);
    }

    public Set<ServerFeatures> getFeatures() {
        String ikPluginName;
        HashSet<ServerFeatures> features = new HashSet<ServerFeatures>();
        if (this.validVersion()) {
            features.add(ServerFeatures.VECTOR_SEARCH);
        }
        if (this.containsPlugin(ikPluginName = "analysis-ik")) {
            features.add(ServerFeatures.KEYWORD_SEARCH);
        }
        return features;
    }

    protected boolean validVersion() {
        String version = this.getVersion();
        boolean valid = version.startsWith("7.10");
        if (!valid) {
            this.log.warn("invalidate CSS opensearch version:" + version + " , only support 1.3.6");
        }
        return valid;
    }

    @Override
    protected DataType getDataType(String dataType) {
        return HWOSDataType.to(dataType);
    }

    @Override
    protected boolean canBeClose() {
        return false;
    }
}

