/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.vdb.drivers.hw;

import java.io.IOException;
import java.util.HashMap;
import kd.ai.vdb.drivers.hw.HWOSVectorSimilarity;
import kd.ai.vdb.objects.VectorFieldMeta;
import kd.ai.vdb.objects.VectorSimilarity;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;

public class HWOSVectorQueryBuilder
extends AbstractQueryBuilder<HWOSVectorQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "vector";
    private final double[] findVector;
    private final VectorFieldMeta vectorField;
    private final int topK;

    public HWOSVectorQueryBuilder(VectorFieldMeta vectorField, double[] vectors, int topK) {
        this(vectorField, vectors, topK, -1.0f);
    }

    public HWOSVectorQueryBuilder(VectorFieldMeta vectorField, double[] vectors, int topK, float boost) {
        if (vectorField == null) {
            throw new IllegalArgumentException("vectorField must not be null");
        }
        if (vectors == null) {
            throw new IllegalArgumentException("vectors must not be null");
        }
        if (topK <= 0) {
            throw new IllegalArgumentException("topK must be greater than 0");
        }
        if (vectors.length != vectorField.getDims()) {
            throw new IllegalArgumentException("vectors length must be equal to vectorField dimension");
        }
        this.boost(boost);
        this.vectorField = vectorField;
        this.findVector = vectors;
        this.topK = topK;
    }

    public static Script buildScript(String destVectorFieldName, double[] destVector, VectorSimilarity similarity) {
        HashMap<String, double[]> params = new HashMap<String, double[]>();
        String func = HWOSVectorSimilarity.getFunction(similarity);
        params.put(NAME, destVector);
        StringBuilder scriptBuilder = new StringBuilder();
        if (similarity == VectorSimilarity.COSINE) {
            scriptBuilder.append("(").append(func).append("(params.vector,").append("doc['").append(destVectorFieldName).append("']) + 1.0) / 2");
        } else if (similarity == VectorSimilarity.L2) {
            scriptBuilder.append("1 / (1 + ").append(func).append("(params.vector, ").append("doc['").append(destVectorFieldName).append("']))");
        }
        return new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", scriptBuilder.toString(), params);
    }

    protected void doWriteTo(StreamOutput streamOutput) throws IOException {
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.vectorField.getName());
        builder.field(NAME, (Object)this.findVector);
        builder.field("topk", this.topK);
        builder.endObject();
        if (this.boost >= 0.0f) {
            this.printBoostAndQueryName(builder);
        }
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext queryShardContext) throws IOException {
        return null;
    }

    protected boolean doEquals(HWOSVectorQueryBuilder vectorQueryBuilder) {
        return false;
    }

    protected int doHashCode() {
        return 0;
    }

    public String fieldName() {
        return null;
    }

    public String getWriteableName() {
        return null;
    }
}

