/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.common;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaseDataCommon {
    private static final Log LOGGER = LogFactory.getLog(BaseDataCommon.class);
    public static final String ENTITY_BASE_DATA_VIEW = "bd_basedataview";
    public static final String ENTITY_BD_CTRL_STRATEGY = "bd_bddefctrlstrtgy";
    public static final String ENTITY_BD_STRATEGY_ENTITY = "bd_bdctrlstrtgy";
    public static final String ENTITY_BD_CTRL_FIELD_CON = "bd_ctrlstgyfieldcfg";
    public static final String ENTITY_BD_SOLIDIFY_MAS = "bd_rel_solidify_msg";
    public static final String FIELD_CREATE_ORG = "createorg";
    public static final String FIELD_ADMIN_ORG = "adminorg";
    public static final String FIELD_CTRL_STRATEGY = "ctrlstrategy";
    public static final String FIELD_USE_ORG = "useorg";
    public static final String FIELD_BIT_INDEX = "bitindex";
    public static final String FIELD_BIT_SRC_INDEX = "srcindex";
    public static final String FIELD_BIT_SOURCE = "sourcedata";
    public static final String FIELD_SRC_ORG = "srccreateorg";
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_MASTER_ID = "masterid";
    public static final String FIELD_IS_LEAF = "isleaf";
    public static final String FIELD_LONG_NUMBER = "longnumber";
    public static final String FIELD_FULL_NAME = "fullname";
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_ENABLE = "enable";
    public static final String FIELD_UPDATE_STATUS = "upgradestatus";
    public static final String FIELD_SYNC_DATA = "issyncdata";
    public static final String FIELD_SYNC_ALL_FIELD = "synallfield";
    public static final String FIELD_CHECK_STATUS = "checkstatus";
    public static final String SUFFIX_USE_RANGE = "_U";
    public static final String SUFFIX_USE_REG = "UseReg";
    public static final String SUFFIX_USE_EXC = "Exc";
    public static final String CTRL_STRATEGY_CU_ASSIGN = "1";
    public static final String CTRL_STRATEGY_CU_FREE_ASSIGN = "2";
    public static final String CTRL_STRATEGY_OU_ASSIGN = "3";
    public static final String CTRL_STRATEGY_OU_FREE_ASSIGN = "4";
    public static final String CTRL_STRATEGY_GLOBAL_SHARE = "5";
    public static final String CTRL_STRATEGY_CU_SHARE = "6";
    public static final String CTRL_STRATEGY_PRIVATE = "7";
    public static final String VER_DATE = "2021-11-18";
    public static final String VER_NUMBER = "6.0";
    public static final char SQL_PARAM_SEPARATOR = ',';
    public static final String SQL_PARAM_PLACEHOLDER = "?";
    public static final Integer BATCH_MAX = 1000;
    public static final String BIT_CACHE_UPDATE_LOCK_KEY = "bd_cache_update";
    public static final String BASE_DATA_USE_REL_TABLE_SUFFIX = "_bit";
    public static final String UPDATE_STATUS_UPDATE = "2";
    public static final String SUBMIT_WITH_NEW_DATA = "new_submit";
    public static final String IMPORT_TYPE_KEY = "importtype";
    public static final String IMPORT_DATA_PROP = "importprop";
    public static final String IMPORT_TYPE_NEW = "new";
    public static final String IMPORT_TYPE_OVERRIDE = "override";
    public static final String IMPORT_TYPE_OVERRIDE_NEW = "overridenew";
    public static final String CACHE_IS_COMMON_SEARCH = "bd_list_common_search";
    public static final String CACHE_COMMON_SEARCH_FILTER = "bd_list_common_search_filter";
    public static final String CACHE_USE_FILTER_DEFAULT = "bd_use_filter_default";
    public static final String CACHE_RM_DEFAULT_SUCCESS = "bd_rm_default_success";

    public static int getBatchMax() {
        String batchProp = System.getProperty("bd_ser_batch_max");
        if (StringUtils.isBlank((CharSequence)batchProp)) {
            return BATCH_MAX;
        }
        try {
            return Integer.parseInt(batchProp);
        }
        catch (NumberFormatException e) {
            LOGGER.info("ignore exception");
            return BATCH_MAX;
        }
    }

    public static String getBaseDataUnifiedLockKey(String entity) {
        return String.format("bd_%s_%s", entity, RequestContext.get().getAccountId());
    }

    public static String getOpName(String entity, String opKey) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return opKey;
        }
        try {
            Map operate = EntityMetadataCache.getDataEntityOperate((String)entity, (String)opKey);
            Object opName = operate.get(FIELD_NAME);
            if (!(opName instanceof Map)) {
                return opKey;
            }
            Map nameMap = (Map)opName;
            Object name = nameMap.get("zh_CN");
            return null == name ? opKey : name.toString();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return opKey;
        }
    }
}

