/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.bd.common.BaseDataCommon;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.pojo.SolidifyMessage;
import kd.bos.bd.service.AbstractBaseService;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.bd.utils.KryoSerializerUtils;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public abstract class AbstractBaseDataService
extends AbstractBaseService {
    private static final Log LOGGER = LogFactory.getLog(AbstractBaseDataService.class);
    private static final String FIELD_BASE_DATA_ID = "basedataid";
    private static final String PLUGIN = "plugin";
    static final String FILED_PARENT_ID = "parent.id";
    static final String FILED_ORG_ENABLE = "org.enable";
    static final String FILED_VIEW_ID = "view.id";
    static final String FILED_ORG_ID = "org.id";
    protected String entity;
    protected String masterIdPropName;
    protected String masterIdFieldName;
    protected String numberField = "number";

    protected void init(String entity) {
        this.entity = entity;
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        this.masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        if (StringUtils.isNotBlank((CharSequence)entity) && AbstractBaseDataService.isOtherMasterIdType(entity)) {
            this.numberField = "masterid.number";
        }
    }

    void setEntity(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        if (StringUtils.isBlank((CharSequence)this.entity) || !this.entity.equals(entity)) {
            this.init(entity);
        }
    }

    static boolean isOtherMasterIdType(String entity) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return false;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            return 2 == basedataEntityType.getMasteridType();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBaseDataBitIndexAndSourceId(DynamicObject[] objs, String entityId) {
        String lockKey = this.getGenIndexLockKey(entityId);
        DLock lock = DLock.create((String)lockKey);
        lock.lock();
        try {
            boolean bitIndexHasChange = false;
            int bitIndex = this.getMaxBitIndex(entityId, objs.length);
            for (DynamicObject obj : objs) {
                this.newModelPropValidate(obj, "sourcedata");
                Object sourceId = obj.get("sourcedata");
                if (null == sourceId || (Long)sourceId == 0L) {
                    obj.set("sourcedata", obj.getPkValue());
                }
                this.newModelPropValidate(obj, "bitindex");
                if (0 != obj.getInt("bitindex")) continue;
                this.newModelPropValidate(obj, "srcindex");
                obj.set("bitindex", (Object)(++bitIndex));
                obj.set("srcindex", (Object)bitIndex);
                bitIndexHasChange = true;
            }
            if (bitIndexHasChange) {
                this.updateBaseDataBitIndexCache(entityId, String.valueOf(bitIndex));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void newModelPropValidate(DynamicObject obj, String prop) {
        boolean existProp;
        try {
            IDataEntityProperty property;
            IDataEntityType dt = obj.getDataEntityType();
            existProp = null == dt ? false : null != (property = (IDataEntityProperty)dt.getProperties().get((Object)prop));
        }
        catch (Exception e) {
            LOGGER.error(prop + "\u5c5e\u6027\u4e0d\u5b58\u5728.", (Throwable)e);
            existProp = false;
        }
        if (!existProp) {
            LOGGER.error(prop + "\u5c5e\u6027\u4e0d\u5b58\u5728.");
            throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u6a21\u578b\u5b57\u6bb5\u7f3a\u5931\uff0c\u4e0d\u652f\u6301\u65b0\u6a21\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractBaseDataService_4", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    Map<Long, List<Long>> getDirectSubUnCuOrgMapping(Long orgViewId, Collection<Long> parentOrgIds) {
        return this.getDirectSubOrgMapping(orgViewId, parentOrgIds, Boolean.FALSE);
    }

    List<Long> getDirectSubCuOrgList(Long orgViewId, Long parentOrgId) {
        Map<Long, List<Long>> listMap = this.getDirectSubOrgMapping(orgViewId, Collections.singletonList(parentOrgId), Boolean.TRUE);
        List<Long> orgList = listMap.get(parentOrgId);
        if (null == orgList) {
            return new ArrayList<Long>(0);
        }
        return orgList;
    }

    public Map<Long, List<Long>> getDirectSubCuOrgMapping(Long orgViewId, Collection<Long> parentOrgIds) {
        return this.getDirectSubOrgMapping(orgViewId, parentOrgIds, Boolean.TRUE);
    }

    protected Map<Long, List<Long>> getAllSubCuOrgMapping(Long viewId, List<Long> parentOrgId) {
        Map subordinateOrgMap = OrgUnitServiceHelper.getAllSubordinateOrgMap((long)viewId, parentOrgId, (boolean)true);
        ArrayList orgIds = new ArrayList(10);
        subordinateOrgMap.values().forEach(orgIds::addAll);
        ORM orm = ORM.create();
        ArrayList<Long> unCuSubOrgIds = new ArrayList<Long>(10);
        QFilter[] filters = new QFilter[]{new QFilter(FILED_VIEW_ID, "=", (Object)viewId), new QFilter(FILED_ORG_ID, "in", orgIds), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE)};
        try (DataSet ds = orm.queryDataSet(AbstractBaseDataService.class.getName(), "bos_org_structure", FILED_ORG_ID, filters);){
            for (Row row : ds) {
                if (row.getLong(FILED_ORG_ID) == null) continue;
                unCuSubOrgIds.add(row.getLong(FILED_ORG_ID));
            }
        }
        for (List value : subordinateOrgMap.values()) {
            value.removeAll(unCuSubOrgIds);
        }
        return subordinateOrgMap;
    }

    Map<Integer, Long> getBaseDataBitIndex2IdMap(Collection<Long> baseDataIds, String entity) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", baseDataIds)};
        return this.getBaseDataBitIndex2IdMap(filters, entity);
    }

    Map<Integer, Long> getBaseDataBitIndex2IdMap(QFilter[] filters, String entity) {
        if (null == filters) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"id, bitindex", (QFilter[])filters);
        HashMap<Integer, Long> indexMap = new HashMap<Integer, Long>(query.size());
        for (DynamicObject dynamicObject : query) {
            indexMap.put(dynamicObject.getInt("bitindex"), dynamicObject.getLong("id"));
        }
        return indexMap;
    }

    public Map<Long, Integer> getBaseDataId2BitIndexMap(Collection<Long> baseDataIds, String entity) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", baseDataIds)};
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"id, bitindex", (QFilter[])filters);
        HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>(query.size());
        for (DynamicObject dynamicObject : query) {
            indexMap.put(dynamicObject.getLong("id"), dynamicObject.getInt("bitindex"));
        }
        return indexMap;
    }

    protected void saveOrUpdateRelBit(Map<Long, List<Integer>> rel, String entityId) throws Exception {
        HashMap<Long, BaseDataUseRelBit> newBitRelMap = new HashMap<Long, BaseDataUseRelBit>(rel.size());
        for (Map.Entry<Long, List<Integer>> entry : rel.entrySet()) {
            Long orgId = entry.getKey();
            BaseDataUseRelBit bitRel = new BaseDataUseRelBit();
            bitRel.setOrgId(orgId);
            RoaringBitmap bit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr((Collection<Integer>)entry.getValue()));
            bit.runOptimize();
            bitRel.setBit(bit);
            newBitRelMap.put(orgId, bitRel);
        }
        Map dataUseRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(rel.keySet(), (String)entityId);
        ArrayList<BaseDataUseRelBit> needUpdateList = new ArrayList<BaseDataUseRelBit>(10);
        for (Map.Entry entry : dataUseRelBitMap.entrySet()) {
            BaseDataUseRelBit remove = (BaseDataUseRelBit)newBitRelMap.remove(entry.getKey());
            if (null == remove) continue;
            BaseDataUseRelBit value = (BaseDataUseRelBit)entry.getValue();
            value.getBit().or(remove.getBit());
            needUpdateList.add(value);
        }
        BaseDataUseRelUpdateEngine.update(needUpdateList, (String)entityId);
        BaseDataUseRelUpdateEngine.insert(newBitRelMap.values(), (String)entityId);
    }

    void handleAssignTypeBaseData(Map<Long, List<Integer>> rel, Map<Long, List<Integer>> assignTypeBdMap, Long viewId) {
        if (CollectionUtils.isEmpty(assignTypeBdMap)) {
            return;
        }
        Map<Long, List<Long>> unCuOrgMapping = this.getDirectSubUnCuOrgMapping(viewId, assignTypeBdMap.keySet());
        for (Map.Entry<Long, List<Long>> entry : unCuOrgMapping.entrySet()) {
            List<Long> childOrgIds = entry.getValue();
            if (CollectionUtils.isEmpty(childOrgIds)) continue;
            List<Integer> indexArr = assignTypeBdMap.get(entry.getKey());
            childOrgIds.forEach(orgId -> rel.computeIfAbsent((Long)orgId, k -> new ArrayList(indexArr.size())).addAll(indexArr));
        }
    }

    protected void handleShareTypeBaseData(Map<Long, List<Integer>> rel, Map<Long, List<Integer>> shareTypeBdMap, Long viewId) {
        if (CollectionUtils.isEmpty(shareTypeBdMap)) {
            return;
        }
        for (Map.Entry<Long, List<Integer>> entry : shareTypeBdMap.entrySet()) {
            Long currOrgId = entry.getKey();
            Set<Long> allChildOrgIds = this.getAllCuSubordinateOrgIds(viewId, currOrgId);
            if (CollectionUtils.isEmpty(allChildOrgIds)) continue;
            List<Integer> indexArr = entry.getValue();
            allChildOrgIds.forEach(orgId -> rel.computeIfAbsent((Long)orgId, k -> new ArrayList(indexArr.size())).addAll(indexArr));
        }
    }

    private Map<Long, List<Long>> getDirectSubOrgMapping(Long orgViewId, Collection<Long> parentOrgIds, Boolean isCtrlUnit) {
        ORM orm = ORM.create();
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(parentOrgIds.size());
        QFilter[] filters = new QFilter[]{new QFilter(FILED_VIEW_ID, "=", (Object)orgViewId), new QFilter(FILED_PARENT_ID, "in", parentOrgIds), new QFilter(FILED_ORG_ENABLE, "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)isCtrlUnit), new QFilter("isfreeze", "=", (Object)Boolean.FALSE)};
        try (DataSet ds = orm.queryDataSet(AbstractBaseDataService.class.getName(), "bos_org_structure", "org.id,parent.id", filters);){
            for (Row row : ds) {
                Long childOrgId = row.getLong(FILED_ORG_ID);
                if (null == childOrgId) continue;
                Long parentId = row.getLong(FILED_PARENT_ID);
                result.computeIfAbsent(parentId, k -> new ArrayList(10)).add(childOrgId);
            }
        }
        return result;
    }

    Map<Long, Set<Long>> selectCustomDataFromDb(String entity, Collection<Long> dataIds) {
        HashMap<Long, Set<Long>> personalDataMap = new HashMap<Long, Set<Long>>(16);
        DynamicObjectCollection collection = this.selectCustomDataCollection(entity, dataIds, "createorg, sourcedata");
        for (DynamicObject baseData : collection) {
            Long creator = baseData.getLong("createorg");
            Long source = baseData.getLong("sourcedata");
            personalDataMap.computeIfAbsent(creator, k -> new HashSet(16)).add(source);
        }
        return personalDataMap;
    }

    public Set<Long> selectCustomDataIds(String entity, Collection<Long> dataIds) {
        DynamicObjectCollection collection = this.selectCustomDataCollection(entity, dataIds, "sourcedata");
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> customDataIds = new HashSet<Long>(collection.size());
        collection.forEach(data -> customDataIds.add(data.getLong("sourcedata")));
        return customDataIds;
    }

    public Map<Long, Set<Long>> selectCustomDataMap(String entity, Collection<Long> dataIds) {
        DynamicObjectCollection collection = this.selectCustomDataCollection(entity, dataIds, "id, createorg");
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> customData2OrgMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject baseData : collection) {
            Long dataId = baseData.getLong("id");
            Long orgId = baseData.getLong("createorg");
            customData2OrgMap.computeIfAbsent(dataId, k -> new HashSet(1)).add(orgId);
        }
        return customData2OrgMap;
    }

    DynamicObjectCollection selectCustomDataCollection(String entity, Collection<Long> dataIds, String selectFields) {
        QFilter[] filters = new QFilter[]{new QFilter("sourcedata", "in", dataIds), QFilter.sqlExpress((String)"id", (String)"!=", (String)this.getMasterIdFieldName(entity))};
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters);
    }

    private String getMasterIdFieldName(String entity) {
        if (null == this.masterIdFieldName) {
            this.init(entity);
        }
        return this.masterIdFieldName;
    }

    int[] covertIntegerList2IntArr(Collection<Integer> intPackList) {
        if (CollectionUtils.isEmpty(intPackList)) {
            return new int[0];
        }
        int[] result = new int[intPackList.size()];
        int i = 0;
        for (Integer integer : intPackList) {
            result[i] = integer;
            ++i;
        }
        return result;
    }

    Set<Integer> coverIntArr2Collection(int[] array) {
        if (null == array || array.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>(array.length);
        for (int value : array) {
            result.add(value);
        }
        return result;
    }

    public static Long getLongPropertyFromDynamicObject(DynamicObject dynamicObject, String property) {
        Object value = dynamicObject.get(property);
        if (value instanceof DynamicObject) {
            DynamicObject dyn = (DynamicObject)value;
            return null == dyn.getPkValue() ? dyn.getLong("id") : ((Long)dyn.getPkValue()).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    Long getLongDataFromDynamicObject(Object data) {
        if (null == data) {
            return 0L;
        }
        if (data instanceof DynamicObject) {
            return null == ((DynamicObject)data).getPkValue() ? ((DynamicObject)data).getLong("id") : ((Long)((DynamicObject)data).getPkValue()).longValue();
        }
        if (data instanceof Long) {
            return (Long)data;
        }
        return Long.valueOf(data.toString());
    }

    void addNewBitToOrgUseRel(String entity, int[] indexArr, List<BaseDataUseRelBit> updates, List<BaseDataUseRelBit> inserts, Collection<Long> orgIds) throws Exception {
        Map useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, (String)entity);
        RoaringBitmap newBit = RoaringBitmap.bitmapOf((int[])indexArr);
        newBit.runOptimize();
        for (Long orgId : orgIds) {
            BaseDataUseRelBit relBit = (BaseDataUseRelBit)useRelBitMap.remove(orgId);
            if (null == relBit) {
                relBit = new BaseDataUseRelBit();
                relBit.setOrgId(orgId);
                relBit.setBit(newBit);
                inserts.add(relBit);
                continue;
            }
            RoaringBitmap bit = relBit.getBit();
            bit.add(indexArr);
            bit.runOptimize();
            updates.add(relBit);
        }
    }

    void deleteBitFromOrgUseRel(String entity, int[] indexArr, List<Long> orgIds, List<BaseDataUseRelBit> updates) throws Exception {
        Map deleteBitRelMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, (String)entity);
        RoaringBitmap newBit = RoaringBitmap.bitmapOf((int[])indexArr);
        newBit.runOptimize();
        for (Long orgId : orgIds) {
            BaseDataUseRelBit relBit = (BaseDataUseRelBit)deleteBitRelMap.remove(orgId);
            if (null == relBit) continue;
            RoaringBitmap bit = relBit.getBit();
            bit.andNot(newBit);
            bit.runOptimize();
            updates.add(relBit);
        }
    }

    Set<Long> getAllCuSubordinateOrgIds(Long viewId, Long excludeOrdId) {
        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, Collections.singletonList(excludeOrdId), (boolean)false, (boolean)true);
        QFilter[] filters = new QFilter[]{new QFilter(FILED_VIEW_ID, "=", (Object)viewId), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE)};
        HashSet<Long> unCuOrgIds = new HashSet<Long>(16);
        try (DataSet ds = ORM.create().queryDataSet(AbstractBaseDataService.class.getName(), "bos_org_structure", FILED_ORG_ID, filters);){
            for (Row row : ds) {
                Long orgId = row.getLong(FILED_ORG_ID);
                if (orgId == null) continue;
                unCuOrgIds.add(orgId);
            }
        }
        HashSet<Long> result = new HashSet<Long>(orgIds);
        result.removeAll(unCuOrgIds);
        return result;
    }

    Set<Long> getAllCuOrgByViewId(Long viewId, Long excludeOrdId) {
        QFilter[] filters = new QFilter[]{new QFilter(FILED_VIEW_ID, "=", (Object)viewId), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE)};
        HashSet<Long> orgIds = new HashSet<Long>(16);
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(AbstractBaseDataService.class.getName(), "bos_org_structure", FILED_ORG_ID, filters);){
            for (Row row : ds) {
                Long orgId = row.getLong(FILED_ORG_ID);
                if (orgId == null || orgId.equals(excludeOrdId)) continue;
                orgIds.add(orgId);
            }
        }
        return orgIds;
    }

    IBaseDataCtrlPlugin getBaseDataCtrlPlugin(String entityType) {
        String baseDataCtrlPluginStr = BaseDataCtrlCache.getBaseDataCtrlPlugin((String)entityType);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)baseDataCtrlPluginStr)) {
            if ("DATA_LOADED".equals(baseDataCtrlPluginStr)) {
                return null;
            }
            try {
                return (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_BASE_DATA_ID, "=", (Object)entityType)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)PLUGIN, (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Collection)collection) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((DynamicObject)collection.get(0)).getString(PLUGIN))) {
            baseDataCtrlPluginStr = ((DynamicObject)collection.get(0)).getString(PLUGIN);
            BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
            try {
                return (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)"DATA_LOADED");
        return null;
    }

    protected static String getBaseDataUnifiedLockKey(String entity) {
        return BaseDataCommon.getBaseDataUnifiedLockKey(entity);
    }

    boolean needWriteBitRel(String ctrlStrategy) {
        if (AbstractBaseDataService.isTreeTypeBaseData(this.entity)) {
            return true;
        }
        return !"6".equalsIgnoreCase(ctrlStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isTreeTypeBaseData(String entity) {
        String accountId = RequestContext.get().getAccountId();
        LocalMemoryCache localCache = AbstractBaseDataService.getLocalCache();
        String key = String.format("bd_type_%s_%s", accountId, entity);
        Object value = localCache.get(key);
        if (!Objects.isNull(value)) {
            return Boolean.parseBoolean(value.toString());
        }
        String type = String.format("bd_type_%s", accountId);
        String cacheValue = (String)BD_COMMON_CACHE.get(type, entity);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            localCache.put(key, (Object)cacheValue);
            return Boolean.parseBoolean(cacheValue);
        }
        DLock lock = DLock.create((String)String.format("bd_type_judge_%s", entity));
        lock.lock();
        try {
            cacheValue = (String)BD_COMMON_CACHE.get(type, entity);
            if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
                localCache.put(key, (Object)cacheValue);
                boolean bl = Boolean.parseBoolean(cacheValue);
                return bl;
            }
            String selectSql = "select a.fnumber from t_meta_entitydesign a left join t_meta_bizapp  app on a.Fbizappid = app.fid where a.fnumber = ? and a.fistemplate = '0' and app.FDEPLOYSTATUS ='2' and a.FINHERITPATH like '%b0d31cea000006ac%';";
            boolean isTreeType = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])new Object[]{entity}, ResultSet::next);
            BD_COMMON_CACHE.put(type, entity, (Object)Boolean.toString(isTreeType));
            localCache.put(key, (Object)Boolean.toString(isTreeType));
            boolean bl = isTreeType;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean asyncRecord() {
        DynamicObject config = AbstractBaseDataService.getCtrlStrategyConfig(this.entity);
        boolean isNewModel = "2".equals(config.getString("upgradestatus"));
        boolean enableSolidify = config.getBoolean("enablesolidify") && null != config.get("solidifyobj");
        return isNewModel && enableSolidify;
    }

    static DynamicObject getCtrlStrategyConfig(String entity) {
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_BASE_DATA_ID, "=", (Object)entity)};
        String selectFields = "upgradestatus, checkstatus, solidifyobj, enablesolidify, solidifystatus, assignundetail";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
    }

    protected void publish(BaseDataSolidifyMessageDTO messageDto) {
        IDataEntityType dt = ORM.create().newDynamicObject(this.entity).getDataEntityType();
        String routeKey = dt.getDBRouteKey();
        this.publish(messageDto, routeKey);
    }

    void publish(BaseDataSolidifyMessageDTO messageDto, String routeKey) {
        List messages = messageDto.getSolidifyMessages();
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return;
        }
        if (DBRoute.basedata.getRouteKey().equals(routeKey)) {
            List<Long> msgIds = this.saveSolidifyMassage(messageDto, messages);
            this.publish(routeKey, msgIds);
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"save_solidify_msg_tx");){
            try {
                List<Long> msgIds = this.saveSolidifyMassage(messageDto, messages);
                this.publish(routeKey, msgIds);
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("\u4fdd\u5b58\u4f4d\u56fe\u56fa\u5316\u6d88\u606f\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u4f4d\u56fe\u56fa\u5316\u6d88\u606f\u5931\u8d25\u3002", (String)"AbstractBaseDataService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
            }
        }
    }

    private void publish(String routeKey, List<Long> msgIds) {
        if (msgIds.isEmpty()) {
            return;
        }
        String appId = AbstractBaseDataService.getAppId();
        MessagePublisher publisher = null;
        try {
            publisher = MQFactory.get().createPartitionPublisher("base", "kd.base.bd.ctrl.solidify_queue", PartitionStrategy.APP_ID);
            publisher.publishInDbTranscation(routeKey, msgIds, appId);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            if (null != publisher) {
                publisher.close();
            }
        }
    }

    private List<Long> saveSolidifyMassage(BaseDataSolidifyMessageDTO messageDto, List<BaseDataSolidifyMessage> messages) {
        String insert = "insert into t_bd_solidify_msg (fid, fbitdata, fentity, fuseorgid, foptime, fstatus, foptype, fopuserid) values (?, ?, ?, ?, ?, ?, ?, ?);";
        ArrayList<Long> msgIds = new ArrayList<Long>(messages.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>(10000);
        for (BaseDataSolidifyMessage message : messages) {
            List solidifyMessagesList = message.getMessages();
            if (solidifyMessagesList.isEmpty()) continue;
            String entity = message.getEntity();
            Long useOrgId = message.getUseOrgId();
            for (SolidifyMessage msg : solidifyMessagesList) {
                Long id = msg.getId();
                msgIds.add(id);
                byte[] bytes = KryoSerializerUtils.serRoaringBitmap((RoaringBitmap)msg.getBit());
                params.add(new Object[]{id, bytes, entity, useOrgId, messageDto.getUnifyOpTime(), msg.getStatus(), msg.getOpType(), messageDto.getUnifyOpUerId()});
                if (10000 != params.size()) continue;
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insert, params);
                params.clear();
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insert, params);
        }
        return msgIds;
    }

    static String getAppId() {
        String defaultAppId = "bos";
        String[] appIds = Instance.getAppIds();
        if (null == appIds || appIds.length == 0) {
            appIds = Instance.getInnerAppIds();
        }
        if (null == appIds || appIds.length == 0) {
            return defaultAppId;
        }
        Set collect = Arrays.stream(appIds).collect(Collectors.toSet());
        collect.removeIf(StringUtils::isBlank);
        if (collect.isEmpty()) {
            return defaultAppId;
        }
        return (String)collect.iterator().next();
    }

    protected SolidifyMessage createAddSolidifyMessage(RoaringBitmap bit) {
        SolidifyMessage message = new SolidifyMessage(Long.valueOf(DB.genGlobalLongId()), "1");
        message.setBit(bit);
        return message;
    }

    protected SolidifyMessage createDelSolidifyMessage(RoaringBitmap bit) {
        SolidifyMessage message = new SolidifyMessage(Long.valueOf(DB.genGlobalLongId()), "0");
        message.setBit(bit);
        return message;
    }

    protected BaseDataSolidifyMessageDTO createAddMessageDto(OpDataContext context, boolean asyncRecord, Long viewId) {
        BaseDataSolidifyMessageDTO dto = new BaseDataSolidifyMessageDTO(10);
        if (!asyncRecord) {
            return dto;
        }
        Map<Long, RoaringBitmap> useRelBit = context.buildUseOrgBitmap(viewId, false);
        for (Map.Entry<Long, RoaringBitmap> entry : useRelBit.entrySet()) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, entry.getKey());
            message.add(this.createAddSolidifyMessage(entry.getValue()));
            dto.add(message);
        }
        return dto;
    }

    BaseDataSolidifyMessageDTO createDelMessageDto(OpDataContext context, Long viewId) {
        BaseDataSolidifyMessageDTO dto = new BaseDataSolidifyMessageDTO(10);
        Map<Long, RoaringBitmap> useRelBit = context.buildUseOrgBitmap(viewId, true);
        for (Map.Entry<Long, RoaringBitmap> entry : useRelBit.entrySet()) {
            BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, entry.getKey());
            message.add(this.createDelSolidifyMessage(entry.getValue()));
            dto.add(message);
        }
        return dto;
    }

    public void writOpLog(Map<Long, List<Integer>> rel, String entity, String opName, Long opOrg) {
        ArrayList<OpLogAppInfo> logInfos = new ArrayList<OpLogAppInfo>(10);
        Date opTime = new Date();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)entity);
        for (Map.Entry<Long, List<Integer>> entry : rel.entrySet()) {
            Long orgId = entry.getKey();
            OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, opOrg, opName, entity, appId);
            String bitString = JSON.toJSONString(entry.getValue());
            bitString = 150 > bitString.length() ? bitString : bitString.substring(0, 150) + "...";
            appLogInfo.setOpDescription(String.format("%s [Org:%s, Bit:%s, Entity:%s]", opName, orgId, bitString, entity));
            logInfos.add(appLogInfo);
        }
        LogServiceHelper.addBatchLog(logInfos);
    }

    void writUnAssignOpLogWithDataNumber(String entity, Long opOrg, String appId) {
        BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
            Date opTime = new Date();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d", "AbstractBaseDataService_2", "bos-bd-business");
            OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, opOrg, "Cancel Assign", opName, entity, appId);
            appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5b8c\u6210\uff0c\u8be6\u60c5\u53ef\u89c1\u7ba1\u63a7\u65e5\u5fd7\uff0c\u5177\u4f53\u8def\u5f84\uff1a\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011-\u3010\u4f01\u4e1a\u5efa\u6a21\u3011-\u3010\u7ba1\u63a7\u7b56\u7565\u3011-\u3010\u7ba1\u63a7\u65e5\u5fd7\u3011\u3002", "AbstractBaseDataService_3", "bos-bd-business"), new String[0]);
            ArrayList<OpLogAppInfo> logs = new ArrayList<OpLogAppInfo>(1);
            logs.add(appLogInfo);
            LogServiceHelper.addBatchLog(logs);
            return Boolean.TRUE;
        }, RequestContext.get());
    }

    OpLogAppInfo buildAppLogInfo(Date opTime, Long opOrg, String opKey, String entity, String appId) {
        OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, opOrg, entity, appId);
        appLogInfo.setOpName(opKey, BaseDataCommon.getOpName(entity, opKey));
        return appLogInfo;
    }

    OpLogAppInfo buildAppLogInfo(Date opTime, Long opOrg, String opKey, MultiLangEnumBridge opNameBridge, String entity, String appId) {
        OpLogAppInfo appLogInfo = this.buildAppLogInfo(opTime, opOrg, entity, appId);
        appLogInfo.setOpName(opKey, opNameBridge);
        return appLogInfo;
    }

    OpLogAppInfo buildAppLogInfo(Date opTime, Long opOrg, String entity, String appId) {
        RequestContext context = RequestContext.get();
        Long userId = context.getCurrUserId();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(userId);
        if (opOrg == null) {
            appLogInfo.setOrgID(Long.valueOf(context.getOrgId()));
        } else {
            appLogInfo.setOrgID(opOrg);
        }
        appLogInfo.setClientIP(context.getLoginIP());
        appLogInfo.setClientType(context.getClient());
        appLogInfo.setClientName(context.getClient());
        appLogInfo.setAccountId(context.getAccountId());
        appLogInfo.setTenantId(context.getTenantId());
        appLogInfo.setLanguage(context.getLang().name());
        appLogInfo.setOpTime(opTime);
        appLogInfo.setBizObjID(entity);
        appLogInfo.setBizAppID(appId);
        return appLogInfo;
    }

    protected class OpDataContext {
        Map<Long, List<Integer>> currentOrgIndexes = new HashMap<Long, List<Integer>>(0);
        Map<Long, List<Integer>> shareTypeMap = new HashMap<Long, List<Integer>>(0);
        Map<Long, List<Integer>> cuShareTypeMap = new HashMap<Long, List<Integer>>(0);

        boolean isEnableVersion() {
            return false;
        }

        public Map<Long, List<Integer>> getCurrentOrgIndexes() {
            return this.currentOrgIndexes;
        }

        public Map<Long, List<Integer>> getShareTypeMap() {
            return this.shareTypeMap;
        }

        public Map<Long, List<Integer>> getCuShareTypeMap() {
            return this.cuShareTypeMap;
        }

        private void clear() {
            this.currentOrgIndexes.clear();
            this.shareTypeMap.clear();
            this.cuShareTypeMap.clear();
        }

        public Map<Long, RoaringBitmap> buildUseOrgBitmap(Long viewId, boolean excludeCurrOrg) {
            HashMap<Long, RoaringBitmap> useRelBit = new HashMap<Long, RoaringBitmap>(16);
            if (!this.shareTypeMap.isEmpty()) {
                Set<Long> allCuOrgIds = AbstractBaseDataService.this.getAllCuOrgByViewId(viewId, null);
                if (excludeCurrOrg) {
                    allCuOrgIds.removeAll(this.shareTypeMap.keySet());
                }
                this.shareTypeMap.values().forEach(indexes -> allCuOrgIds.forEach(e -> useRelBit.put((Long)e, RoaringBitmap.bitmapOf((int[])AbstractBaseDataService.this.covertIntegerList2IntArr((Collection<Integer>)indexes)))));
            }
            this.addCuShareBit(viewId, excludeCurrOrg, useRelBit);
            if (!excludeCurrOrg) {
                for (Map.Entry<Long, List<Integer>> entry : this.currentOrgIndexes.entrySet()) {
                    Long orgId = entry.getKey();
                    List<Integer> value = entry.getValue();
                    useRelBit.computeIfAbsent(orgId, k -> new RoaringBitmap()).add(AbstractBaseDataService.this.covertIntegerList2IntArr(value));
                }
            }
            this.clear();
            return useRelBit;
        }

        private void addCuShareBit(Long viewId, boolean excludeCurrOrg, Map<Long, RoaringBitmap> useRelBit) {
            if (this.cuShareTypeMap.isEmpty()) {
                return;
            }
            Map<Long, List<Long>> subCuOrgMapping = AbstractBaseDataService.this.getAllSubCuOrgMapping(viewId, new ArrayList<Long>(this.cuShareTypeMap.keySet()));
            for (Map.Entry<Long, List<Integer>> entry : this.cuShareTypeMap.entrySet()) {
                List<Long> subOrgIds;
                int[] indexArr = AbstractBaseDataService.this.covertIntegerList2IntArr((Collection<Integer>)entry.getValue());
                Long orgId = entry.getKey();
                if (!excludeCurrOrg) {
                    useRelBit.computeIfAbsent(orgId, k -> new RoaringBitmap()).add(indexArr);
                }
                if (CollectionUtils.isEmpty(subOrgIds = subCuOrgMapping.get(orgId))) continue;
                for (Long id : subOrgIds) {
                    if (excludeCurrOrg && orgId.equals(id)) continue;
                    useRelBit.computeIfAbsent(id, k -> new RoaringBitmap()).add(indexArr);
                }
            }
        }
    }
}

