/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.pojo.BaseDataSolidifyMessage;
import kd.bos.bd.pojo.BaseDataSolidifyMessageDTO;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.service.internal.BaseDataSupplementService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.BaseDataMutexUtils;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.StringUtils;
import org.roaringbitmap.RoaringBitmap;

@SdkInternal
public class BaseDataCustomService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataCustomService.class);

    @Deprecated
    public BaseDataCustomService() {
    }

    public BaseDataCustomService(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        super.init(entity);
    }

    public void handleCustomBaseData(String entity, Long customOrgId, DynamicObject customData) throws Exception {
        this.setEntity(entity);
        int bitIndex = customData.getInt("bitindex");
        int srcBitIndex = customData.getInt("srcindex");
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = (Long)ctrlView.getPkValue();
        String ctrlStrategy = customData.getString("ctrlstrategy");
        if (!this.needWriteBitRel(ctrlStrategy)) {
            return;
        }
        if ("2".equals(ctrlStrategy)) {
            this.updateUseRelBit(entity, bitIndex, srcBitIndex, Collections.singletonList(customOrgId));
            return;
        }
        if ("1".equals(ctrlStrategy) || "6".equals(ctrlStrategy)) {
            Long customDataId = customData.getLong("id");
            Long srcDataId = customData.getLong("sourcedata");
            Set<Long> customChildOrgIds = this.selectCustomDataFromDb(entity, Collections.singleton(srcDataId)).keySet();
            customChildOrgIds.remove(customOrgId);
            Set<Long> allOrgIds = this.getAllCuSubordinateOrgIds(viewId, customOrgId);
            allOrgIds.add(customOrgId);
            if (!CollectionUtils.isEmpty(customChildOrgIds)) {
                customChildOrgIds.retainAll(allOrgIds);
                List childList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, new ArrayList<Long>(customChildOrgIds), (boolean)true);
                childList.retainAll(allOrgIds);
                HashSet<Long> excludeOrgSet = new HashSet<Long>(customChildOrgIds);
                excludeOrgSet.addAll(childList);
                allOrgIds.removeIf(excludeOrgSet::contains);
            }
            try (TXHandle tx = TX.required((String)"custom_base_data");){
                try {
                    this.updateCustomDataSourceInfo(entity, bitIndex, srcBitIndex, customDataId, srcDataId, customChildOrgIds);
                    this.updateUseRelBit(entity, bitIndex, srcBitIndex, new ArrayList<Long>(allOrgIds), customOrgId, ctrlStrategy);
                }
                catch (Exception e) {
                    tx.markRollback();
                    LOGGER.error("\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
                    String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38\u3002", (String)"BaseDataCustomService_0", (String)"bos-bd-business", (Object[])new Object[0]);
                    throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
                }
            }
        }
    }

    public void saveHistoryInfo(Long customOrgId, DynamicObject customData) {
        boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)this.entity);
        if (!enableVersion) {
            return;
        }
        boolean asyncRecord = this.asyncRecord();
        String ctrlStrategy = customData.getString("ctrlstrategy");
        boolean needWriteBitRel = this.needWriteBitRel(ctrlStrategy);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        HashSet<Long> orgIds = new HashSet<Long>(Collections.singletonList(customOrgId));
        if ("6".equals(ctrlStrategy)) {
            orgIds.addAll(this.getAllCuSubordinateOrgIds((Long)ctrlView.getPkValue(), customOrgId));
        }
        ArrayList<Long> allOrgIds = new ArrayList<Long>(0);
        if (asyncRecord && "5".equals(ctrlStrategy)) {
            allOrgIds.addAll(this.getAllCuOrgByViewId((Long)ctrlView.getPkValue(), 0L));
        }
        int bitIndex = customData.getInt("bitindex");
        String lockKey = BaseDataCustomService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.required((String)"custom_base_data");
        try {
            if (needWriteBitRel && !"5".equals(ctrlStrategy)) {
                Map useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, (String)this.entity);
                for (Long orgId : orgIds) {
                    BaseDataUseRelBit useRelBit = (BaseDataUseRelBit)useRelBitMap.get(orgId);
                    if (null == useRelBit) continue;
                    RoaringBitmap bit = useRelBit.getBit();
                    bit.add(bitIndex);
                    bit.runOptimize();
                }
                BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), (String)this.entity);
            }
            if (asyncRecord) {
                AbstractCollection solidifyOrgIds = "5".equals(ctrlStrategy) ? allOrgIds : orgIds;
                BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(1);
                for (Long orgId : solidifyOrgIds) {
                    BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                    message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])new int[]{bitIndex})));
                    messageDto.add(message);
                }
                this.publish(messageDto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38\u3002", (String)"BaseDataCustomService_0", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    private void updateUseRelBit(String entity, int bitIndex, int srcBitIndex, List<Long> orgIds) {
        if (orgIds.isEmpty()) {
            return;
        }
        String lockKey = BaseDataCustomService.getBaseDataUnifiedLockKey(entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.required((String)"custom_base_data");
        try {
            boolean asyncRecord = this.asyncRecord();
            BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(1);
            Map useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, (String)entity);
            for (Long orgId : orgIds) {
                BaseDataUseRelBit useRelBit;
                if (asyncRecord) {
                    BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(entity, orgId);
                    message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])new int[]{bitIndex})));
                    message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])new int[]{srcBitIndex})));
                    messageDto.add(message);
                }
                if (null == (useRelBit = (BaseDataUseRelBit)useRelBitMap.get(orgId))) continue;
                RoaringBitmap bit = useRelBit.getBit();
                bit.add(bitIndex);
                bit.remove(srcBitIndex);
                bit.runOptimize();
            }
            BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), (String)entity);
            if (asyncRecord) {
                this.publish(messageDto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38\u3002", (String)"BaseDataCustomService_0", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUseRelBit(String entity, int bitIndex, int srcBitIndex, List<Long> orgIds, Long currentOrgId, String ctrlStrategy) throws Exception {
        if (orgIds.isEmpty()) {
            return;
        }
        boolean asyncRecord = this.asyncRecord();
        BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(1);
        String lockKey = BaseDataCustomService.getBaseDataUnifiedLockKey(entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        try {
            boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)entity);
            Map useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(orgIds, (String)entity);
            for (Long orgId : orgIds) {
                BaseDataSolidifyMessage message;
                BaseDataUseRelBit useRelBit = (BaseDataUseRelBit)useRelBitMap.get(orgId);
                if (null == useRelBit) continue;
                RoaringBitmap bit = useRelBit.getBit();
                if (enableVersion && "6".equals(ctrlStrategy)) {
                    bit.add(bitIndex);
                    bit.runOptimize();
                    message = new BaseDataSolidifyMessage(entity, orgId);
                    message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])new int[]{bitIndex})));
                    messageDto.add(message);
                    continue;
                }
                if ("6".equals(ctrlStrategy) || orgId.equals(currentOrgId) || bit.contains(srcBitIndex)) {
                    bit.add(bitIndex);
                    bit.remove(srcBitIndex);
                    bit.runOptimize();
                    message = new BaseDataSolidifyMessage(entity, orgId);
                    message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])new int[]{bitIndex})));
                    message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])new int[]{srcBitIndex})));
                    messageDto.add(message);
                    continue;
                }
                useRelBitMap.remove(orgId);
            }
            BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), (String)entity);
            if (asyncRecord) {
                this.publish(messageDto);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void updateCustomDataSourceInfo(String entity, int bitIndex, int srcBitIndex, Long customDataId, Long srcDataId, Set<Long> customChildOrgIds) {
        if (CollectionUtils.isEmpty(customChildOrgIds)) {
            return;
        }
        IDataEntityType entityType = ORM.create().getDataEntityType(entity);
        String tableName = entityType.getAlias();
        StringJoiner joiner = new StringJoiner(String.valueOf(','));
        customChildOrgIds.forEach(orgId -> joiner.add("?"));
        String updateSql = String.format("update %s set fsourcedataid = ?, fsourcebitindex = ? where fsourcedataid = ? and fsourcebitindex = ? and fcreateorgid in (%s);", tableName, joiner.toString());
        ArrayList<Number> params = new ArrayList<Number>(10);
        params.add(customDataId);
        params.add(bitIndex);
        params.add(srcDataId);
        params.add(srcBitIndex);
        params.addAll(customChildOrgIds);
        DB.execute((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)updateSql, (Object[])params.toArray(new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexAndSourceId(DynamicObject data, Long sourceId) {
        data.set("srcindex", data.get("bitindex"));
        data.set("sourcedata", (Object)sourceId);
        String entityId = data.getDataEntityType().getName();
        String lockKey = this.getGenIndexLockKey(entityId);
        DLock lock = DLock.create((String)lockKey);
        lock.lock();
        try {
            int bitIndex = this.getMaxBitIndex(entityId, 1) + 1;
            data.set("bitindex", (Object)bitIndex);
            this.updateBaseDataBitIndexCache(entityId, String.valueOf(bitIndex));
        }
        finally {
            lock.unlock();
        }
    }

    public Map<Long, String> batchCustomBaseData(String entity, Long orgId, List<DynamicObject[]> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyMap();
        }
        this.setEntity(entity);
        Map threadLocal = (Map)BDCtrlLogHelper.THREAD_LOCAL.get();
        if (null == threadLocal || null == threadLocal.get("source")) {
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.OTHER);
        }
        ArrayList<Long> oldIdList = new ArrayList<Long>(dataList.size());
        for (DynamicObject[] data : dataList) {
            DynamicObject oldObj = data[0];
            Long oldId = (Long)oldObj.getPkValue();
            oldIdList.add(oldId);
        }
        Map<Long, String> customVerify = this.batchCustomVerify(orgId, dataList);
        if (CollectionUtils.isEmpty(dataList)) {
            BDCtrlLogHelper.saveIndividualizeLog((String)entity, oldIdList, (Long)orgId, customVerify);
            return customVerify;
        }
        new BaseDataSupplementService().individualizeSupplement(entity, dataList);
        boolean isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail((String)entity);
        HashMap<Long, Long> original2CurrPkMap = new HashMap<Long, Long>(dataList.size());
        ArrayList<Long> resetLeaves = new ArrayList<Long>(dataList.size());
        HashMap<Long, String> verifyResult = new HashMap<Long, String>(customVerify);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)orgId)};
        DynamicObject useOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])qFilters);
        for (DynamicObject[] dynamicObjects : dataList) {
            String msg;
            DynamicObject oldObj = dynamicObjects[0];
            DynamicObject newObj = dynamicObjects[1];
            if (oldObj == null || newObj == null) continue;
            if (oldObj.getPkValue().equals(newObj.getPkValue())) {
                CloneUtils cloneUtils = new CloneUtils(true, true);
                newObj = dynamicObjects[1] = (DynamicObject)cloneUtils.clone((IDataEntityBase)newObj);
                newObj.set("id", null);
                newObj.set("createorg", (Object)orgId);
                newObj.set("createorg_id", (Object)orgId);
                newObj.set("org_id", (Object)orgId);
                newObj.set(this.masterIdPropName, (Object)oldObj.getLong(this.masterIdPropName));
            }
            String number = oldObj.getString(this.numberField);
            Long oldPk = (Long)oldObj.getPkValue();
            try {
                int bitIndex = oldObj.getInt("bitindex");
                if (0 == bitIndex) {
                    msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u539f\u6570\u636ebitIndex\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\uff0c\u65b0\u6a21\u578b\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_10", (String)"bos-bd-business", (Object[])new Object[0]), number);
                    verifyResult.put(oldPk, msg);
                    continue;
                }
                newObj.set("bitindex", (Object)bitIndex);
            }
            catch (Exception e) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u539f\u6570\u636ebitIndex\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\uff0c\u65b0\u6a21\u578b\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_10", (String)"bos-bd-business", (Object[])new Object[0]), number);
                verifyResult.put(oldPk, msg);
                continue;
            }
            newObj.set("useorg", (Object)useOrg);
            this.executeBaseDataCustom(orgId, oldObj, newObj, verifyResult);
            if (!isAssignUnDetail || newObj.getBoolean("isleaf") || verifyResult.containsKey(oldPk)) continue;
            Long newPk = (Long)newObj.getPkValue();
            String ctrlStrategy = newObj.getString("ctrlstrategy");
            if ("1".equals(ctrlStrategy)) {
                resetLeaves.add(newPk);
                original2CurrPkMap.put(oldPk, newPk);
                continue;
            }
            if (!"2".equals(ctrlStrategy)) continue;
            resetLeaves.add(newPk);
        }
        if (isAssignUnDetail && !resetLeaves.isEmpty()) {
            TreeBaseDataCommonService service = new TreeBaseDataCommonService(entity);
            service.correctTreeDataHierarchy(orgId, resetLeaves, original2CurrPkMap);
        }
        BDCtrlLogHelper.saveIndividualizeLog((String)entity, oldIdList, (Long)orgId, verifyResult);
        return verifyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBaseDataCustom(Long orgId, DynamicObject oldObj, DynamicObject newObj, Map<Long, String> verifyResult) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin;
        boolean executeBusinessModify;
        Long pkId = (Long)oldObj.getPkValue();
        List mutexResults = BaseDataMutexUtils.batchRequireAndReturnFailMutex((String)this.entity, Collections.singletonList(pkId), (String)"individuation");
        try (TXHandle tx = TX.required((String)"batch_custom_base_data");){
            if (!mutexResults.isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5bf9\u8be5\u6570\u636e\u4e2a\u6027\u5316\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u540c\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_8", (String)"bos-bd-business", (Object[])new Object[0]), oldObj.getString(this.numberField));
                verifyResult.put(pkId, msg);
                return;
            }
            executeBusinessModify = newObj.getPkValue() == null || newObj.getPkValue().equals(0L);
            try {
                this.setIndexAndSourceId(newObj, pkId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
                this.handleCustomBaseData(this.entity, orgId, newObj);
            }
            catch (Exception e) {
                executeBusinessModify = false;
                tx.markRollback();
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e2a\u6027\u5316\u6570\u636e\u7684\u4f4d\u56fe\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u9700\u8981\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\uff0c\u7136\u540e\u91cd\u65b0\u6267\u884c\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_6", (String)"bos-bd-business", (Object[])new Object[0]), oldObj.getString(this.numberField));
                LOGGER.error(msg, (Throwable)e);
                verifyResult.put(pkId, msg);
            }
        }
        finally {
            if (mutexResults.isEmpty()) {
                BaseDataMutexUtils.batchRelease((String)this.entity, (String)"individuation", Collections.singletonList(pkId));
            }
        }
        if (executeBusinessModify && (baseDataCtrlPlugin = this.getBaseDataCtrlPlugin(this.entity)) != null) {
            baseDataCtrlPlugin.handleModify(newObj);
        }
    }

    private Map<Long, String> batchCustomVerify(Long orgId, List<DynamicObject[]> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> verifyResult = new HashMap<Long, String>(0);
        DataMutex dataMutex = DataMutex.create();
        Iterator<DynamicObject[]> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            DynamicObject[] next = iterator.next();
            DynamicObject oldObj = next[0];
            if (null == oldObj) continue;
            Long dataId = (Long)oldObj.getPkValue();
            Long masterId = oldObj.getLong(this.masterIdPropName);
            String ctrlStrategy = oldObj.getString("ctrlstrategy");
            Map lockInfo = dataMutex.getLockInfo(dataId.toString(), "individuation", this.entity);
            Long createOrgId = BaseDataCustomService.getLongPropertyFromDynamicObject(oldObj, "createorg");
            String number = oldObj.getString(this.numberField);
            if ("5".equals(ctrlStrategy)) {
                verifyResult.put(dataId, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5168\u5c40\u5171\u4eab\u7c7b\u578b\u6570\u636e\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_1", (String)"bos-bd-business", (Object[])new Object[0]), number));
                iterator.remove();
                continue;
            }
            if ("7".equals(ctrlStrategy)) {
                verifyResult.put(dataId, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u79c1\u6709\u7c7b\u578b\u6570\u636e\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_2", (String)"bos-bd-business", (Object[])new Object[0]), number));
                iterator.remove();
                continue;
            }
            if (!dataId.equals(masterId) && createOrgId.equals(orgId)) {
                verifyResult.put(dataId, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u4e2a\u6027\u5316\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_3", (String)"bos-bd-business", (Object[])new Object[0]), number));
                iterator.remove();
                continue;
            }
            if (createOrgId.equals(orgId)) {
                verifyResult.put(dataId, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u80fd\u4e2a\u6027\u5316\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"BaseDataCustomService_4", (String)"bos-bd-business", (Object[])new Object[0]), number));
                iterator.remove();
                continue;
            }
            if (null == lockInfo) continue;
            verifyResult.put(dataId, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u6570\u636e\u6b63\u5728\u4e2a\u6027\u5316\u4e2d\uff0c\u4e0d\u80fd\u540c\u65f6\u5bf9\u540c\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4e2a\u6027\u5316\u3002", (String)"BaseDataCustomService_5", (String)"bos-bd-business", (Object[])new Object[0]), number));
            iterator.remove();
        }
        return verifyResult;
    }

    public Map<Long, String> getCustomOrgInfo(DynamicObject data, Long useOrgId) {
        if (StringUtils.isEmpty((CharSequence)this.entity)) {
            throw new KDBizException("the 'entity' field is empty, please call constructor with parameters to instance the object.");
        }
        String strategy = data.getString("ctrlstrategy");
        if (!"1".equals(strategy) && !"2".equals(strategy)) {
            return Collections.emptyMap();
        }
        Long id = data.getLong("id");
        Long mId = data.getLong(this.masterIdPropName);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        if ("2".equals(strategy) && !id.equals(mId)) {
            return Collections.emptyMap();
        }
        if ("1".equals(strategy)) {
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
            Long viewId = (Long)ctrlView.getPkValue();
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, Collections.singletonList(useOrgId), (boolean)false);
            if (CollectionUtils.isEmpty((Collection)subOrgIds)) {
                return Collections.emptyMap();
            }
            filters.add(new QFilter("createorg", "in", (Object)subOrgIds));
        }
        filters.add(QFilter.sqlExpress((String)"id", (String)"!=", (String)this.masterIdFieldName));
        filters.add(new QFilter(this.masterIdPropName, "=", (Object)mId));
        String selectFields = "createorg.id, createorg.name";
        Collection customs = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0])).values();
        if (CollectionUtils.isEmpty(customs)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> orgInfoMap = new HashMap<Long, String>(customs.size());
        customs.forEach(custom -> orgInfoMap.put(custom.getLong("createorg.id"), custom.getString("createorg.name")));
        return orgInfoMap;
    }

    public static Map<Long, List<Long>> getCustomOrgDataInfo(String entity, Collection<Long> orgIds, Collection<Long> dataIds, Long useOrgId) {
        if (CollectionUtils.isEmpty(orgIds) || CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyMap();
        }
        QFilter filter = new QFilter("id", "in", dataIds);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)entity, (Long)useOrgId, (QFilter)filter, (String)"id");
        if (dataIds.size() != collection.size()) {
            throw new KDBizException("The data is unavailable to the organization for personalized queries.");
        }
        HashMap id2MstIdMap = new HashMap(0);
        String masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        try (DataSet ds = orm.queryDataSet(BaseDataCustomService.class.getName(), entity, "id, " + masterIdProp, filters);){
            ds.forEach(row -> id2MstIdMap.put(row.getLong("id"), row.getLong(masterIdProp)));
        }
        filters = new QFilter[]{new QFilter("createorg", "in", orgIds), new QFilter(masterIdProp, "in", id2MstIdMap.values()), QFilter.sqlExpress((String)"id", (String)"!=", (String)BaseDataServiceHelper.getMasterIdFieldName((String)entity))};
        HashMap mstIdOrgMap = new HashMap(16);
        try (DataSet ds = ORM.create().queryDataSet(BaseDataCustomService.class.getName(), entity, "createorg," + masterIdProp, filters);){
            ds.forEach(e -> mstIdOrgMap.computeIfAbsent(e.getLong(masterIdProp), k -> new HashSet(16)).add(e.getLong("createorg")));
        }
        if (mstIdOrgMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, Long> mstId2IdMap = id2MstIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashMap<Long, List<Long>> customOrgDataInfo = new HashMap<Long, List<Long>>(mstIdOrgMap.size());
        for (Map.Entry entry : mstIdOrgMap.entrySet()) {
            Long dataId = mstId2IdMap.get(entry.getKey());
            if (null == dataId) continue;
            customOrgDataInfo.computeIfAbsent(dataId, k -> new ArrayList(10)).addAll((Collection)entry.getValue());
        }
        return customOrgDataInfo;
    }

    void executeIndividualizeOnFreeStrategy(Long orgId, List<Long> dataIds, IBaseDataCtrlPlugin service) {
        Map<Integer, Integer> index2SrcIndexMap = this.generateIndividualizeData(dataIds, orgId, service);
        String lockKey = BaseDataCustomService.getBaseDataUnifiedLockKey(this.entity);
        DLock lock = DLock.createReentrant((String)lockKey);
        lock.lock();
        TXHandle tx = TX.required((String)"custom_base_data");
        try {
            RoaringBitmap bit;
            Map useRelBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(Collections.singletonList(orgId), (String)this.entity);
            int[] addIndexArr = this.covertIntegerList2IntArr(index2SrcIndexMap.keySet());
            int[] delIndexArr = this.covertIntegerList2IntArr(index2SrcIndexMap.values());
            BaseDataUseRelBit useRelBit = (BaseDataUseRelBit)useRelBitMap.get(orgId);
            if (null != useRelBit) {
                bit = useRelBit.getBit();
                bit.add(addIndexArr);
                bit.andNot(RoaringBitmap.bitmapOf((int[])delIndexArr));
                bit.runOptimize();
                BaseDataUseRelUpdateEngine.update(useRelBitMap.values(), (String)this.entity);
            } else {
                bit = RoaringBitmap.bitmapOf((int[])addIndexArr);
                bit.runOptimize();
                useRelBit = new BaseDataUseRelBit();
                useRelBit.setOrgId(orgId);
                useRelBit.setBit(bit);
                BaseDataUseRelUpdateEngine.insert(new ArrayList<BaseDataUseRelBit>(Collections.singleton(useRelBit)), (String)this.entity);
            }
            if (this.asyncRecord()) {
                BaseDataSolidifyMessageDTO messageDto = new BaseDataSolidifyMessageDTO(1);
                BaseDataSolidifyMessage message = new BaseDataSolidifyMessage(this.entity, orgId);
                message.add(this.createAddSolidifyMessage(RoaringBitmap.bitmapOf((int[])addIndexArr)));
                message.add(this.createDelSolidifyMessage(RoaringBitmap.bitmapOf((int[])delIndexArr)));
                messageDto.add(message);
                this.publish(messageDto);
            }
        }
        catch (Exception e) {
            tx.markRollback();
            LOGGER.error("\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u6027\u5316\u6570\u636e\u5f02\u5e38\u3002", (String)"BaseDataCustomService_0", (String)"bos-bd-business", (Object[])new Object[0]);
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        finally {
            tx.close();
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> generateIndividualizeData(List<Long> dataIds, Long useOrgId, IBaseDataCtrlPlugin service) {
        HashMap<Long, Long> data2CreateOrgMap = new HashMap<Long, Long>(dataIds.size());
        Map<Long, DynamicObject> individualizeMap = this.copyOriginalData(dataIds, useOrgId, data2CreateOrgMap);
        String lockKey = this.getGenIndexLockKey(this.entity);
        DLock lock = DLock.create((String)lockKey);
        lock.lock();
        try {
            int bitIndex = this.getMaxBitIndex(this.entity, individualizeMap.size());
            for (DynamicObject v : individualizeMap.values()) {
                v.set("bitindex", (Object)(++bitIndex));
            }
            this.updateBaseDataBitIndexCache(this.entity, String.valueOf(bitIndex));
        }
        finally {
            lock.unlock();
        }
        if (service != null) {
            service.beforeSaveIndividualizeData(this.entity, data2CreateOrgMap, useOrgId, individualizeMap);
        }
        Object[] values = SaveServiceHelper.save((DynamicObject[])individualizeMap.values().toArray(new DynamicObject[0]));
        if (null != service) {
            service.afterSaveIndividualizeData(this.entity, data2CreateOrgMap, useOrgId, individualizeMap);
        }
        try {
            IBaseDataCtrlPlugin plugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entity);
            if (null != plugin) {
                for (DynamicObject newDataInfo : individualizeMap.values()) {
                    plugin.handleModify(newDataInfo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4e2a\u6027\u5316\u4e1a\u52a1\u5904\u7406\u5f02\u5e38...", (Throwable)e);
        }
        HashMap<Integer, Integer> index2SrcIndexMap = new HashMap<Integer, Integer>(values.length);
        for (Object value : values) {
            DynamicObject v = (DynamicObject)value;
            index2SrcIndexMap.put(v.getInt("bitindex"), v.getInt("srcindex"));
        }
        return index2SrcIndexMap;
    }

    private Map<Long, DynamicObject> copyOriginalData(List<Long> dataIds, Long useOrgId, Map<Long, Long> data2CreateOrgMap) {
        DynamicObject[] originals = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entity));
        CloneUtils cloneUtils = new CloneUtils(true, true);
        HashMap<Long, DynamicObject> individualizeMap = new HashMap<Long, DynamicObject>(dataIds.size());
        DynamicObject useOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)useOrgId)});
        for (int i = 0; i < originals.length; ++i) {
            DynamicObject originalData = originals[i];
            Long createOrgId = BaseDataCustomService.getLongPropertyFromDynamicObject(originalData, "createorg");
            DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)originalData);
            clone.set("id", null);
            clone.set("createorg", (Object)useOrgId);
            clone.set(this.masterIdPropName, (Object)originalData.getLong(this.masterIdPropName));
            clone.set("createOrg_id", (Object)useOrgId);
            clone.set("org_id", (Object)useOrgId);
            clone.set("useorg", (Object)useOrg);
            clone.set("srccreateorg", originalData.get("createorg"));
            clone.set("sourcedata", originalData.getPkValue());
            clone.set("srcindex", (Object)originalData.getInt("bitindex"));
            Long pk = (Long)originalData.getPkValue();
            individualizeMap.put(pk, clone);
            data2CreateOrgMap.put(pk, createOrgId);
            originals[i] = null;
        }
        return individualizeMap;
    }
}

