/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.ESAdapterContext;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.roaringbitmap.RoaringBitmap;

class BaseDataOrgUseRangService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataOrgUseRangService.class);

    BaseDataOrgUseRangService(String entity) {
        if (StringUtils.isEmpty((CharSequence)entity)) {
            throw new KDBizException("the parameters [entity] should not be empty.");
        }
        super.init(entity);
    }

    QFilter getBaseDataFilter(Long orgId) {
        Long realOrgId = this.getSupCtrlUnitIfIsUnCtrlUint(orgId);
        return this.getSingleOrgDataUseRangFilter(realOrgId);
    }

    private QFilter getSingleOrgDataUseRangFilter(Long orgId) {
        DynamicObject config = BaseDataOrgUseRangService.getCtrlStrategyConfig(this.entity);
        if (this.isQueryFromSolidifyTable(orgId, config)) {
            return this.getFilterFromSolidifyTable(config, orgId);
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        int[] indexes = new int[]{};
        try {
            indexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexArrByOrgId((Long)orgId, (String)this.entity);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u83b7\u53d6\u7ec4\u7ec7\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\uff0c\u7ec4\u7ec7id\u4e3a\uff1a%s\uff0c\u53d7\u63a7\u5b9e\u4f53\u4e3a\uff1a%s", orgId, this.entity), (Throwable)e);
        }
        int defaultInMaxSize = 500000;
        if (this.isSolidify(config) && indexes.length > Integer.getInteger("orm.opt.in.maxsize", defaultInMaxSize)) {
            LOGGER.error("\u65b0\u6a21\u578bgetSingleOrgDataUseRangFilter\u67e5\u8be2\u6570\u636e\u8fc7\u6ee4\u6761\u4ef6in\u7684\u53c2\u6570\u4e2a\u6570\u8d85\u8fc7\u4e34\u65f6\u8868\u4e0a\u9650\uff0c\u6539\u8d70\u56fa\u5316\u8868\u67e5\u8be2\u3002");
            return this.getFilterFromSolidifyTable(config, orgId);
        }
        boolean hasGlobalShareData = this.hasGlobalShareData(dt);
        QFilter cuShareFilter = null;
        if (!BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity)) {
            String billStatusKey = dt.getBillStatus();
            boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
            cuShareFilter = this.getCuShareFilter(isIgnoreStatus, billStatusKey, Collections.singletonList(orgId));
        }
        if (!hasGlobalShareData && indexes.length == 0) {
            return new QFilter("bitindex", "in", (Object)indexes).or(cuShareFilter);
        }
        if (hasGlobalShareData) {
            QFilter globalShareFilter = this.getGlobalShareFilter(dt, Collections.singletonList(orgId));
            if (indexes.length > 0) {
                QFilter indexFilter = new QFilter("bitindex", "in", (Object)indexes);
                return indexFilter.or(globalShareFilter).or(cuShareFilter);
            }
            return globalShareFilter.or(cuShareFilter);
        }
        return new QFilter("bitindex", "in", (Object)indexes).or(cuShareFilter);
    }

    QFilter getBaseDataFilter(List<Long> orgIds, boolean isRemoveDup) {
        List<Long> realOrgIds = this.getSupCtrlUnitIfIsUnCtrlUint(orgIds);
        if (1 == realOrgIds.size()) {
            return this.getSingleOrgDataUseRangFilter(realOrgIds.get(0));
        }
        int[] indexes = new int[]{};
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        try {
            indexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexArrByOrgId(realOrgIds, (String)this.entity);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u83b7\u53d6\u7ec4\u7ec7\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\uff0c\u7ec4\u7ec7id\u4e3a\uff1a%s\uff0c\u53d7\u63a7\u5b9e\u4f53\u4e3a\uff1a%s", realOrgIds, this.entity), (Throwable)e);
        }
        boolean isHasGlobalShareData = this.hasGlobalShareData(dt);
        QFilter cuShareFilter = null;
        if (!BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity)) {
            String billStatusKey = dt.getBillStatus();
            boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
            cuShareFilter = this.getCuShareFilter(isIgnoreStatus, billStatusKey, realOrgIds);
        }
        if (!isHasGlobalShareData && indexes.length == 0) {
            return new QFilter("bitindex", "in", (Object)indexes).or(cuShareFilter);
        }
        if (isHasGlobalShareData) {
            QFilter globalShareFilter = this.getGlobalShareFilter(dt, realOrgIds);
            if (indexes.length > 0) {
                if (isRemoveDup) {
                    indexes = this.removeDuplicateData(indexes);
                }
                QFilter indexFilter = new QFilter("bitindex", "in", (Object)indexes).or(cuShareFilter);
                return indexFilter.or(globalShareFilter).or(cuShareFilter);
            }
            return globalShareFilter.or(cuShareFilter);
        }
        if (isRemoveDup) {
            indexes = this.removeDuplicateData(indexes);
        }
        return new QFilter("bitindex", "in", (Object)indexes).or(cuShareFilter);
    }

    QFilter getBaseDataProFilter(Long orgId, String property) {
        try {
            List bitIndexes = BaseDataUseRelQueryEngine.getUseBaseDataIndexByOrgId((Long)orgId, (String)this.entity);
            bitIndexes.addAll(this.getShareDataIndexes(orgId));
            if ("id".equals(property)) {
                List pks = QueryServiceHelper.queryPrimaryKeys((String)this.entity, (QFilter[])new QFilter[]{new QFilter("bitindex", "in", (Object)bitIndexes)}, (String)"", (int)-1);
                return new QFilter("id", "in", new HashSet(pks));
            }
            if ("createorg".equals(property)) {
                BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
                SqlBuilder builder = new SqlBuilder();
                builder.append(String.format("select fcreateorgid from %s where ", dt.getAlias()), new Object[0]).appendIn("fbitindex", bitIndexes.toArray());
                Set orgIds = (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, resultSet -> {
                    HashSet<Long> ids = new HashSet<Long>(16);
                    while (resultSet.next()) {
                        ids.add(resultSet.getLong("fcreateorgid"));
                    }
                    return ids;
                });
                return new QFilter("entryentity.createorg", "in", (Object)orgIds);
            }
        }
        catch (Exception e) {
            LOGGER.error("getBaseDataProFilter\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    QFilter getBaseDataFuzzQueryFilter(List<QFilter> fastFilters, Set<Long> orgIds) {
        BillEntityType dt;
        boolean isIgnoreStatus;
        String billStatusKey;
        String selectFields;
        DynamicObjectCollection collection;
        boolean isEnableEsSearch;
        boolean isRemoveDup;
        boolean bl = isRemoveDup = !BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity) && !CollectionUtils.isEmpty(orgIds) && orgIds.size() > 1;
        if (CollectionUtils.isEmpty(fastFilters)) {
            return BaseDataServiceHelper.getBaseDataFilter((String)this.entity, new ArrayList<Long>(orgIds), (boolean)isRemoveDup);
        }
        fastFilters.removeIf(Objects::isNull);
        if (CollectionUtils.isEmpty(fastFilters)) {
            return BaseDataServiceHelper.getBaseDataFilter((String)this.entity, new ArrayList<Long>(orgIds), (boolean)isRemoveDup);
        }
        boolean bl2 = isEnableEsSearch = ESAdapterContext.isEsQuery() && DataSyncAgent.isQueryEnable((String)this.entity);
        if (isEnableEsSearch) {
            return orgIds.size() == 1 ? this.getBaseDataFilter(new ArrayList<Long>(orgIds).get(0)) : this.getBaseDataFilter(new ArrayList<Long>(orgIds), isRemoveDup);
        }
        List<Long> realOrgIds = this.getSupCtrlUnitIfIsUnCtrlUint(new ArrayList<Long>(orgIds));
        if (realOrgIds.size() == 1) {
            DynamicObject config = BaseDataOrgUseRangService.getCtrlStrategyConfig(this.entity);
            Long orgId = realOrgIds.get(0);
            if (this.isQueryFromSolidifyTable(orgId, config)) {
                return this.getFilterFromSolidifyTable(config, orgId);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(collection = QueryServiceHelper.query((String)this.entity, (String)(selectFields = this.rebuildSelectFields(null, billStatusKey, isIgnoreStatus = StringUtils.isBlank((CharSequence)(billStatusKey = (dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity)).getBillStatus())) || dt.getProperty(billStatusKey).isDbIgnore())), (QFilter[])fastFilters.toArray(new QFilter[0]))))) {
            return new QFilter("bitindex", "in", new ArrayList(0));
        }
        int maxSize = Integer.getInteger("orm.opt.in.maxsize", 500000);
        if (collection.size() < maxSize) {
            return this.getFuzzQueryFilter(realOrgIds, isRemoveDup, billStatusKey, isIgnoreStatus, collection);
        }
        return orgIds.size() == 1 ? this.getBaseDataFilter(new ArrayList<Long>(orgIds).get(0)) : this.getBaseDataFilter(new ArrayList<Long>(orgIds), isRemoveDup);
    }

    DynamicObjectCollection queryBaseData(Long orgId, QFilter filter, String selectFields, Date queryDate, boolean queryByDate) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String billStatusKey = dt.getBillStatus();
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        selectFields = this.rebuildSelectFields(selectFields, billStatusKey, isIgnoreStatus);
        orgId = this.getSupCtrlUnitIfIsUnCtrlUint(orgId);
        DynamicObjectCollection collection = queryByDate ? QueryServiceHelper.queryByDate((String)this.entity, (String)selectFields, (QFilter[])new QFilter[]{filter}, (Date)queryDate) : QueryServiceHelper.query((String)this.entity, (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)collection) || null == orgId) {
            return collection;
        }
        boolean isTreeType = BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity);
        HashSet<Long> supper = new HashSet<Long>(Collections.singletonList(orgId));
        if (!isTreeType) {
            supper.addAll(this.getSupperOrgIds(Collections.singletonList(orgId)));
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashMap<Integer, DynamicObject> indexDataMap = new HashMap<Integer, DynamicObject>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            boolean isCuShareData;
            String strategy = dynamicObject.getString("ctrlstrategy");
            boolean globalShare = "5".equals(strategy);
            boolean isAudit = isIgnoreStatus || BillStatus.C.name().equals(dynamicObject.getString(billStatusKey));
            Long createOrgId = this.getLongDataFromDynamicObject(dynamicObject.get("createorg"));
            if (globalShare) {
                if (isIgnoreStatus) {
                    result.add((Object)dynamicObject);
                    continue;
                }
                if (!orgId.equals(createOrgId) && !isAudit) continue;
                result.add((Object)dynamicObject);
                continue;
            }
            if (isTreeType || !"6".equals(strategy)) {
                indexDataMap.put(dynamicObject.getInt("bitindex"), dynamicObject);
                continue;
            }
            if (isIgnoreStatus && supper.contains(createOrgId)) {
                result.add((Object)dynamicObject);
                continue;
            }
            if (isIgnoreStatus || !(isCuShareData = orgId.equals(createOrgId) || isAudit && supper.contains(createOrgId))) continue;
            result.add((Object)dynamicObject);
        }
        if (indexDataMap.isEmpty()) {
            return result;
        }
        try {
            RoaringBitmap bit = (RoaringBitmap)BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(Collections.singleton(orgId), (String)this.entity).get(orgId);
            if (null == bit) {
                return result;
            }
            RoaringBitmap queryBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexDataMap.keySet()));
            queryBit.runOptimize();
            queryBit.and(bit);
            for (int index : queryBit.toArray()) {
                result.add(indexDataMap.get(index));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7ec4\u7ec7\u4f4d\u56fe\u5931\u8d25\uff0c\u7ec4\u7ec7id\u4e3a\uff1a" + orgId + "\uff0c\u8d44\u6599\u5b9e\u4f53\u6807\u8bc6\u4e3a\uff1a" + this.entity, (Throwable)e);
        }
        return result;
    }

    Map<Object, DynamicObject> queryBaseDataFromCache(Long orgId, QFilter filter, String selectFields) {
        String billStatusKey;
        if (null == (orgId = this.getSupCtrlUnitIfIsUnCtrlUint(orgId))) {
            return Collections.emptyMap();
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)(billStatusKey = dt.getBillStatus())) || dt.getProperty(billStatusKey).isDbIgnore();
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)this.entity, (String)(selectFields = this.rebuildSelectFields(selectFields, billStatusKey, isIgnoreStatus)), (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            return dataMap;
        }
        boolean isTreeType = BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity);
        HashSet<Long> supper = new HashSet<Long>(Collections.singletonList(orgId));
        if (!isTreeType) {
            supper.addAll(this.getSupperOrgIds(Collections.singletonList(orgId)));
        }
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(dataMap.size());
        HashMap<Integer, DynamicObject> indexDataMap = new HashMap<Integer, DynamicObject>(dataMap.size());
        for (Map.Entry entry : dataMap.entrySet()) {
            boolean isCuShareData;
            boolean isAudit;
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            String strategy = dynamicObject.getString("ctrlstrategy");
            boolean globalShare = "5".equals(strategy);
            Long createOrgId = this.getLongDataFromDynamicObject(dynamicObject.get("createorg"));
            boolean bl = isAudit = isIgnoreStatus || BillStatus.C.name().equals(dynamicObject.getString(billStatusKey));
            if (globalShare) {
                if (isIgnoreStatus) {
                    result.put(entry.getKey(), dynamicObject);
                    continue;
                }
                if (!orgId.equals(createOrgId) && !isAudit) continue;
                result.put(entry.getKey(), dynamicObject);
                continue;
            }
            if (isTreeType || !"6".equals(strategy)) {
                indexDataMap.put(dynamicObject.getInt("bitindex"), dynamicObject);
                continue;
            }
            if (isIgnoreStatus && supper.contains(createOrgId)) {
                result.put(entry.getKey(), dynamicObject);
                continue;
            }
            if (isIgnoreStatus || !(isCuShareData = orgId.equals(createOrgId) || isAudit && supper.contains(createOrgId))) continue;
            result.put(entry.getKey(), dynamicObject);
        }
        if (indexDataMap.isEmpty()) {
            return result;
        }
        try {
            RoaringBitmap bit = (RoaringBitmap)BaseDataUseRelQueryEngine.getOrgUseRelBitMapByOrgIds(Collections.singleton(orgId), (String)this.entity).get(orgId);
            if (null != bit) {
                RoaringBitmap queryBit = RoaringBitmap.bitmapOf((int[])this.covertIntegerList2IntArr(indexDataMap.keySet()));
                queryBit.runOptimize();
                queryBit.and(bit);
                for (int index : queryBit.toArray()) {
                    DynamicObject dynamicObject = (DynamicObject)indexDataMap.get(index);
                    result.put(dynamicObject.getPkValue(), dynamicObject);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7ec4\u7ec7\u4f4d\u56fe\u5931\u8d25\uff0c\u7ec4\u7ec7id\u4e3a\uff1a" + orgId + "\uff0c\u8d44\u6599\u5b9e\u4f53\u6807\u8bc6\u4e3a\uff1a" + this.entity, (Throwable)e);
        }
        return result;
    }

    Long getSupCtrlUnitIfIsUnCtrlUint(Long orgId) {
        boolean existData;
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        String treeType = ctrlView.getString("treetype");
        if (!"16".equals(treeType)) {
            return orgId;
        }
        QFilter viewFilter = new QFilter("view.id", "=", (Object)ctrlView.getLong("id"));
        QFilter[] filters = new QFilter[]{viewFilter, new QFilter("org.id", "=", (Object)orgId)};
        DynamicObject viewOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"isctrlunit", (QFilter[])filters);
        boolean bl = existData = null != viewOrg;
        if (!existData || viewOrg.getBoolean("isctrlunit")) {
            return orgId;
        }
        String viewNumber = ctrlView.getString("number");
        HashSet supOrgIdSet = new HashSet(OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, (long)orgId));
        filters = new QFilter[]{viewFilter, new QFilter("org.id", "in", supOrgIdSet), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE)};
        Map viewOrgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org.id", (QFilter[])filters, (String)"longnumber desc");
        for (Map.Entry entry : viewOrgMap.entrySet()) {
            viewOrg = (DynamicObject)entry.getValue();
            long viewOrgId = viewOrg.getLong("org.id");
            if (0L == viewOrgId) continue;
            return viewOrgId;
        }
        return orgId;
    }

    List<Long> getSupCtrlUnitIfIsUnCtrlUint(List<Long> orgIds) {
        ArrayList<Long> ctrlUnits = new ArrayList<Long>(orgIds.size());
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        String treeType = ctrlView.getString("treetype");
        if (!"16".equals(treeType)) {
            ctrlUnits.addAll(orgIds);
            return ctrlUnits;
        }
        ArrayList<String> unCuOrgLongNumber = new ArrayList<String>(orgIds.size());
        QFilter viewFilter = new QFilter("view.id", "=", (Object)ctrlView.getLong("id"));
        QFilter orgFilter = new QFilter("org.id", "in", orgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        String selectFields = "org.id, isctrlunit, level, longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                Long tempOrgId = row.getLong("org.id");
                if (row.getBoolean("isctrlunit").booleanValue() || row.getInteger("level") == 1) {
                    ctrlUnits.add(tempOrgId);
                    continue;
                }
                unCuOrgLongNumber.add(row.getString("longnumber"));
            }
        }
        if (CollectionUtils.isEmpty(unCuOrgLongNumber)) {
            return ctrlUnits;
        }
        String sep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        HashSet<String> allLongNumberSet = new HashSet<String>(orgIds.size());
        for (String longNumber : unCuOrgLongNumber) {
            while (longNumber.contains(sep)) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf(sep));
                allLongNumberSet.add(longNumber);
            }
        }
        QFilter longNumberFilter = new QFilter("longnumber", "in", allLongNumberSet);
        filters = new QFilter[]{viewFilter, longNumberFilter};
        HashMap parentOrgMap = new HashMap(16);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        collection.forEach(e -> parentOrgMap.put(e.getString("longnumber"), e));
        block12: for (String longNumber : unCuOrgLongNumber) {
            while (longNumber.contains(sep)) {
                DynamicObject parentOrg = (DynamicObject)parentOrgMap.get(longNumber = longNumber.substring(0, longNumber.lastIndexOf(sep)));
                if (null == parentOrg || !parentOrg.getBoolean("isctrlunit")) continue;
                Long tempOrgId = parentOrg.getLong("org.id");
                if (ctrlUnits.contains(tempOrgId)) continue block12;
                ctrlUnits.add(tempOrgId);
                continue block12;
            }
        }
        return ctrlUnits;
    }

    private QFilter getFilterFromSolidifyTable(DynamicObject config, Long orgId) {
        DynamicObject obj = config.getDynamicObject("solidifyobj");
        String objEntity = obj.getPkValue().toString();
        return QFilter.join((String)"bitindex", (String)String.format("%s.bitindex", objEntity), (QFilter)QFilter.of((String)String.format("%s.useorg = ?", objEntity), (Object[])new Object[]{orgId}));
    }

    private boolean hasGlobalShareData(BillEntityType dt) {
        Boolean hasGlobalShareData = BaseDataCtrlCache.hasGlobalShareData((String)this.entity);
        if (null != hasGlobalShareData) {
            return hasGlobalShareData;
        }
        String sql = String.format("select top 1 fid from %s where FCTRLSTRATEGY = '5';", dt.getAlias());
        boolean isHasGlobalShareData = (Boolean)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql, (Object[])new Object[0], ResultSet::next);
        BaseDataCtrlCache.updateHasGlobalShareData((String)this.entity, (Boolean)isHasGlobalShareData);
        return isHasGlobalShareData;
    }

    private QFilter getCuShareFilter(boolean isIgnoreStatus, String billStatusKey, List<Long> orgIds) {
        List<Long> allOrgIds = this.getSupperOrgIds(orgIds);
        QFilter strategyFilter = new QFilter("ctrlstrategy", "=", (Object)"6");
        if (isIgnoreStatus) {
            if (allOrgIds.size() == 1) {
                return strategyFilter.and(new QFilter("createorg", "=", (Object)allOrgIds.get(0)));
            }
            return strategyFilter.and(new QFilter("createorg", "in", allOrgIds));
        }
        QFilter statusFilter = new QFilter(billStatusKey, "=", (Object)BillStatus.C.name());
        QFilter supplierFilter = statusFilter.and(new QFilter("createorg", "in", allOrgIds));
        QFilter ownerFilter = orgIds.size() == 1 ? new QFilter("createorg", "=", (Object)orgIds.get(0)) : new QFilter("createorg", "in", orgIds);
        QFilter filter = ownerFilter.or(supplierFilter);
        return strategyFilter.and(filter);
    }

    private List<Long> getSupperOrgIds(List<Long> orgIds) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entity);
        String viewNumber = ctrlView.getString("number");
        Map map = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, orgIds);
        HashSet<Long> allOrgIds = new HashSet<Long>(orgIds);
        for (Map.Entry entry : map.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            allOrgIds.addAll((Collection)entry.getValue());
        }
        return new ArrayList<Long>(allOrgIds);
    }

    private QFilter getGlobalShareFilter(BillEntityType dt, List<Long> orgIds) {
        boolean isIgnoreStatus;
        String billStatusKey = dt.getBillStatus();
        boolean bl = isIgnoreStatus = StringUtils.isBlank((CharSequence)billStatusKey) || dt.getProperty(billStatusKey).isDbIgnore();
        if (isIgnoreStatus) {
            return new QFilter("ctrlstrategy", "=", (Object)"5");
        }
        QFilter ownerFilter = orgIds.size() == 1 ? new QFilter("createorg", "=", (Object)orgIds.get(0)) : new QFilter("createorg", "in", orgIds);
        ownerFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        QFilter statusFilter = new QFilter(billStatusKey, "=", (Object)BillStatus.C.name());
        statusFilter.and(new QFilter("ctrlstrategy", "=", (Object)"5"));
        return ownerFilter.or(statusFilter);
    }

    private int[] removeDuplicateData(int[] indexes) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        String baseDataTableName = dt.getAlias();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entity);
        String dbRouteKey = entityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        boolean hasIdentify = false;
        SqlBuilder checkHasIdentifySql = new SqlBuilder();
        checkHasIdentifySql.append(" select top 1 fid from ", new Object[0]).append(baseDataTableName, new Object[0]);
        checkHasIdentifySql.append(" where fid <> ", new Object[0]).append(this.masterIdFieldName, new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)BaseDataOrgUseRangService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)checkHasIdentifySql);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                hasIdentify = true;
            }
        }
        if (hasIdentify) {
            List paramIndexes = Arrays.stream(indexes).boxed().collect(Collectors.toList());
            SqlBuilder removeDupSql = new SqlBuilder();
            removeDupSql.append("select ", new Object[0]).append("a.fbitindex", new Object[0]);
            removeDupSql.append(" from ", new Object[0]).append(baseDataTableName, new Object[0]).append(" a", new Object[0]);
            removeDupSql.append(" inner join ", new Object[0]).append(baseDataTableName, new Object[0]).append(" b", new Object[0]);
            removeDupSql.append(" on a.", new Object[0]).append(this.masterIdFieldName, new Object[0]).append(" = b.", new Object[0]).append(this.masterIdFieldName, new Object[0]);
            removeDupSql.append(" where ", new Object[0]).appendIn("b.fbitindex", paramIndexes);
            removeDupSql.append(" and a.fid = a.", new Object[0]).append(this.masterIdFieldName, new Object[0]);
            ArrayList<Integer> dataIds = new ArrayList<Integer>(indexes.length);
            try (DataSet ds = DB.queryDataSet((String)BaseDataOrgUseRangService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)removeDupSql);){
                for (Row row : ds) {
                    Integer tempIndex = row.getInteger("fbitindex");
                    dataIds.add(tempIndex);
                }
            }
            indexes = dataIds.stream().mapToInt(Integer::valueOf).toArray();
        }
        return indexes;
    }

    private List<Integer> getShareDataIndexes(Long orgId) {
        String strategy;
        BillEntityType dt;
        String billStatusKey;
        boolean specificType;
        String key = String.format("bd_%s_%s_%s", this.entity, RequestContext.get().getAccountId(), orgId);
        String[] cacheValue = BD_COMMON_CACHE.getList(key);
        if (null != cacheValue && cacheValue.length != 0) {
            return Arrays.stream(cacheValue).map(Integer::valueOf).collect(Collectors.toList());
        }
        HashSet<Long> orgIds = new HashSet<Long>(Collections.singletonList(orgId));
        boolean bl = specificType = !BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity);
        if (specificType) {
            orgIds.addAll(this.getSupperOrgIds(new ArrayList<Long>(Collections.singletonList(orgId))));
        }
        boolean isIgnoreStatus = StringUtils.isBlank((CharSequence)(billStatusKey = (dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity)).getBillStatus())) || dt.getProperty(billStatusKey).isDbIgnore();
        SqlBuilder builder = new SqlBuilder();
        String string = strategy = specificType ? "fctrlstrategy in ('5', '6')" : "fctrlstrategy = '5'";
        if (isIgnoreStatus) {
            builder.append("select fbitindex, fcreateorgid, fctrlstrategy from ", new Object[0]).append(dt.getAlias(), new Object[0]).append(" where ", new Object[0]).append(strategy, new Object[0]);
        } else {
            String statusField = dt.getProperty(billStatusKey).getAlias();
            builder.append("select fbitindex, fcreateorgid, fctrlstrategy, ", new Object[0]).append(statusField, new Object[0]).append(" from ", new Object[0]).append(dt.getAlias(), new Object[0]).append(" where ", new Object[0]).append(strategy, new Object[0]);
        }
        List result = (List)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            ArrayList<Integer> bitIndexes = new ArrayList<Integer>(10);
            while (rs.next()) {
                int index = rs.getInt("fbitindex");
                if (0 == index) continue;
                String ctrlStrategy = rs.getString("fctrlstrategy");
                Long createOrgId = rs.getLong("fcreateorgid");
                if (isIgnoreStatus) {
                    if (!"5".equals(ctrlStrategy) && !orgIds.contains(createOrgId)) continue;
                    bitIndexes.add(index);
                    continue;
                }
                if (orgId.equals(createOrgId)) {
                    bitIndexes.add(index);
                    continue;
                }
                String statusField = dt.getProperty(billStatusKey).getAlias();
                String status = BillStatus.C.name();
                if (!StringUtils.isNotBlank((CharSequence)statusField) || !status.equals(rs.getString(statusField)) || !"5".equals(ctrlStrategy) && !orgIds.contains(createOrgId)) continue;
                bitIndexes.add(index);
            }
            return bitIndexes;
        });
        if (!CollectionUtils.isEmpty((Collection)result)) {
            cacheValue = (String[])result.stream().map(String::valueOf).toArray(String[]::new);
            BD_COMMON_CACHE.addList(key, cacheValue, 300);
        }
        return result;
    }

    private String rebuildSelectFields(String selectFields, String billStatusKey, boolean isIgnoreStatus) {
        String[] split;
        HashSet<String> fields = new HashSet<String>(Arrays.asList("bitindex", "ctrlstrategy", "createorg"));
        if (!isIgnoreStatus) {
            fields.add(billStatusKey);
        }
        if (StringUtils.isBlank((CharSequence)selectFields)) {
            fields.add("id");
            return String.join((CharSequence)String.valueOf(','), fields);
        }
        for (String field : split = selectFields.split(String.valueOf(','))) {
            fields.remove(StringUtils.trim((String)field));
        }
        ArrayList<String> newSelectFields = new ArrayList<String>(Arrays.asList(split));
        newSelectFields.addAll(fields);
        return String.join((CharSequence)String.valueOf(','), newSelectFields);
    }

    private boolean isQueryFromSolidifyTable(Long orgId, DynamicObject config) {
        if (!this.isSolidify(config)) {
            return false;
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 fid from t_bd_solidify_msg where ", new Object[0]).append("fentity = ?", new Object[]{this.entity}).append("and", new Object[0]).append("fuseorgid = ?", new Object[]{orgId}).append("and fstatus = '0'", new Object[0]);
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, ResultSet::next) == false;
    }

    private boolean isSolidify(DynamicObject config) {
        boolean enableSolidify;
        if (!"2".equals(config.getString("upgradestatus"))) {
            return false;
        }
        boolean bl = enableSolidify = config.getBoolean("enablesolidify") && null != config.get("solidifyobj");
        if (!enableSolidify) {
            return false;
        }
        return config.getBoolean("solidifystatus");
    }

    private QFilter getFuzzQueryFilter(List<Long> orgIds, boolean isRemoveDup, String billStatusKey, boolean isIgnoreStatus, DynamicObjectCollection collection) {
        boolean isTreeType = BaseDataOrgUseRangService.isTreeTypeBaseData(this.entity);
        HashSet<Long> supper = new HashSet<Long>(orgIds);
        if (!isTreeType) {
            supper.addAll(this.getSupperOrgIds(orgIds));
        }
        ArrayList<Integer> globalIndexes = new ArrayList<Integer>(10);
        ArrayList<Integer> chShareIndexes = new ArrayList<Integer>(10);
        Set<Integer> fuzzQueryBitIndexes = new HashSet<Integer>(16);
        HashSet<Long> currOrgIds = new HashSet<Long>(orgIds);
        for (DynamicObject dynamicObject : collection) {
            boolean isCuShareData;
            int index = dynamicObject.getInt("bitindex");
            String strategy = dynamicObject.getString("ctrlstrategy");
            boolean isAudit = isIgnoreStatus || BillStatus.C.name().equals(dynamicObject.getString(billStatusKey));
            Long createOrgId = this.getLongDataFromDynamicObject(dynamicObject.get("createorg"));
            boolean globalShare = "5".equals(strategy);
            if (globalShare) {
                if (isIgnoreStatus) {
                    globalIndexes.add(index);
                    continue;
                }
                if (!currOrgIds.contains(createOrgId) && !isAudit) continue;
                globalIndexes.add(index);
                continue;
            }
            if (isTreeType || !"6".equals(strategy)) {
                fuzzQueryBitIndexes.add(index);
                continue;
            }
            if (isIgnoreStatus && supper.contains(createOrgId)) {
                chShareIndexes.add(index);
                continue;
            }
            if (isIgnoreStatus || !(isCuShareData = currOrgIds.contains(createOrgId) || isAudit && supper.contains(createOrgId))) continue;
            chShareIndexes.add(index);
        }
        fuzzQueryBitIndexes.retainAll(BaseDataUseRelQueryEngine.getAllUseBitByOrgIds(orgIds, (String)this.entity));
        fuzzQueryBitIndexes.addAll(chShareIndexes);
        if (isRemoveDup && !fuzzQueryBitIndexes.isEmpty()) {
            int[] indexes = this.removeDuplicateData(this.covertIntegerList2IntArr(fuzzQueryBitIndexes));
            fuzzQueryBitIndexes = Arrays.stream(indexes).boxed().collect(Collectors.toSet());
        }
        fuzzQueryBitIndexes.addAll(globalIndexes);
        return new QFilter("bitindex", "in", fuzzQueryBitIndexes);
    }
}

