/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IAssistantDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssistantDataServiceImpl
implements IAssistantDataService {
    private static Log LOGGER = LogFactory.getLog(AssistantDataServiceImpl.class);
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private static final String PROP_GROUP = "group";
    private static final String PROP_ORG_ID = "createorg.id";
    private static final String DEFAULT_MAIN_VIEW_ID = "16";

    public QFilter getAssistantDataFilter(Long typeId, Long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)typeId)};
        DynamicObject group = QueryServiceHelper.queryOne((String)ENTITY_ASSISTANT_GROUP, (String)"ctrlview.number,ctrlstrategy,createorg", (QFilter[])filters);
        if (group == null) {
            return new QFilter("1", "=", (Object)0);
        }
        QFilter filter = new QFilter(PROP_GROUP, "=", (Object)typeId);
        String viewNumber = group.getString("ctrlview.number");
        long createOrgId = group.getLong("createorg");
        if (orgId != createOrgId && !this.isGroupVisibleToOrg(orgId, createOrgId, viewNumber)) {
            return new QFilter("1", "=", (Object)0);
        }
        String ctrlStrategy = group.getString("ctrlstrategy");
        if ("5".equals(ctrlStrategy)) {
            return filter;
        }
        if ("7".equals(ctrlStrategy)) {
            return new QFilter(PROP_ORG_ID, "=", (Object)orgId).and(filter);
        }
        List superiorIds = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSuperiorOrgs(viewNumber, orgId.longValue());
        superiorIds.add(orgId);
        return new QFilter(PROP_ORG_ID, "in", (Object)superiorIds).and(filter);
    }

    public QFilter getAssistantDataFilter(Long typeId, List<Long> orgIds) {
        if (!CollectionUtils.isEmpty(orgIds) && orgIds.size() == 1) {
            return this.getAssistantDataFilter(typeId, orgIds.get(0));
        }
        String strategy = this.getAssistantDataCtrlstrategy(typeId);
        String viewNumber = this.getAssistantDataCtrlView(typeId);
        Set<Long> visibleOrgIds = this.getVisibleOrgIds(typeId, viewNumber);
        QFilter filter = new QFilter(PROP_GROUP, "=", (Object)typeId);
        if ("7".equals(strategy)) {
            visibleOrgIds.retainAll(new HashSet<Long>(orgIds));
            return new QFilter(PROP_ORG_ID, "in", visibleOrgIds).and(filter);
        }
        if ("5".equals(strategy)) {
            HashSet<Long> copy = new HashSet<Long>(visibleOrgIds);
            copy.retainAll(new HashSet<Long>(orgIds));
            if (copy.isEmpty()) {
                return new QFilter("1", "=", (Object)0);
            }
            return new QFilter(PROP_ORG_ID, "in", visibleOrgIds).and(filter);
        }
        Map superiorIds = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSuperiorOrgs(viewNumber, orgIds);
        HashSet<Long> allOrgIds = new HashSet<Long>(orgIds);
        if (!CollectionUtils.isEmpty((Map)superiorIds)) {
            superiorIds.values().forEach(allOrgIds::addAll);
        }
        visibleOrgIds.retainAll(allOrgIds);
        return new QFilter(PROP_ORG_ID, "in", visibleOrgIds).and(filter);
    }

    public String getAssistantDataCtrlstrategy(Long typeId) {
        String sql = "select fctrlstrategy from T_BAS_ASSISTANTDATA where fid  = ?";
        try (DataSet ds = DB.queryDataSet((String)AssistantDataServiceImpl.class.getName(), (DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{typeId});){
            for (Row row : ds) {
                String strategy = row.getString("fctrlstrategy");
                if (!StringUtils.isNotEmpty((CharSequence)strategy)) continue;
                String string = strategy;
                return string;
            }
        }
        return "6";
    }

    public String getAssistantDataCtrlView(Long typeId) {
        String sql = "select a.fnumber from t_bas_assistantdata t ,t_org_viewschema a where t.fctrlviewid = a.fid and t.fid = ? ";
        try (DataSet ds = DB.queryDataSet((String)AssistantDataServiceImpl.class.getName(), (DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{typeId});){
            for (Row row : ds) {
                String viewNumber = row.getString("fnumber");
                if (!StringUtils.isNotEmpty((CharSequence)viewNumber)) continue;
                String string = viewNumber;
                return string;
            }
        }
        return DEFAULT_MAIN_VIEW_ID;
    }

    private Set<Long> getVisibleOrgIds(Long groupId, String viewNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)groupId)};
        DynamicObject group = QueryServiceHelper.queryOne((String)ENTITY_ASSISTANT_GROUP, (String)PROP_ORG_ID, (QFilter[])filters);
        if (Objects.nonNull(group)) {
            long createOrgId = group.getLong(PROP_ORG_ID);
            ArrayList<Long> orgList = new ArrayList<Long>(Collections.singletonList(createOrgId));
            return new HashSet<Long>(OrgUnitServiceHelper.getAllSubordinateOrgs((String)viewNumber, orgList, (boolean)true));
        }
        return new HashSet<Long>(0);
    }

    private boolean isGroupVisibleToOrg(Long orgId, Long groupOrgId, String viewNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", (Object)new Long[]{orgId, groupOrgId}), new QFilter("view.number", "=", (Object)viewNumber)};
        DynamicObjectCollection orgStructures = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,longnumber", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)orgStructures) || orgStructures.size() != 2) {
            return false;
        }
        Map<Long, String> orgIdLongNumberMap = orgStructures.stream().collect(Collectors.toMap(org -> org.getLong("org"), org -> org.getString("longnumber")));
        String supOrgLongNumber = orgIdLongNumberMap.get(groupOrgId);
        String subOrgLongNumber = orgIdLongNumberMap.get(orgId);
        if (StringUtils.isEmpty((CharSequence)supOrgLongNumber) || StringUtils.isEmpty((CharSequence)subOrgLongNumber)) {
            LOGGER.error("\u7c7b\u522b\u7684\u521b\u5efa\u7ec4\u7ec7\u957f\u7f16\u7801\u6216\u5f53\u524d\u7ec4\u7ec7\u7684\u957f\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u7ec4\u7ec7\u6570\u636e\u6709\u5f02\u5e38...");
            return false;
        }
        String prefix = supOrgLongNumber + OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        return subOrgLongNumber.startsWith(prefix);
    }
}

