/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BaseDataQueryService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataQueryService.class);
    private static final String SYSTEM_TYPE = "bos-mservice-bd";
    private static final int MAX_DATA_SIZE = 5000;

    AssignQueryResponse assignQueryByData(List<Long> dataIds, String entity, Long orgId, String appId) {
        AssignQueryResponse response = new AssignQueryResponse();
        QueryContext context = new QueryContext(dataIds, entity, orgId, appId);
        try {
            if (!this.validate(context, response)) {
                response.setSuccess(false);
                return response;
            }
            if (BaseDataCommonService.isNewModel((String)entity)) {
                Map assignMap = response.getData();
                AssignQueryService service = new AssignQueryService(entity);
                if (!context.freeDataSet.isEmpty()) {
                    assignMap.putAll(service.assignQueryByData(new ArrayList(context.freeDataSet), orgId, "2"));
                }
                if (!context.stepDataSet.isEmpty()) {
                    assignMap.putAll(service.assignQueryByData(new ArrayList(context.stepDataSet), orgId, "1"));
                }
                return response;
            }
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
            HashSet cuOrgIds = new HashSet(16);
            if (null != ctrlView && !context.stepDataSet.isEmpty()) {
                AssignQueryService service = new AssignQueryService(entity);
                cuOrgIds.addAll(service.getAllCuSubordinateOrgIds((Long)ctrlView.getPkValue(), orgId));
            }
            dataIds = new ArrayList<Long>(context.freeDataSet);
            dataIds.addAll(context.stepDataSet);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fdataid,fuseorgid from ", new Object[0]).append(dt.getAlias() + "usereg", new Object[0]).append(" where fisassign = '1' and", new Object[0]).appendIn("fdataid", dataIds.toArray());
            Map assignMap = (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
                HashMap<Long, List> result = new HashMap<Long, List>(16);
                while (rs.next()) {
                    Long useOrgId = rs.getLong("fuseorgid");
                    Long dataId = rs.getLong("fdataid");
                    if (context.freeDataSet.contains(dataId)) {
                        result.computeIfAbsent(dataId, k -> new ArrayList(10)).add(useOrgId);
                        continue;
                    }
                    if (!context.stepDataSet.contains(dataId) || !cuOrgIds.contains(useOrgId)) continue;
                    result.computeIfAbsent(dataId, k -> new ArrayList(10)).add(useOrgId);
                }
                return result;
            });
            response.getData().putAll(assignMap);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u67e5\u8be2\uff08\u6309\u6570\u636e\uff09\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a%1$s", (String)"BaseDataQueryService_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage());
            response.setSuccess(false);
            response.setErrorMsg(msg);
            LOGGER.error(msg, (Throwable)e);
        }
        return response;
    }

    private boolean validate(QueryContext context, AssignQueryResponse response) {
        boolean enableData;
        if (!this.paramValidate(context, response)) {
            return false;
        }
        if (!this.assignQueryPermValidate(context, response)) {
            return false;
        }
        if (context.dataIds.size() > 5000) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u5355\u6b21\u67e5\u8be2\u7684\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc75000\u6761\u3002", (String)"BaseDataQueryService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        boolean isNewModel = BaseDataCommonService.isNewModel((String)context.entity);
        boolean bl = enableData = isNewModel ? this.ableDataValidateOnNewModel(context) : this.ableDataValidate(context);
        if (!enableData) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6570\u636e\u4e2d\uff0c\u7ec4\u7ec7\u65e0\u53ef\u7528\u7684\u5206\u914d\u578b\u6570\u636e\u3002", (String)"BaseDataQueryService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean paramValidate(QueryContext context, AssignQueryResponse response) {
        if (StringUtils.isBlank((CharSequence)context.entity)) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u53c2\u6570entity\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u3002", (String)"BaseDataQueryService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((Object)context.orgId)) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u53c2\u6570orgId\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u3002", (String)"BaseDataQueryService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)context.appId)) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u53c2\u6570appId\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u3002", (String)"BaseDataQueryService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)context.dataIds)) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u53c2\u6570dataIds\u7684\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u3002", (String)"BaseDataQueryService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (!BaseDataServiceHelper.checkBaseDataCtrl((String)context.entity).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u5b9e\u4f53\u4e3a\u3010%1$s\u3011\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u662f\u53d7\u63a7\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5entity\u53c2\u6570\u503c\u3002", (String)"BaseDataQueryService_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            response.setErrorMsg(String.format(msg, context.entity));
            return false;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)context.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select top 1 forgid from t_org_structure where fviewid = ", new Object[0]).append(ctrlView.getPkValue().toString(), new Object[0]);
        builder.append(" and fisctrlunit = '1' and forgid =", new Object[0]).append(context.orgId.toString(), new Object[0]);
        if (!((Boolean)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, ResultSet::next)).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0d\u662fCU\u7ec4\u7ec7\uff0c\u4e0d\u53ef\u4ee5\u6267\u884c\u67e5\u8be2\u3002", (String)"BaseDataQueryService_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            response.setErrorMsg(String.format(msg, context.orgId));
            return false;
        }
        return true;
    }

    private boolean assignQueryPermValidate(QueryContext context, AssignQueryResponse response) {
        boolean hasAssignPerm;
        long userId = RequestContext.get().getCurrUserId();
        boolean bl = hasAssignPerm = 1 == PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)context.orgId, (String)context.appId, (String)context.entity, (String)"80513208000000ac");
        if (!hasAssignPerm) {
            String caption = FormMetadataCache.getFormConfig((String)context.entity).getCaption().getLocaleValue();
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c\u5206\u914d\u67e5\u8be2\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"BaseDataQueryService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            response.setErrorMsg(String.format(msg, caption));
            return false;
        }
        return this.checkDataRule(context, response);
    }

    private boolean checkDataRule(QueryContext context, AssignQueryResponse response) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter dataRuleFilter = service.getDataRuleWithoutDim(currUserId, context.appId, context.entity, "47150e89000000ac", Collections.singletonList(context.orgId));
        if (null == dataRuleFilter) {
            return true;
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)context.entity, (String)"id", (QFilter[])new QFilter[]{dataRuleFilter});
        Set idsMatchDataRule = objs.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        if (idsMatchDataRule.isEmpty()) {
            response.setErrorMsg(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6240\u9009\u6570\u636e\u5bf9\u5e94\u7684\u201c\u5206\u914d\u67e5\u8be2\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataQueryService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        HashMap<Long, String> msgInfo = new HashMap<Long, String>(context.dataIds.size());
        String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5206\u914d\u67e5\u8be2\u201d\u64cd\u4f5c\u6240\u9700\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseDataQueryService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (Long dataId : context.dataIds) {
            if (idsMatchDataRule.contains(dataId)) continue;
            msgInfo.put(dataId, msg);
        }
        if (!msgInfo.isEmpty()) {
            response.setErrorMsgInfo(msgInfo);
            return false;
        }
        return true;
    }

    private boolean ableDataValidateOnNewModel(QueryContext context) {
        QFilter filter = new QFilter("ctrlstrategy", "in", new ArrayList<String>(Arrays.asList("1", "2")));
        filter.and(new QFilter("id", "in", (Object)context.dataIds));
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)context.entity);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)context.entity, (Long)context.orgId, (QFilter)filter, (String)("id, ctrlstrategy, createorg, " + masterIdPropName));
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return false;
        }
        for (DynamicObject data : collection) {
            long dataId = data.getLong("id");
            String strategy = data.getString("ctrlstrategy");
            if ("1".equals(strategy)) {
                context.stepDataSet.add(dataId);
                continue;
            }
            Long masterId = data.getLong(masterIdPropName);
            Long createOrgId = data.getLong("createorg");
            if (!context.orgId.equals(createOrgId) || !masterId.equals(dataId)) continue;
            context.freeDataSet.add(dataId);
        }
        return CollectionUtils.isNotEmpty((Collection)context.freeDataSet) || CollectionUtils.isNotEmpty((Collection)context.stepDataSet);
    }

    private boolean ableDataValidate(QueryContext context) {
        ArrayList useAbleIds = new ArrayList(context.dataIds.size());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)context.entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fdataid from ", new Object[0]).append(dt.getAlias() + "_u", new Object[0]).append("where", new Object[0]).appendIn("fdataid", context.dataIds.toArray()).append("and fuseorgid = ?", new Object[]{context.orgId});
        try (DataSet rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder);){
            rows.forEach(r -> useAbleIds.add(r.getLong("fdataid")));
        }
        if (useAbleIds.isEmpty()) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", useAbleIds), new QFilter("ctrlstrategy", "in", new ArrayList<String>(Arrays.asList("1", "2")))};
        String mIdProp = BaseDataServiceHelper.getMasterIdPropName((String)context.entity);
        String selectFields = "id, ctrlstrategy, createorg, " + mIdProp;
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)context.entity, (String)selectFields, (QFilter[])filters, (String)"", (int)-1);){
            for (Row row : rows) {
                Long dataId = row.getLong("id");
                if ("1".equals(row.getString("ctrlstrategy"))) {
                    context.stepDataSet.add(dataId);
                    continue;
                }
                if (!dataId.equals(row.getLong(mIdProp)) || !context.orgId.equals(row.getLong("createorg"))) continue;
                context.freeDataSet.add(dataId);
            }
        }
        return CollectionUtils.isNotEmpty((Collection)context.freeDataSet) || CollectionUtils.isNotEmpty((Collection)context.stepDataSet);
    }

    public List<Long> getBaseDataIdsFromDb(String entity, Long currentOrgId, String appId) {
        long currUserId = RequestContext.get().getCurrUserId();
        PermissionService service = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter dataRuleFilter = service.getDataRuleWithoutDim(currUserId, appId, entity, "47150e89000000ac", Collections.singletonList(currentOrgId));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("ctrlstrategy", "in", Arrays.asList("1", "2")));
        if (null != dataRuleFilter) {
            filters.add(dataRuleFilter);
        }
        if (BaseDataCommonService.isNewModel((String)entity)) {
            List dataIds = new AssignQueryService(entity).getAssignTypeDataList(entity, currentOrgId);
            if (dataIds.isEmpty()) {
                return dataIds;
            }
            filters.add(new QFilter("id", "in", (Object)dataIds));
        } else {
            filters.add(BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)currentOrgId));
        }
        String masterIdPro = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entity, (String)("id, ctrlstrategy, createorg, " + masterIdPro), (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> dataIds = new ArrayList<Long>(collection.size());
        for (DynamicObject data : collection) {
            Long dataId = data.getLong("id");
            if ("1".equals(data.getString("ctrlstrategy"))) {
                dataIds.add(dataId);
                continue;
            }
            if (!dataId.equals(data.getLong(masterIdPro)) || !currentOrgId.equals(data.getLong("createorg"))) continue;
            dataIds.add(dataId);
        }
        return dataIds;
    }

    private static class QueryContext {
        private Set<Long> freeDataSet = new HashSet<Long>(16);
        private Set<Long> stepDataSet = new HashSet<Long>(16);
        private List<Long> dataIds;
        private String entity;
        private Long orgId;
        private String appId;

        private QueryContext(List<Long> dataIds, String entity, Long orgId, String appId) {
            this.dataIds = dataIds;
            this.entity = entity;
            this.orgId = orgId;
            this.appId = appId;
        }
    }
}

