/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.bdctrl.BaseDataImportValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BaseDataCreateOrgPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BaseDataCreateOrgPlugin.class);
    private static final String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String PRO_CREATEORG = "createOrg";
    private static final String PRO_USEORG = "useOrg";
    private static final String PRO_ORG = "org";
    private static final String PRO_ORG_ID = "org.id";
    private static final String ENTITY_BOS_ORG = "bos_org";
    private static final String NEW_FLAG = "newFlag";
    private static final String PRO_SRC_ORG = "_src_create_org_";
    private static final String PROP_CREATE_ORG = "createorg";
    private Map<Object, Long> numberOrgMap = null;
    private Set<Long> createOrgs = null;
    private Map<Long, Long> dataCreateOrgMap = null;
    private Map<String, String> ctrlStrategyMap = null;
    private Set<Long> disableOrgIds = null;
    private Set<Long> existDataIds = null;

    public void afterCreateNewData(EventObject e) {
        String useorg;
        String createOrg;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
            String newOrgValue = this.getPageCache().get("newOrgValue");
            if (StringUtils.isEmpty((CharSequence)newOrgValue)) {
                IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
                useorg = createOrg = pageCache.get(PRO_CREATEORG);
            } else {
                useorg = createOrg = newOrgValue;
                this.getPageCache().put(NEW_FLAG, null);
            }
        } else {
            useorg = this.getModel().getValue(PROP_CREATE_ORG) != null && this.getModel().getValue(PROP_CREATE_ORG) instanceof DynamicObject ? (createOrg = ((DynamicObject)this.getModel().getValue(PROP_CREATE_ORG)).getPkValue().toString()) : (createOrg = Long.toString(RequestContext.getOrCreate().getOrgId()));
        }
        if (useorg != null) {
            this.getModel().setValue(PRO_USEORG, (Object)useorg);
        }
        if (createOrg != null && createOrg.length() > 0) {
            this.afterCreateNewData(createOrg);
        }
    }

    private void afterCreateNewData(String createOrg) {
        String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
        long createOrgId = Long.parseLong(createOrg);
        if (this.getPageCache().get(NEW_FLAG) == null) {
            this.getPageCache().put(NEW_FLAG, "true");
            this.getModel().setValue(PRO_CREATEORG, (Object)createOrgId);
            this.setSrcCreateOrg(createOrgId);
        }
        this.getModel().setValue(PRO_ORG, (Object)createOrgId);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{PRO_ORG});
        String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityName, (String)String.valueOf(createOrgId));
        if (StringUtils.isNotBlank((CharSequence)ctrlStrategy)) {
            this.setCtrlStrategy(ctrlStrategy);
        }
    }

    private void setSrcCreateOrg(Object orgId) {
        try {
            if (null != this.getModel().getProperty("srccreateorg")) {
                this.getModel().setValue("srccreateorg", orgId);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u539f\u521b\u5efa\u7ec4\u7ec7\u5c5e\u6027\u5f02\u5e38...", (Throwable)e);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        String entity = this.getView().getEntityId();
        String appId = null;
        String appNumber = null;
        if ("api".equalsIgnoreCase(RequestContext.get().getClient())) {
            appNumber = null == e.getOption().get("appid") ? null : e.getOption().get("appid").toString();
            logger.info("initImportData from api ,appNumber:" + appNumber);
        } else {
            appNumber = this.getView().getFormShowParameter().getAppId();
        }
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
            try {
                appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appId = met.getAppId();
            }
        }
        if (null == this.createOrgs) {
            this.createOrgs = new HashSet<Long>(BaseDataServiceHelper.getCreateOrgList((String)entity, (String)appId));
        }
        this.numberOrgMap = new HashMap<Object, Long>(16);
        this.initImportCreateOrgInfo(e);
        this.initOriginalData(e, entity);
        this.initExistDataIds(e);
        this.ctrlStrategyMap = BaseDataServiceHelper.getBdCtrlStrgyBatch((String)entity, new ArrayList<Long>(this.numberOrgMap.values()));
        this.disableOrgIds = this.getDisableOrgIds();
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map dataMap = e.getSourceData();
        Object createOrg = dataMap.get(PROP_CREATE_ORG);
        if (createOrg == null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"BaseDataCreateOrgPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        Map orgMap = (Map)createOrg;
        String orgNumber = (String)orgMap.get("number");
        Long createOrgId = this.numberOrgMap.get(orgNumber);
        if (StringUtils.isBlank((CharSequence)orgNumber) || null == createOrgId) {
            e.setCancel(true);
            return;
        }
        Object importType = e.getOption().get("importtype");
        String entity = this.getView().getEntityId();
        boolean isNewData = true;
        Object dataId = dataMap.get("id");
        if (null != dataId) {
            boolean containModifyOp = "overridenew".equals(importType) || "override".equals(importType);
            boolean exists = this.existDataIds.contains(dataId = Long.valueOf(dataId.toString()));
            if (exists && containModifyOp) {
                isNewData = false;
            } else if (exists && StringUtils.isBlank(importType)) {
                isNewData = false;
                QFilter filter = new QFilter("id", "=", dataId);
                DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)entity, (Long)createOrgId, (QFilter)filter, (String)"id");
                if (CollectionUtils.isEmpty((Collection)collection)) {
                    e.setCancel(true);
                    String number = Objects.toString(dataMap.get("number"), "");
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0%1$s\u6570\u636e\u7684\u4f7f\u7528\u6743\uff0c\u4e0d\u80fd\u66f4\u65b0\u5185\u7801\u4e3a'%2$s'\u7684\u6570\u636e\u3002", (String)"BaseDataCreateOrgPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), number, dataId));
                    return;
                }
            }
        }
        if (isNewData) {
            if (!CollectionUtils.isEmpty(this.disableOrgIds) && this.disableOrgIds.contains(createOrgId)) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e3a\u7981\u7528/\u5c01\u5b58\u72b6\u6001\u3002", (String)"BaseDataCreateOrgPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), orgNumber));
                return;
            }
            if (!this.createOrgs.contains(createOrgId)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa\u7684\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u529f\u80fd\u6743\u9650\u6216\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"BaseDataCreateOrgPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            new BaseDataImportValidator(e).importNewDataValidate(entity, createOrgId);
            dataMap.put(PRO_SRC_ORG, Boolean.TRUE);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Long org;
        Object dataId;
        super.afterImportData(e);
        Map dataMap = e.getSourceData();
        Map orgMap = (Map)dataMap.get(PROP_CREATE_ORG);
        if (null == orgMap) {
            return;
        }
        String orgNumber = (String)orgMap.get("number");
        Long createOrg = this.numberOrgMap.get(orgNumber);
        Long useOrg = createOrg;
        if (null != useOrg) {
            this.getModel().setValue(PRO_USEORG, (Object)useOrg);
        }
        if ((dataId = dataMap.get("id")) != null && (org = this.dataCreateOrgMap.get(dataId)) != null) {
            createOrg = org;
        }
        if (createOrg != null) {
            this.getModel().setValue(PRO_CREATEORG, (Object)createOrg);
            if (dataMap.containsKey(PRO_SRC_ORG)) {
                this.setSrcCreateOrg(createOrg);
            }
            this.getModel().setValue(PRO_ORG, (Object)createOrg);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{PRO_ORG});
            Object strategy = dataMap.get("ctrlstrategy");
            if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase() || StringUtils.isNotBlank(strategy)) {
                return;
            }
            String useOrgCtrlStrategy = this.ctrlStrategyMap.get(String.valueOf(useOrg));
            if (StringUtils.isNotBlank((CharSequence)useOrgCtrlStrategy)) {
                this.setCtrlStrategy(useOrgCtrlStrategy);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        String ctrlStrgy;
        String useOrg;
        Object value = this.getModel().getValue(PROP_CREATE_ORG);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isNotBlank((CharSequence)parentPageId)) {
            IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
            useOrg = pageCache.get(PRO_CREATEORG);
        } else {
            useOrg = value instanceof DynamicObject ? ((DynamicObject)value).getPkValue().toString() : Long.toString(RequestContext.getOrCreate().getOrgId());
        }
        String entityName = this.getModel().getDataEntity().getDataEntityType().toString();
        if (useOrg != null) {
            this.getModel().setValue(PRO_USEORG, (Object)useOrg);
            this.getModel().setValue(PRO_CREATEORG, (Object)useOrg);
            this.getModel().setValue(PRO_ORG, (Object)useOrg);
            this.setSrcCreateOrg(useOrg);
        }
        if ((ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityName, (String)useOrg)) != null && ctrlStrgy.length() > 0) {
            this.setCtrlStrategy(ctrlStrgy);
        }
    }

    private void setCtrlStrategy(String ctrlStrategy) {
        String[] ctrlStrategyArr = ctrlStrategy.split(",");
        if (ctrlStrategyArr.length <= 1) {
            this.getModel().setValue("ctrlstrategy", (Object)ctrlStrategy);
            return;
        }
        for (String ctr : ctrlStrategyArr) {
            if (!StringUtils.isNotEmpty((CharSequence)ctr)) continue;
            this.getModel().setValue("ctrlstrategy", (Object)ctr);
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object createOrgId = this.getView().getFormShowParameter().getCustomParam(PROP_CREATE_ORG);
        Optional.ofNullable(createOrgId).ifPresent(orgId -> this.getModel().setValue(PROP_CREATE_ORG, (Object)Long.valueOf(orgId.toString())));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isBlank((CharSequence)parentPageId)) {
            return;
        }
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(parentPageId);
        String useOrg = pageCache.get(PRO_CREATEORG);
        if (StringUtils.isNotEmpty((CharSequence)useOrg)) {
            this.getModel().setValue(PRO_USEORG, (Object)Long.valueOf(useOrg));
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        if (beforeDoOperationEventArgs.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
            String opKey = operate.getOption().getVariableValue("oriOperationKey", operate.getOperateKey());
            Map opMap = EntityMetadataCache.getDataEntityOperate((String)this.getModel().getDataEntityType().getName(), (String)opKey);
            String opType = (String)opMap.get("type");
            String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam("useorgId");
            if (null == useOrgID && null != this.getModel().getValue(PRO_USEORG)) {
                if (this.getModel().getValue(PRO_USEORG) instanceof Long) {
                    useOrgID = this.getModel().getValue(PRO_USEORG).toString();
                } else if (this.getModel().getValue(PRO_USEORG) instanceof DynamicObject) {
                    useOrgID = ((DynamicObject)this.getModel().getValue(PRO_USEORG)).getPkValue().toString();
                }
                if (null == useOrgID) {
                    DynamicObject createorg = (DynamicObject)this.getModel().getValue(PROP_CREATE_ORG);
                    String string = useOrgID = null != createorg ? createorg.getPkValue().toString() : null;
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"new")) {
                this.getPageCache().put(NEW_FLAG, null);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"unaudit")) {
                operate.getOption().setVariableValue(PRO_CREATEORG, useOrgID);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"enable")) {
                operate.getOption().setVariableValue(PRO_CREATEORG, useOrgID);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"disable")) {
                operate.getOption().setVariableValue(PRO_CREATEORG, useOrgID);
            } else if ("delete".equalsIgnoreCase(operate.getType())) {
                operate.getOption().setVariableValue(PRO_CREATEORG, useOrgID);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
            String opKey = operate.getOption().getVariableValue("oriOperationKey", operate.getOperateKey());
            Map opMap = EntityMetadataCache.getDataEntityOperate((String)this.getModel().getDataEntityType().getName(), (String)opKey);
            String opType = (String)opMap.get("type");
            if (StringUtils.equalsIgnoreCase((CharSequence)opType, (CharSequence)"saveandnew")) {
                this.getPageCache().put(NEW_FLAG, null);
            }
        }
    }

    private void initExistDataIds(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        List dataIds = sourceDataList.stream().filter(source -> StringUtils.isNotBlank(source.get("id"))).mapToLong(v -> Long.parseLong(v.get("id").toString())).boxed().collect(Collectors.toList());
        this.existDataIds = new HashSet<Long>(dataIds.size());
        if (dataIds.isEmpty()) {
            return;
        }
        String entity = this.getView().getEntityId();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), entity, "id", filters);){
            ds.forEach(r -> this.existDataIds.add(r.getLong("id")));
        }
    }

    private void initImportCreateOrgInfo(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        HashMap<String, List<ImportCreateOrg>> orgNameMap = new HashMap<String, List<ImportCreateOrg>>(16);
        HashMap<String, List<ImportCreateOrg>> orgNumberMap = new HashMap<String, List<ImportCreateOrg>>(16);
        HashMap<Long, List<ImportCreateOrg>> orgIdMap = new HashMap<Long, List<ImportCreateOrg>>(16);
        for (int i = 0; i < sourceDataList.size(); ++i) {
            Map fieldMap = (Map)sourceDataList.get(i);
            Object createOrg = fieldMap.get(PROP_CREATE_ORG);
            if (null == createOrg) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"BaseDataCreateOrgPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                continue;
            }
            ImportCreateOrg importOrg = new ImportCreateOrg(i, (Map)createOrg);
            if ("id".equals(importOrg.importProp)) {
                orgIdMap.computeIfAbsent(importOrg.id, k -> new ArrayList(16)).add(importOrg);
                continue;
            }
            if ("number".equals(importOrg.importProp)) {
                orgNumberMap.computeIfAbsent(importOrg.number, k -> new ArrayList(16)).add(importOrg);
                continue;
            }
            orgNameMap.computeIfAbsent(importOrg.name, k -> new ArrayList(16)).add(importOrg);
        }
        String selectFields = "id, name, number";
        this.initImportCreateOrgById(e, orgIdMap, selectFields);
        this.initImportCreateOrgByName(e, orgNameMap, selectFields);
        this.initImportCreateOrgByNumber(e, orgNumberMap, selectFields);
    }

    private void initImportCreateOrgById(InitImportDataEventArgs e, Map<Long, List<ImportCreateOrg>> orgIdMap, String selectFields) {
        if (orgIdMap.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", orgIdMap.keySet())};
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_BOS_ORG, (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            this.addCancelMessage(e, orgIdMap, ResManager.loadKDString((String)"ID\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            this.numberOrgMap.put(((DynamicObject)entry.getValue()).getString("number"), (Long)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : orgIdMap.entrySet()) {
            Long id = (Long)entry.getKey();
            List value = (List)entry.getValue();
            DynamicObject org = (DynamicObject)dataMap.get(id);
            if (null != org) {
                for (ImportCreateOrg importOrg : value) {
                    importOrg.setOrgProperty("name", org.getString("name"));
                    importOrg.setOrgProperty("number", org.getString("number"));
                }
                continue;
            }
            String msg = String.format(ResManager.loadKDString((String)"ID\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), id);
            for (ImportCreateOrg data : value) {
                e.addCancelMessage(Integer.valueOf(data.index), Integer.valueOf(0), Integer.valueOf(0), msg);
            }
        }
    }

    private void initImportCreateOrgByName(InitImportDataEventArgs e, Map<String, List<ImportCreateOrg>> orgNameMap, String selectFields) {
        String number;
        if (CollectionUtils.isEmpty(orgNameMap)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("name", "in", orgNameMap.keySet())};
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)ENTITY_BOS_ORG, (String)selectFields, (QFilter[])filters);
        if (dataArr == null || dataArr.length == 0) {
            this.addCancelMessage(e, orgNameMap, ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Set> nameNumMap = new HashMap<String, Set>(16);
        for (DynamicObject org : dataArr) {
            String name = org.getString("name");
            number = org.getString("number");
            nameNumMap.computeIfAbsent(name, k -> new HashSet(16)).add(number);
            this.numberOrgMap.put(number, org.getLong("id"));
        }
        for (Map.Entry entry : orgNameMap.entrySet()) {
            String name = (String)entry.getKey();
            List value = (List)entry.getValue();
            Set numbers = (Set)nameNumMap.get(name);
            if (numbers.size() == 1) {
                number = (String)numbers.iterator().next();
                Long orgId = this.numberOrgMap.get(number);
                for (ImportCreateOrg org : value) {
                    org.setOrgProperty("id", orgId);
                    org.setOrgProperty("number", number);
                }
                continue;
            }
            String msg = CollectionUtils.isEmpty((Collection)numbers) ? String.format(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), name) : String.format(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u4f7f\u7528\u7ec4\u7ec7\u7f16\u7801\u6267\u884c\u5bfc\u5165\u64cd\u4f5c\u3002", (String)"BaseDataCreateOrgPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
            for (ImportCreateOrg data : value) {
                e.addCancelMessage(Integer.valueOf(data.index), Integer.valueOf(0), Integer.valueOf(0), msg);
            }
        }
    }

    private void initImportCreateOrgByNumber(InitImportDataEventArgs e, Map<String, List<ImportCreateOrg>> orgNumberMap, String selectFields) {
        if (CollectionUtils.isEmpty(orgNumberMap)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", orgNumberMap.keySet())};
        DynamicObject[] dataArr = BusinessDataServiceHelper.load((String)ENTITY_BOS_ORG, (String)selectFields, (QFilter[])filters);
        if (dataArr == null || dataArr.length == 0) {
            this.addCancelMessage(e, orgNumberMap, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> numberNameMap = new HashMap<String, String>(dataArr.length);
        for (DynamicObject org : dataArr) {
            String number = org.getString("number");
            this.numberOrgMap.put(number, org.getLong("id"));
            numberNameMap.put(number, org.getString("name"));
        }
        for (Map.Entry entry : orgNumberMap.entrySet()) {
            String number = (String)entry.getKey();
            Long orgId = this.numberOrgMap.get(number);
            if (null == orgId) {
                String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), number);
                for (ImportCreateOrg data : (List)entry.getValue()) {
                    e.addCancelMessage(Integer.valueOf(data.index), Integer.valueOf(0), Integer.valueOf(0), msg);
                }
                continue;
            }
            String name = (String)numberNameMap.get(number);
            for (ImportCreateOrg org : (List)entry.getValue()) {
                org.setOrgProperty("id", orgId);
                org.setOrgProperty("name", name);
            }
        }
    }

    private void addCancelMessage(InitImportDataEventArgs e, Map<?, List<ImportCreateOrg>> orgMap, String msgTpl) {
        for (Map.Entry<?, List<ImportCreateOrg>> entry : orgMap.entrySet()) {
            String msg = String.format(msgTpl, entry.getKey());
            List<ImportCreateOrg> value = entry.getValue();
            for (ImportCreateOrg data : value) {
                e.addCancelMessage(Integer.valueOf(data.index), Integer.valueOf(0), Integer.valueOf(0), msg);
            }
        }
    }

    private void initOriginalData(InitImportDataEventArgs e, String entity) {
        HashSet<String> keys;
        Object importType;
        Map option = e.getOption();
        Set<String> uniqueKeys = this.getUniqueKeys(option, importType = option.get("importtype"));
        if (uniqueKeys.isEmpty()) {
            String defaultKey = BaseDataCommonService.isOtherMasterIdType((String)entity) ? "masterid" : "number";
            keys = new HashSet<String>(Collections.singletonList(defaultKey));
        } else {
            keys = new HashSet<String>(uniqueKeys);
        }
        List sourceDataList = e.getSourceDataList();
        ArrayList<ImportDataInfo> dataInfoList = new ArrayList<ImportDataInfo>(sourceDataList.size());
        for (int i = 0; i < sourceDataList.size(); ++i) {
            ImportDataInfo importDataInfo;
            Map dataMap = (Map)sourceDataList.get(i);
            Map org = (Map)dataMap.get(PROP_CREATE_ORG);
            if (null != org && null != org.get("id")) {
                Long orgId = Long.valueOf(org.get("id").toString());
                importDataInfo = new ImportDataInfo(i, orgId, dataMap, !"new".equals(importType));
            } else {
                importDataInfo = new ImportDataInfo(i, null, dataMap, false);
            }
            dataInfoList.add(importDataInfo);
        }
        this.initOriginalData(entity, keys, dataInfoList, e);
        if (StringUtils.isNotBlank(importType) && !"new".equals(importType) && !dataInfoList.isEmpty()) {
            this.fillUpdateDataIds(dataInfoList, entity, uniqueKeys, e);
        }
    }

    private Set<String> getUniqueKeys(Map<String, Object> option, Object importType) {
        Object keyFields = option.get("KeyFields");
        if (StringUtils.isBlank((Object)keyFields) && "api".equalsIgnoreCase(RequestContext.get().getClient())) {
            keyFields = "id";
        }
        HashSet<String> uniqueKeys = new HashSet<String>(16);
        if (null != keyFields) {
            String[] keyArr = StringUtils.split((String)keyFields.toString(), (String)String.valueOf(','));
            Set collect = Arrays.stream(keyArr).collect(Collectors.toSet());
            collect.removeIf(StringUtils::isBlank);
            if (!"new".equals(importType)) {
                uniqueKeys.addAll(collect);
            }
        }
        return uniqueKeys;
    }

    private void initOriginalData(String entity, Set<String> keys, List<ImportDataInfo> dataInfoList, InitImportDataEventArgs event) {
        BillEntityType dt = (BillEntityType)this.getView().getModel().getDataEntityType();
        Map<String, Set<Object>> filterValueMap = this.initImportField(keys, dataInfoList, dt, event);
        QFilter filter = null;
        for (Map.Entry<String, Set<Object>> entry : filterValueMap.entrySet()) {
            Set<Object> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            if (null == filter) {
                filter = new QFilter(entry.getKey(), "in", value);
                continue;
            }
            filter = filter.or(new QFilter(entry.getKey(), "in", value));
        }
        this.dataCreateOrgMap = new HashMap<Long, Long>(16);
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), entity, "id,createorg", new QFilter[]{filter});){
            for (Row row : ds) {
                this.dataCreateOrgMap.put(row.getLong("id"), row.getLong(PROP_CREATE_ORG));
            }
        }
    }

    private void fillUpdateDataIds(List<ImportDataInfo> dataInfoList, String entity, Set<String> uniqueKeys, InitImportDataEventArgs e) {
        BillEntityType dt = (BillEntityType)this.getView().getModel().getDataEntityType();
        HashMap<Long, List> updateDataMap = new HashMap<Long, List>(16);
        for (ImportDataInfo importDataInfo : dataInfoList) {
            if (!importDataInfo.needValidateUseRight) continue;
            updateDataMap.computeIfAbsent(importDataInfo.orgId, k -> new ArrayList(16)).add(importDataInfo);
        }
        HashSet<String> timeTypeFields = new HashSet<String>(uniqueKeys.size());
        for (String uniqueKey : uniqueKeys) {
            DynamicProperty field = dt.getProperty(uniqueKey);
            if (!(field instanceof TimeProp) && !(field instanceof DateTimeProp)) continue;
            timeTypeFields.add(uniqueKey);
        }
        Object v = e.getOption().get("importtype");
        for (Map.Entry entry : updateDataMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            List value = (List)entry.getValue();
            HashSet<String> fields = new HashSet<String>(Collections.singleton("id"));
            QFilter filter = this.getUseRightFilter(uniqueKeys, dt, value, fields);
            String selectFields = String.join((CharSequence)String.valueOf(','), fields);
            DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)entity, (Long)orgId, (QFilter)filter, (String)selectFields);
            for (ImportDataInfo dataInfo : value) {
                this.eachFillDataId(v, dataInfo, e, collection, timeTypeFields);
            }
        }
    }

    private void eachFillDataId(Object importType, ImportDataInfo dataInfo, InitImportDataEventArgs e, DynamicObjectCollection collection, Set<String> timeTypeFields) {
        boolean invalidData;
        Object[] importValueArr = new Object[dataInfo.uniqueKeys.size()];
        for (int i = 0; i < dataInfo.uniqueKeys.size(); ++i) {
            importValueArr[i] = dataInfo.fieldValueMap.get(dataInfo.uniqueKeys.get(i));
        }
        for (DynamicObject data : collection) {
            Object[] dbValueArr = new Object[importValueArr.length];
            for (int i = 0; i < dataInfo.uniqueKeys.size(); ++i) {
                dbValueArr[i] = data.get((String)dataInfo.uniqueKeys.get(i));
            }
            if (!this.equals(importValueArr, dbValueArr)) continue;
            Long dataId = data.getLong("id");
            dataInfo.wasValidate = true;
            if (dataInfo.uniqueKeysContainsId) {
                dataInfo.id = dataId;
                return;
            }
            if (null == dataInfo.id) {
                dataInfo.setId(dataId);
                continue;
            }
            dataInfo.removeId();
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5b58\u5728\u591a\u6761\u6570\u636e%2$s\u7684\u8bb0\u5f55\u4fe1\u606f\u3002", (String)"BaseDataCreateOrgPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.getImportOrgTips(dataInfo), this.packErrorMsg(dataInfo, timeTypeFields));
            e.addCancelMessage(Integer.valueOf(dataInfo.index), Integer.valueOf(0), Integer.valueOf(0), msg);
            return;
        }
        boolean bl = invalidData = dataInfo.id == null || dataInfo.uniqueKeysContainsId && !dataInfo.wasValidate;
        if ("override".equals(importType) && invalidData) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u65e0\u6570\u636e%2$s\u7684\u4f7f\u7528\u6743\uff0c\u6216\u8005\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"BaseDataCreateOrgPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.getImportOrgTips(dataInfo), this.packErrorMsg(dataInfo, timeTypeFields));
            e.addCancelMessage(Integer.valueOf(dataInfo.index), Integer.valueOf(0), Integer.valueOf(0), msg);
        }
    }

    private String getImportOrgTips(ImportDataInfo dataInfo) {
        Object createOrg = dataInfo.data.get(PROP_CREATE_ORG);
        if (null == createOrg) {
            return "";
        }
        Map orgMap = (Map)createOrg;
        String importProp = (String)orgMap.get("importprop");
        return (String)orgMap.get(importProp);
    }

    private String packErrorMsg(ImportDataInfo dataInfo, Set<String> timeTypeFields) {
        StringJoiner joiner = new StringJoiner("\uff0c");
        for (String uniqueKey : dataInfo.uniqueKeys) {
            if (timeTypeFields.contains(uniqueKey)) {
                joiner.add(uniqueKey + "=" + dataInfo.data.get(uniqueKey));
                continue;
            }
            joiner.add(uniqueKey + "=" + dataInfo.fieldValueMap.get(uniqueKey));
        }
        return joiner.toString();
    }

    private QFilter getUseRightFilter(Set<String> uniqueKeys, BillEntityType dt, Collection<ImportDataInfo> collection, Set<String> selectFields) {
        HashMap<String, Set> filterValueMap = new HashMap<String, Set>(16);
        for (ImportDataInfo dataInfo : collection) {
            for (String key : uniqueKeys) {
                if ("id".equals(key)) {
                    dataInfo.uniqueKeysContainsId = true;
                }
                if (PROP_CREATE_ORG.equals(key)) {
                    selectFields.add(PROP_CREATE_ORG);
                    Object orgId = dataInfo.fieldValueMap.get(PROP_CREATE_ORG);
                    filterValueMap.computeIfAbsent(PROP_CREATE_ORG, k -> new HashSet(16)).add(orgId);
                    dataInfo.uniqueKeys.add(PROP_CREATE_ORG);
                    continue;
                }
                DynamicProperty fieldProperty = dt.getProperty(key);
                if (fieldProperty instanceof BasedataProp) {
                    Map data = (Map)dataInfo.data.get(key);
                    if (null == data) continue;
                    String importType = (String)data.get("importprop");
                    if (StringUtils.isBlank((CharSequence)importType)) {
                        importType = data.containsKey("number") ? "number" : "name";
                    }
                    String field = key + "." + importType;
                    selectFields.add(field);
                    filterValueMap.computeIfAbsent(field, k -> new HashSet(16));
                    dataInfo.uniqueKeys.add(field);
                    Object value = dataInfo.fieldValueMap.get(field);
                    if (null == value) continue;
                    ((Set)filterValueMap.get(field)).add(value);
                    continue;
                }
                dataInfo.uniqueKeys.add(key);
                selectFields.add(key);
                Object value = dataInfo.fieldValueMap.get(key);
                filterValueMap.computeIfAbsent(key, k -> new HashSet(16));
                if (null == value) continue;
                ((Set)filterValueMap.get(key)).add(value);
            }
        }
        QFilter filter = null;
        for (Map.Entry entry : filterValueMap.entrySet()) {
            if (null == filter) {
                filter = new QFilter((String)entry.getKey(), "in", entry.getValue());
                continue;
            }
            filter.and(new QFilter((String)entry.getKey(), "in", entry.getValue()));
        }
        return filter;
    }

    private Map<String, Set<Object>> initImportField(Set<String> keys, List<ImportDataInfo> collection, BillEntityType dt, InitImportDataEventArgs event) {
        HashMap<String, Set<Object>> fieldValueMap = new HashMap<String, Set<Object>>(16);
        Iterator<ImportDataInfo> iterator = collection.iterator();
        while (iterator.hasNext()) {
            ImportDataInfo dataInfo = iterator.next();
            for (String key : keys) {
                if (PROP_CREATE_ORG.equals(key)) {
                    Map org = (Map)dataInfo.data.get(PROP_CREATE_ORG);
                    fieldValueMap.computeIfAbsent(PROP_CREATE_ORG, k -> new HashSet(16));
                    if (null == org || null == org.get("id")) continue;
                    Long orgId = Long.valueOf(org.get("id").toString());
                    ((Set)fieldValueMap.get(PROP_CREATE_ORG)).add(orgId);
                    dataInfo.fieldValueMap.put(PROP_CREATE_ORG, orgId);
                    continue;
                }
                DynamicProperty fieldProperty = dt.getProperty(key);
                if (fieldProperty instanceof BasedataProp) {
                    Map json = (Map)dataInfo.data.get(key);
                    if (null == json) continue;
                    String importType = (String)json.get("importprop");
                    if (StringUtils.isBlank((CharSequence)importType)) {
                        importType = json.containsKey("number") ? "number" : "name";
                    }
                    String field = key + "." + importType;
                    Object value = json.get(importType);
                    fieldValueMap.computeIfAbsent(field, k -> new HashSet(16)).add(value);
                    dataInfo.fieldValueMap.put(field, value);
                    dataInfo.fieldValueMap.put(key, value);
                    continue;
                }
                Object v = dataInfo.data.get(key);
                try {
                    Object value = this.getImportFieldValue(v, key, fieldProperty);
                    fieldValueMap.computeIfAbsent(key, k -> new HashSet(16)).add(value);
                    dataInfo.fieldValueMap.put(key, value);
                }
                catch (Exception e) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5217\u89e3\u6790\u5f02\u5e38\uff0c \u5217\u4e3a\u3010%1$s\u3011\uff0c\u503c\u4e3a\u3010%2$s\u3011\u3002", (String)"BaseDataCreateOrgPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), key, v);
                    logger.error(msg, (Throwable)e);
                    dataInfo.needValidateUseRight = false;
                    event.addCancelMessage(Integer.valueOf(dataInfo.index), Integer.valueOf(0), Integer.valueOf(0), msg);
                    iterator.remove();
                }
            }
        }
        return fieldValueMap;
    }

    private Object getImportFieldValue(Object value, String field, DynamicProperty fieldProperty) throws ParseException {
        if (value == null) {
            return fieldProperty.getDefaultValue();
        }
        if (fieldProperty instanceof MuliLangTextProp) {
            return LocaleString.fromMap((Map)((Map)value)).toString();
        }
        if (fieldProperty instanceof TimeProp) {
            return TimeProp.timeToSecond((Object)value.toString(), (String)field);
        }
        if (fieldProperty instanceof DecimalProp && value instanceof String) {
            return new BigDecimal(new BigDecimal((String)value).stripTrailingZeros().toPlainString());
        }
        if (fieldProperty instanceof DateTimeProp && !(value instanceof Date)) {
            return ((DateTimeProp)fieldProperty).getDateFormat().parse(value.toString());
        }
        if (fieldProperty instanceof LongProp && !(value instanceof Long)) {
            return Long.valueOf(value.toString());
        }
        return value;
    }

    private boolean equals(Object[] in, Object[] db) {
        if (in == db) {
            return true;
        }
        if (in == null || db == null) {
            return false;
        }
        int length = in.length;
        if (db.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            BigDecimal va;
            Object a = in[i];
            Object b = db[i];
            if (Objects.equals(a, b) || a instanceof Number && b instanceof Number && (va = new BigDecimal(a.toString())).compareTo(new BigDecimal(b.toString())) == 0) continue;
            return false;
        }
        return true;
    }

    private Set<Long> getDisableOrgIds() {
        HashSet<Long> result = new HashSet<Long>(16);
        String entityId = this.getModel().getDataEntityType().getName();
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (Objects.isNull(ctrlView) || this.numberOrgMap.isEmpty()) {
            return result;
        }
        long viewId = ctrlView.getLong("id");
        HashSet<Long> dataCreateOrgIds = new HashSet<Long>(this.numberOrgMap.values());
        QFilter orgFilter = new QFilter(PRO_ORG_ID, "in", dataCreateOrgIds);
        orgFilter.and("view.id", "=", (Object)viewId);
        QFilter statusFilter = new QFilter("isfreeze", "=", (Object)Boolean.TRUE);
        statusFilter.or("org.enable", "=", (Object)Boolean.FALSE);
        try (DataSet ds = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_org_structure", PRO_ORG_ID, new QFilter[]{orgFilter, statusFilter});){
            for (Row row : ds) {
                Long disableOrgId = row.getLong(PRO_ORG_ID);
                result.add(disableOrgId);
            }
        }
        return result;
    }

    private static class ImportDataInfo {
        private int index;
        private Long id;
        private Long orgId;
        private Map<String, Object> data;
        private boolean uniqueKeysContainsId;
        private boolean needValidateUseRight;
        private boolean wasValidate;
        private Map<String, Object> fieldValueMap = new HashMap<String, Object>(16);
        private List<String> uniqueKeys = new ArrayList<String>(10);

        ImportDataInfo(int index, Long orgId, Map<String, Object> data, boolean needValidateUseRight) {
            this.index = index;
            this.orgId = orgId;
            this.data = data;
            this.needValidateUseRight = needValidateUseRight;
        }

        void setId(Long dataId) {
            this.id = dataId;
            this.data.put("id", dataId);
        }

        void removeId() {
            this.id = null;
            this.data.remove("id");
        }
    }

    private static class ImportCreateOrg {
        private int index;
        private String importProp;
        private String name;
        private String number;
        private Long id;
        private Map<String, Object> orgMap;

        ImportCreateOrg(int index, Map<String, Object> orgMap) {
            this.index = index;
            this.setId(orgMap);
            this.name = (String)orgMap.get("name");
            this.number = (String)orgMap.get("number");
            this.orgMap = orgMap;
            this.setImportProp(orgMap);
        }

        final void setId(Map<String, Object> orgMap) {
            Object param = orgMap.get("id");
            if (StringUtils.isBlank((Object)param)) {
                return;
            }
            this.id = Long.valueOf(param.toString());
        }

        final void setImportProp(Map<String, Object> orgMap) {
            this.importProp = null != this.id ? "id" : (StringUtils.isNotBlank((CharSequence)this.number) ? "number" : (StringUtils.isNotBlank((CharSequence)this.name) ? "name" : (String)orgMap.get("importprop")));
        }

        void setOrgProperty(String property, Object value) {
            this.orgMap.put(property, value);
        }
    }
}

