/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.engine.BaseDataUseRelUpdateEngine;
import kd.bos.bd.service.BaseDataAutoUpgradeService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataMaintenanceService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class BaseDataOrgBitMaintenancePlugin
extends AbstractFormPlugin
implements TabSelectListener,
ProgresssListener {
    private static Log logger = LogFactory.getLog(BaseDataOrgBitMaintenancePlugin.class);
    private static String SYSTEM_TYPE = "bos-bd-formplugin";
    private static final String KEY_TAP = "tabap";
    private static final String KEY_TAP_QUERY = "querytap";
    private static final String KEY_TAP_ADD = "addtap";
    private static final String KEY_TAP_DEL = "deltap";
    private static final String KEY_TAP_CLEAR = "cleartab";
    private static final String KEY_TAP_FILL = "filltap";
    private static final String KEY_BD_ENTITY = "basedataentity";
    private static final String KEY_FILL_PROGRESS = "progressbarap";
    private static final String KEY_BILL_LIST = "billlistap";
    private static final String KEY_ORG = "org";
    private static final String CACHE_BIT_INDEXES = "bit_indexes";
    private static final String OP_SELECT_ORG = "batch_select_org";
    private static final String OP_SELECT_BD = "batch_select_bd";
    private static final String OP_CLEAR_ONE_BIT = "clear_uncuorg_bit_only";
    private static final String CB_ACTION_SELECT_ORG = "select_org";
    private static final String CB_ACTION_SELECT_BD = "select_bd";
    private static final String KEY_ENTRY_ADD_ORG = "addorgentry";
    private static final String KEY_ENTRY_ADD_BIT = "addbdindexentry";
    private static final String KEY_ENTRY_DEL_ORG = "delorgentry";
    private static final String KEY_ENTRY_DEL_BIT = "delbdindexentry";
    private static final String BTN_CLEAR_CACHE = "btnclearcache";
    private static final String BTN_BIT_QUERY = "query";
    private static final String BTN_BIT_GENERATE = "generate_index";
    private static final String BTN_BIT_ADD = "add";
    private static final String BTN_BIT_DEL = "delete";
    private static final String BTN_BIT_FILL = "btnfill";
    private static final String BTN_LIST_REFRESH = "refresh";
    private static final String BTN_DEL_SEL_BIT = "deleteseletedbit";
    private static final String BTN_CLEAR_ALL_UN_CUBIT = "clearalluncubit";
    private static final Integer MAX_SHOW_ROW_SIZE = 10000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(KEY_TAP);
        tab.addTabSelectListener((TabSelectListener)this);
        ProgressBar progress = (ProgressBar)this.getView().getControl(KEY_FILL_PROGRESS);
        progress.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_BIT_ADD, BTN_BIT_DEL, BTN_BIT_FILL, BTN_LIST_REFRESH, BTN_DEL_SEL_BIT, BTN_CLEAR_CACHE, BTN_CLEAR_ALL_UN_CUBIT, BTN_BIT_GENERATE});
        OrgEdit orgEdit = (OrgEdit)this.getControl(KEY_ORG);
        orgEdit.addBeforeF7SelectListener(event -> {
            DynamicObject entityType = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
            if (null != entityType) {
                DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityType.getString("number"));
                if (null == ctrlView) {
                    return;
                }
                String viewNumber = ctrlView.getString("number");
                FormShowParameter parameter = event.getFormShowParameter();
                parameter.setCustomParam("orgViewSchemeNumber", (Object)viewNumber);
                parameter.setCustomParam("orgFuncId", (Object)ctrlView.getString("treetype"));
            }
        });
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new ListDataProviderImpl()));
        billList.addSetFilterListener(event -> {
            List filters = event.getQFilters();
            filters.add(this.getBitFilter());
        });
        billList.addCreateListColumnsListener(args -> {
            this.addListColumn(args, "number");
            this.addListColumn(args, "name");
            this.addListColumn(args, "bitindex");
            this.addListColumn(args, "ctrlstrategy");
            this.addListColumn(args, "createorg");
        });
        BillList unCuOrgBillList = (BillList)this.getControl("uncuorgbilllist");
        if (null != unCuOrgBillList) {
            unCuOrgBillList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new UnCuOrgListDataProvider(this.getModel())));
        }
    }

    private void addListColumn(BeforeCreateListColumnsArgs args, String key) {
        ListColumn column = (ListColumn)args.getListColumn(key);
        if (null == column) {
            column = new ListColumn();
            column.setCaption(new LocaleString(key));
            column.setListFieldKey(key);
            column.setKey(key);
            column.setFieldName(key);
            args.getListColumns().add(column);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getModel().getValue(KEY_BD_ENTITY);
        if (null == value) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentpanelap", "operatepanel"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"BaseDataOrgBitMaintenancePlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    public void click(EventObject evt) {
        DynamicObject baseEntity = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
        if (null == baseEntity) {
            return;
        }
        HashMap<String, Consumer<String>> opAdapterMap = new HashMap<String, Consumer<String>>(6);
        opAdapterMap.put(BTN_BIT_ADD, this::addBitIndexes);
        opAdapterMap.put(BTN_BIT_DEL, this::removeBitIndex);
        opAdapterMap.put(BTN_BIT_FILL, this::executeFillBit);
        opAdapterMap.put(BTN_LIST_REFRESH, this::refreshBitList);
        opAdapterMap.put(BTN_DEL_SEL_BIT, this::deleteSelectBitFormOrg);
        opAdapterMap.put(BTN_CLEAR_CACHE, this::clearOrgBitCache);
        opAdapterMap.put(BTN_CLEAR_ALL_UN_CUBIT, this::showClearAllUnCuOrgBitConfirm);
        opAdapterMap.put(BTN_BIT_GENERATE, this::generateIndexAndFillBit);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        String entity = baseEntity.getString("number");
        Consumer consumer = (Consumer)opAdapterMap.get(controlKey);
        if (consumer != null) {
            consumer.accept(entity);
        }
    }

    private void addBitIndexes(String entity) {
        Set<Long> orgIds = this.getSelectOrgIds(KEY_ENTRY_ADD_ORG, "addorgid");
        List<Integer> addBitIndexes = this.getSelectBitIndexes(KEY_ENTRY_ADD_BIT, "addbdbitindex");
        if (orgIds.isEmpty() || addBitIndexes.isEmpty()) {
            return;
        }
        HashMap rel = new HashMap(orgIds.size());
        orgIds.forEach(orgId -> rel.put(orgId, addBitIndexes));
        try {
            new BaseDataCommonService().saveOrUpdateRelBit(rel, entity);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"BaseDataOrgBitMaintenancePlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            new BaseDataCommonService().writOpLog(rel, entity, "new", null);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u4f4d\u56fe\u5f02\u5e38...", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u4f4d\u56fe\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BaseDataOrgBitMaintenancePlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void removeBitIndex(String entity) {
        Set<Long> orgIds = this.getSelectOrgIds(KEY_ENTRY_DEL_ORG, "delorgid");
        List<Integer> delBitIndexes = this.getSelectBitIndexes(KEY_ENTRY_DEL_BIT, "delbitindex");
        if (orgIds.isEmpty() || delBitIndexes.isEmpty()) {
            return;
        }
        HashMap rel = new HashMap(orgIds.size());
        orgIds.forEach(orgId -> rel.put(orgId, delBitIndexes));
        try {
            new BaseDataCommonService().deleteBitFromOrgUseRel(entity, rel);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BaseDataOrgBitMaintenancePlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            new BaseDataCommonService().writOpLog(rel, entity, BTN_BIT_DEL, null);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4f4d\u56fe\u5f02\u5e38...", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u4f4d\u56fe\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BaseDataOrgBitMaintenancePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void refreshBitList(String entity) {
        Object value = this.getModel().getValue(KEY_ORG);
        this.cacheOrgBitIndexes((DynamicObject)value, entity);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
        billList.clearSelection();
        billList.refresh();
    }

    private void deleteSelectBitFormOrg(String entity) {
        Object value = this.getModel().getValue(KEY_ORG);
        if (null == value) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"BaseDataOrgBitMaintenancePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f4d\u56fe\u6570\u636e\u3002", (String)"BaseDataOrgBitMaintenancePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        ArrayList dataIds = new ArrayList(selectedRows.size());
        selectedRows.forEach(row -> dataIds.add(Long.valueOf(row.getPrimaryKeyValue().toString())));
        BaseDataCommonService service = new BaseDataCommonService();
        Collection bitIndexes = service.getBaseDataId2BitIndexMap(dataIds, entity).values();
        HashMap rel = new HashMap(1);
        DynamicObject org = (DynamicObject)value;
        rel.put(org.getLong("id"), new ArrayList(bitIndexes));
        try {
            service.deleteBitFromOrgUseRel(entity, rel);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BaseDataOrgBitMaintenancePlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            new BaseDataCommonService().writOpLog(rel, entity, BTN_BIT_DEL, null);
            this.refreshBitList(entity);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4f4d\u56fe\u5f02\u5e38...", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u4f4d\u56fe\u5f02\u5e38\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BaseDataOrgBitMaintenancePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void clearOrgBitCache(String entity) {
        Object orgValue = this.getModel().getValue(KEY_ORG);
        if (null == orgValue) {
            return;
        }
        DynamicObject org = (DynamicObject)orgValue;
        Long orgId = (Long)org.getPkValue();
        BaseDataUseRelUpdateEngine.removeRelBitCache((String)entity, (Long)orgId);
        this.getView().showSuccessNotification("clear bit cache success.");
    }

    private Set<Long> getSelectOrgIds(String entryKey, String orgIdKey) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        if (collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u7ec4\u7ec7\u3002", (String)"BaseDataOrgBitMaintenancePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return Collections.emptySet();
        }
        EntryGrid billList = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = billList.getSelectRows();
        if (null == selectRows || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"BaseDataOrgBitMaintenancePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return Collections.emptySet();
        }
        HashSet<Long> orgIds = new HashSet<Long>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject org = (DynamicObject)collection.get(index);
            orgIds.add(Long.valueOf(org.getString(orgIdKey)));
        }
        return orgIds;
    }

    private List<Integer> getSelectBitIndexes(String entryKey, String bitKey) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        if (collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4f4d\u56fe\u6570\u636e\u3002", (String)"BaseDataOrgBitMaintenancePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return Collections.emptyList();
        }
        EntryGrid billList = (EntryGrid)this.getControl(entryKey);
        DynamicObject[] dataArr = billList.getEntryData().getDataEntitys();
        if (null == dataArr || dataArr.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f4d\u56fe\u6570\u636e\u3002", (String)"BaseDataOrgBitMaintenancePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return Collections.emptyList();
        }
        HashSet<Integer> bitIndexes = new HashSet<Integer>(dataArr.length);
        for (DynamicObject data : dataArr) {
            bitIndexes.add(data.getInt(bitKey));
        }
        bitIndexes.remove(0);
        return new ArrayList<Integer>(bitIndexes);
    }

    private void executeFillBit(String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u5b58\u5728\u3002", (String)"BaseDataOrgBitMaintenancePlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(String.valueOf(ctrlView.get("number")));
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (null == rootNode) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BIT_FILL});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FILL_PROGRESS});
        ProgressBar progress = (ProgressBar)this.getView().getControl(KEY_FILL_PROGRESS);
        progress.start();
        List allChildOrgNodeList = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
        ArrayList<TreeNode> rootNodeChildList = new ArrayList<TreeNode>(allChildOrgNodeList.size());
        rootNode.setChildren(rootNodeChildList);
        for (TreeNode node : allChildOrgNodeList) {
            if (!node.getParentid().equals(rootNode.getId())) continue;
            rootNodeChildList.add(node);
        }
        HashMap<Long, Set<Integer>> orgShareBitMap = new HashMap<Long, Set<Integer>>(16);
        HashMap<Long, Set<Long>> orgMstIdMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Integer, Long> bitMstIdMap = new HashMap<Integer, Long>(16);
        Map<Long, Set<Integer>> ownerData = this.initFillBitData(entity, orgShareBitMap, orgMstIdMap, bitMstIdMap);
        if (BaseDataCommonService.isTreeType((String)entity)) {
            this.fillBitDataOnTreeType(rootNode, ownerData, orgShareBitMap, orgMstIdMap, bitMstIdMap);
        } else {
            this.fillBitDataOnNormalType(rootNode, orgShareBitMap, ownerData);
        }
    }

    private void fillBitDataOnTreeType(TreeNode rootNode, Map<Long, Set<Integer>> ownerData, Map<Long, Set<Integer>> orgShareBitMap, Map<Long, Set<Long>> orgMstIdMap, Map<Integer, Long> bitMstIdMap) {
    }

    private void fillBitDataOnNormalType(TreeNode rootNode, Map<Long, Set<Integer>> orgShareBitMap, Map<Long, Set<Integer>> ownerData) {
        List children = rootNode.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Long orgId = Long.valueOf(rootNode.getId());
        Set<Integer> parentShareBitSet = orgShareBitMap.get(orgId);
        for (TreeNode node : children) {
            Set<Integer> childOrgShareBitSet;
            HashSet<Integer> tempBits = new HashSet<Integer>(16);
            Long childOrgId = Long.valueOf(node.getId());
            if (null != parentShareBitSet) {
                Set<Integer> bits = ownerData.get(childOrgId);
                if (null != bits) {
                    bits.addAll(parentShareBitSet);
                } else {
                    ownerData.put(childOrgId, parentShareBitSet);
                }
                tempBits.addAll(parentShareBitSet);
            }
            if (null != (childOrgShareBitSet = orgShareBitMap.get(childOrgId))) {
                tempBits.addAll(childOrgShareBitSet);
            }
            this.fillBitDataOnNormalType(node, orgShareBitMap, ownerData, tempBits);
        }
    }

    private void fillBitDataOnNormalType(TreeNode node, Map<Long, Set<Integer>> orgShareBitMap, Map<Long, Set<Integer>> ownerData, Set<Integer> tempBits) {
        List children = node.getChildren();
        if (children.isEmpty()) {
            return;
        }
        for (TreeNode childNode : children) {
            Long childOrgId = Long.valueOf(childNode.getId());
            Set<Integer> currentOrgBits = ownerData.get(childOrgId);
            if (!tempBits.isEmpty()) {
                if (null != currentOrgBits) {
                    currentOrgBits.addAll(tempBits);
                } else {
                    currentOrgBits = new HashSet<Integer>(tempBits);
                    ownerData.put(childOrgId, currentOrgBits);
                }
            }
            Set<Integer> shareBits = orgShareBitMap.get(childOrgId);
            HashSet<Integer> bits = new HashSet<Integer>(tempBits);
            if (null != shareBits) {
                bits.addAll(shareBits);
            }
            this.fillBitDataOnNormalType(childNode, orgShareBitMap, ownerData, bits);
        }
    }

    private Map<Long, Set<Integer>> initFillBitData(String entity, Map<Long, Set<Integer>> orgShareBitMap, Map<Long, Set<Long>> orgMstIdMap, Map<Integer, Long> bitMstIdMap) {
        IDataEntityType dt = ORM.create().getDataEntityType(entity);
        String selectOwnerDataSql = String.format("select fid, fmasterid, fcreateorgid, fbitindex, fctrlstrategy from %s where fctrlstrategy in ('1', '2', '6', '7');", dt.getAlias());
        return (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)selectOwnerDataSql, rs -> {
            HashMap<Long, Set> ownerData = new HashMap<Long, Set>(16);
            while (rs.next()) {
                Long orgId = rs.getLong("fcreateorgid");
                int bit = rs.getInt("fbitindex");
                if (0 == bit) continue;
                ownerData.computeIfAbsent(orgId, k -> new HashSet(16)).add(bit);
                if (!"6".equals(rs.getString("fctrlstrategy"))) continue;
                orgShareBitMap.computeIfAbsent(orgId, k -> new HashSet(16)).add(bit);
                Long masterId = rs.getLong("fmasterid");
                orgMstIdMap.computeIfAbsent(orgId, k -> new HashSet(16)).add(masterId);
                bitMstIdMap.put(bit, masterId);
            }
            return ownerData;
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject baseEntity = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
        if (null == baseEntity) {
            return;
        }
        String entity = baseEntity.getString("number");
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_SELECT_ORG.equals(operateKey)) {
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
            if (null == ctrlView) {
                return;
            }
            String viewNumber = ctrlView.getString("number");
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true);
            parameter.setCustomParam("orgViewSchemeNumber", (Object)viewNumber);
            parameter.setCustomParam("orgFuncId", (Object)ctrlView.getString("treetype"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CB_ACTION_SELECT_ORG));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (OP_SELECT_BD.equals(operateKey)) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entity, (boolean)true);
            parameter.setUseOrgId(0L);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CB_ACTION_SELECT_BD));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (OP_CLEAR_ONE_BIT.equals(operateKey)) {
            this.clearUnCuOrgBit(entity);
        }
    }

    private void clearUnCuOrgBit(String entity) {
        if (!BaseDataCommonService.isNewModel((String)entity)) {
            this.getView().showTipNotification("odl model does not need to clear bit data.");
            return;
        }
        BillList billList = (BillList)this.getControl("uncuorgbilllist");
        ListSelectedRow rowInfo = billList.getCurrentSelectedRowInfo();
        Object pk = rowInfo.getPrimaryKeyValue();
        if (null == pk) {
            this.getView().showTipNotification("org`s id is null, abort clear operate.");
            return;
        }
        try {
            Long orgStructureId = Long.valueOf(pk.toString());
            boolean success = new BaseDataMaintenanceService(entity).clearUnCuOrgBit(orgStructureId);
            if (success) {
                this.getView().showSuccessNotification("clear org bit success.");
            } else {
                this.getView().showTipNotification("clear org bit fail.");
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u5355\u4e2a\u975eCU\u7ec4\u7ec7\u4f4d\u56fe\u5931\u8d25", (Throwable)e);
            this.getView().showTipNotification("clear one un_cu_org`s bit fail.");
        }
    }

    private void showClearAllUnCuOrgBitConfirm(String entity) {
        if (!BaseDataCommonService.isNewModel((String)entity)) {
            this.getView().showTipNotification("odl model does not need to clear bit data.");
            return;
        }
        String msg = ResManager.loadKDString((String)"\u5c06\u6267\u884c\u6e05\u9664\u6240\u6709\u975eCU\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\uff0c\u6e05\u9664\u540e\u5c06\u4e0d\u53ef\u4ee5\u6062\u590d\uff0c\u662f\u5426\u6267\u884c\uff1f", (String)"BaseDataOrgBitMaintenancePlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(BTN_CLEAR_ALL_UN_CUBIT, (IFormPlugin)this));
    }

    private void generateIndexAndFillBit(String entity) {
        if (BaseDataCommonService.isNewModel((String)entity)) {
            new BaseDataAutoUpgradeService().generateIndexAndFillBitData(entity);
            this.getView().showTipNotification("generate index and fill bit complete.");
        } else {
            this.getView().showTipNotification("odl model does not need to generate index and fill bit.");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (MessageBoxResult.Yes == event.getResult() && BTN_CLEAR_ALL_UN_CUBIT.equals(event.getCallBackId())) {
            this.clearAllUnCuOrgBit();
        }
    }

    private void clearAllUnCuOrgBit() {
        DynamicObject baseEntity = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
        if (null == baseEntity) {
            String msg = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"BaseDataOrgBitMaintenancePlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
        String entity = baseEntity.getString("number");
        try {
            boolean success = new BaseDataMaintenanceService(entity).clearAllUnCuOrgBit();
            if (success) {
                this.getView().showSuccessNotification("clear all uncu org bit success.");
            } else {
                this.getView().showTipNotification("clear all uncu org bit fail.");
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u6e05\u9664\u6240\u6709\u975eCU\u7ec4\u7ec7\u4f4d\u56fe\u6570\u636e\u5f02\u5e38...", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6570\u636e\u5931\u8d25\u3002", (String)"BaseDataOrgBitMaintenancePlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        Tab tab = (Tab)this.getControl(KEY_TAP);
        String currentTab = tab.getCurrentTab();
        String actionId = event.getActionId();
        if (CB_ACTION_SELECT_ORG.equals(actionId) && KEY_TAP_ADD.equals(currentTab)) {
            this.fillSelectOrgEntry(KEY_ENTRY_ADD_ORG, "addorgid", "addorgnumber", "addorgname", selectedRows);
        } else if (CB_ACTION_SELECT_ORG.equals(actionId) && KEY_TAP_DEL.equals(currentTab)) {
            this.fillSelectOrgEntry(KEY_ENTRY_DEL_ORG, "delorgid", "delorgnumber", "delorgname", selectedRows);
        } else if (CB_ACTION_SELECT_BD.equals(actionId) && KEY_TAP_ADD.equals(currentTab)) {
            this.fillSelectBaseDataEntry(KEY_ENTRY_ADD_BIT, "addbdbitindex", "addbdnumber", "addbdname", selectedRows);
        } else if (CB_ACTION_SELECT_BD.equals(actionId) && KEY_TAP_DEL.equals(currentTab)) {
            this.fillSelectBaseDataEntry(KEY_ENTRY_DEL_BIT, "delbitindex", "delbdnumber", "delbdname", selectedRows);
        }
    }

    private void fillSelectOrgEntry(String entryKey, String orgIdKey, String numberKey, String nameKey, ListSelectedRowCollection selectedRows) {
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = model.getEntryEntity(entryKey);
        EntryProp entryProp = (EntryProp)model.getDataEntityType().getProperty(entryKey);
        EntryType entryType = (EntryType)entryProp.getItemType();
        for (ListSelectedRow selectedRow : selectedRows) {
            DynamicObject org = new DynamicObject((DynamicObjectType)entryType);
            org.set(orgIdKey, (Object)selectedRow.getPrimaryKeyValue().toString());
            org.set(numberKey, (Object)selectedRow.getNumber());
            org.set(nameKey, (Object)selectedRow.getName());
            collection.add((Object)org);
        }
        model.updateEntryCache(collection);
        this.getView().updateView(entryKey);
    }

    private void fillSelectBaseDataEntry(String entryKey, String bitKey, String numberKey, String nameKey, ListSelectedRowCollection selectedRows) {
        DynamicObject baseEntity = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
        if (null == baseEntity) {
            return;
        }
        String entity = baseEntity.getString("number");
        ArrayList<Long> dataIds = new ArrayList<Long>(selectedRows.size());
        int showRowSize = Math.min(selectedRows.size(), MAX_SHOW_ROW_SIZE);
        for (int i = 0; i < showRowSize; ++i) {
            ListSelectedRow row = selectedRows.get(i);
            dataIds.add(Long.valueOf(row.getPrimaryKeyValue().toString()));
        }
        Map idIndexMap = new BaseDataCommonService().getBaseDataId2BitIndexMap(dataIds, entity);
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = model.getEntryEntity(entryKey);
        EntryProp entryProp = (EntryProp)model.getDataEntityType().getProperty(entryKey);
        EntryType entryType = (EntryType)entryProp.getItemType();
        for (int i = 0; i < showRowSize; ++i) {
            ListSelectedRow selectedRow = selectedRows.get(i);
            DynamicObject bd = new DynamicObject((DynamicObjectType)entryType);
            Long dataId = (Long)selectedRow.getPrimaryKeyValue();
            Integer bitIndex = (Integer)idIndexMap.get(dataId);
            if (null == bitIndex) continue;
            bd.set(bitKey, (Object)bitIndex);
            bd.set(numberKey, (Object)selectedRow.getNumber());
            bd.set(nameKey, (Object)selectedRow.getName());
            collection.add((Object)bd);
        }
        model.updateEntryCache(collection);
        this.getView().updateView(entryKey);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (null == newValue) {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (KEY_BD_ENTITY.equals(propertyName)) {
            DynamicObject bdType = (DynamicObject)newValue;
            String entity = bdType.getString("number");
            if (StringUtils.isEmpty((String)entity)) {
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"contentpanelap", "operatepanel"});
            this.clearEntry();
            Tab tab = (Tab)this.getControl(KEY_TAP);
            tab.activeTab(KEY_TAP_QUERY);
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BIT_ADD, BTN_CLEAR_CACHE, BTN_BIT_DEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLEAR_CACHE, BTN_BIT_QUERY});
            BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
            billList.changeBillFormId(entity);
            billList.setEntityId(entity);
            billList.setBillFormId(entity);
            Object value = this.getModel().getValue(KEY_ORG);
            this.cacheOrgBitIndexes((DynamicObject)value, entity);
            billList.clearSelection();
            billList.refresh();
        } else if (KEY_ORG.equals(propertyName)) {
            DynamicObject entityType = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
            String entity = null == entityType ? StringUtils.getEmpty() : entityType.getString("number");
            this.cacheOrgBitIndexes((DynamicObject)newValue, entity);
            BillList billList = (BillList)this.getControl(KEY_BILL_LIST);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void cacheOrgBitIndexes(DynamicObject org, String entity) {
        if (org == null) {
            this.getPageCache().putBigObject(CACHE_BIT_INDEXES, SerializationUtils.toJsonString(Collections.emptyList()));
            return;
        }
        ArrayList indexes = new ArrayList(16);
        try {
            indexes.addAll(BaseDataUseRelQueryEngine.getUseBaseDataIndexByOrgId((Long)((Long)org.getPkValue()), (String)entity));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f4d\u56fe\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        this.getPageCache().putBigObject(CACHE_BIT_INDEXES, SerializationUtils.toJsonString(indexes));
    }

    private void clearEntry() {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY_ADD_ORG);
        model.deleteEntryData(KEY_ENTRY_ADD_BIT);
        model.deleteEntryData(KEY_ENTRY_DEL_ORG);
        model.deleteEntryData(KEY_ENTRY_DEL_BIT);
        BillList unCuOrgBillList = (BillList)this.getControl("uncuorgbilllist");
        if (null != unCuOrgBillList) {
            unCuOrgBillList.clearSelection();
            unCuOrgBillList.clearEntryState();
            unCuOrgBillList.clearData();
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        if (KEY_TAP_ADD.equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLEAR_CACHE, BTN_BIT_QUERY, BTN_BIT_DEL, BTN_CLEAR_ALL_UN_CUBIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BIT_ADD});
        } else if (KEY_TAP_DEL.equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BIT_ADD, BTN_BIT_QUERY, BTN_CLEAR_CACHE, BTN_CLEAR_ALL_UN_CUBIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BIT_DEL});
        } else if (KEY_TAP_QUERY.equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BIT_ADD, BTN_CLEAR_CACHE, BTN_BIT_DEL, BTN_CLEAR_ALL_UN_CUBIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLEAR_CACHE, BTN_BIT_QUERY});
        } else if (KEY_TAP_CLEAR.equals(tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BIT_ADD, BTN_CLEAR_CACHE, BTN_BIT_DEL, BTN_CLEAR_CACHE, BTN_BIT_QUERY});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLEAR_ALL_UN_CUBIT});
            this.loadUnCuOrgBillList();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BIT_ADD, BTN_CLEAR_CACHE, BTN_BIT_DEL, BTN_BIT_QUERY, KEY_FILL_PROGRESS, BTN_CLEAR_ALL_UN_CUBIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BIT_FILL});
        }
    }

    private void loadUnCuOrgBillList() {
        BillList unCuOrgBillList = (BillList)this.getControl("uncuorgbilllist");
        if (null == unCuOrgBillList) {
            return;
        }
        DynamicObject baseEntity = (DynamicObject)this.getModel().getValue(KEY_BD_ENTITY);
        if (null == baseEntity) {
            return;
        }
        String entity = baseEntity.getString("number");
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            return;
        }
        FilterParameter parameter = unCuOrgBillList.getQueryFilterParameter();
        parameter.setFilter(new QFilter("view", "=", ctrlView.getPkValue()));
        unCuOrgBillList.clearSelection();
        unCuOrgBillList.refresh();
    }

    private QFilter getBitFilter() {
        String value = this.getPageCache().getBigObject(CACHE_BIT_INDEXES);
        if (StringUtils.isEmpty((String)value)) {
            return new QFilter("bitindex", "in", Collections.emptyList());
        }
        List bitIndexes = SerializationUtils.fromJsonStringToList((String)value, Integer.class);
        return new QFilter("bitindex", "in", (Object)bitIndexes);
    }

    static class UnCuOrgListDataProvider
    extends ListDataProvider {
        private IDataModel model;

        UnCuOrgListDataProvider(IDataModel model) {
            this.model = model;
        }

        public void setQueryBuilder(QueryBuilder queryBuilder) {
            queryBuilder.setExceedMaxCount(false);
            DynamicObject baseEntity = (DynamicObject)this.model.getValue(BaseDataOrgBitMaintenancePlugin.KEY_BD_ENTITY);
            if (null == baseEntity) {
                super.setQueryBuilder(queryBuilder);
                return;
            }
            String entity = baseEntity.getString("number");
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(queryBuilder.getFilters()));
            filters.add(new QFilter("view", "=", ctrlView.getPkValue()));
            queryBuilder.setFilters(filters.toArray(new QFilter[0]));
            super.setQueryBuilder(queryBuilder);
        }
    }

    class ListDataProviderImpl
    extends ListDataProvider {
        ListDataProviderImpl() {
        }

        public int getRealCount() {
            QueryBuilder queryBuilder = this.getQueryBuilder();
            QFilter bitFilter = BaseDataOrgBitMaintenancePlugin.this.getBitFilter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(Arrays.asList(queryBuilder.getFilters()));
            filters.add(bitFilter);
            queryBuilder.setFilters(filters.toArray(new QFilter[0]));
            return CountQuery.getCount((QueryBuilder)queryBuilder);
        }

        public void setQueryBuilder(QueryBuilder queryBuilder) {
            queryBuilder.setExceedMaxCount(false);
            super.setQueryBuilder(queryBuilder);
        }
    }
}

