/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.bd.service.BaseDataAutoUpgradeService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class DefCtrlStrtgyFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IConfirmCallBack {
    private static final Log LOGGER = LogFactory.getLog(DefCtrlStrtgyFormPlugin.class);
    public static final String BASEDATA_SYSTEM_ID = "0efa1992000000ac";
    private static final String BILL_OPERATION_DRAFT = "draft";
    private static final String BILL_OPERATION_SAVE = "save";
    private static final String BASEDATAID = "basedataid";
    private static final String NUMBER = "number";
    private static final String DEFAULT_CTRLSTRATEGY = "defaultctrlstrategy";
    private static final String CONFIRM_MODIFYCTRLSTRATEGY = "confirmModifyCtrlstrategy";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String BOS_BD_FORMPLUGIN = "bos-bd-formplugin";
    private static final String APPSYSTEM = "appsystem";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ctrlview = (BasedataEdit)this.getControl("ctrlview");
        ctrlview.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button button = (Button)this.getControl("btnsave");
        button.addClickListener((ClickListener)this);
        BasedataEdit solidifyObj = (BasedataEdit)this.getControl("solidifyobj");
        solidifyObj.addBeforeF7SelectListener(evt -> evt.addCustomQFilter(this.getSolidifyObjFilter()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty pro = e.getProperty();
        if (BASEDATAID.equalsIgnoreCase(pro.getName())) {
            DynamicObject basedata = (DynamicObject)this.getModel().getValue(BASEDATAID);
            if (null == basedata) {
                return;
            }
            String entity = basedata.getString(NUMBER);
            this.setCtrlStrategy(entity);
            String appid = BizAppServiceHelp.getAppIdByFormNum((String)entity);
            this.getModel().setValue(APPSYSTEM, (Object)appid);
            this.setDatatype(appid);
            boolean isAbleUpgradeModel = BaseDataAutoUpgradeService.isAbleUpgradeModel((String)entity);
            if (isAbleUpgradeModel) {
                this.getModel().setValue("upgradestatus", (Object)"2");
            } else {
                this.getModel().setValue("upgradestatus", (Object)"1");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String systemId = (String)this.getView().getFormShowParameter().getCustomParam("systemId");
        String viewId = this.getViewSchemaByAppSystem(systemId);
        this.getModel().setValue("ctrlview", (Object)viewId);
        this.setBasedataFilter();
        this.setDatatype(systemId);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        if (StringUtils.isNotEmpty((CharSequence)entityId)) {
            this.getModel().setValue(BASEDATAID, (Object)entityId);
            this.getView().setEnable(Boolean.FALSE, new String[]{BASEDATAID});
            DynamicObject basedata = (DynamicObject)this.getModel().getValue(BASEDATAID);
            if (null == basedata) {
                return;
            }
            this.setCtrlStrategy(basedata.getString(NUMBER));
            String appid = BizAppServiceHelp.getAppIdByFormNum((String)basedata.getString(NUMBER));
            this.getModel().setValue(APPSYSTEM, (Object)appid);
            this.setDatatype(appid);
        }
    }

    private void setCtrlStrategy(String entityID) {
        boolean isGalaxyUltimate = OrgUnitServiceHelper.isGalaxyUltimate();
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entityID, MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        ComboField comboField = null;
        for (EntityItem item : items) {
            if (!CTRLSTRATEGY.equals(item.getKey()) || !(item instanceof ComboField)) continue;
            comboField = (ComboField)item;
            comboField.getItems();
        }
        if (null != comboField) {
            ComboEdit defaultctrlstrategy = (ComboEdit)this.getControl(DEFAULT_CTRLSTRATEGY);
            ComboItem comboItem = new ComboItem();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
            for (kd.bos.metadata.entity.commonfield.ComboItem item : comboField.getItems()) {
                LocaleString localeString = item.getCaption();
                String imageKey = item.getImageKey();
                String value = item.getValue();
                if (isGalaxyUltimate && ("1".equals(value) || "6".equals(value)) || "2".equals(value) && BaseDataCommonService.isTreeType((String)entityID)) continue;
                boolean itemVisible = item.isItemVisible();
                comboItem = new ComboItem(imageKey, localeString, value, itemVisible);
                comboItems.add(comboItem);
            }
            defaultctrlstrategy.setComboItems(comboItems);
        }
    }

    private void setBasedataFilter() {
        String sql = "select a.fnumber from t_meta_entitydesign a  left join t_meta_bizapp  app on a.Fbizappid =app.fid  where  a.fistemplate = '0'  and app.FDEPLOYSTATUS ='2'  AND (a.FINHERITPATH like '%6138b0d200000eac%' or a.FINHERITPATH like '%ab7efc31000015ac%' or a.FINHERITPATH like '%b0d31cea000006ac%')";
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            HashSet<String> ids = new HashSet<String>(16);
            while (rs.next()) {
                ids.add(rs.getString("fnumber"));
            }
            return ids;
        });
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_bddefctrlstrtgy");
        String dbRouteKey = entityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        Set excludeNumberet = (Set)DB.query((DBRoute)dbRoute, (String)"select fbasedataid from T_BD_DefaultCtrlStrategy", null, rs -> {
            HashSet<String> set = new HashSet<String>(16);
            while (rs.next()) {
                set.add(rs.getString("fbasedataid"));
            }
            return set;
        });
        idSet.removeIf(excludeNumberet::contains);
        BasedataEdit bde = (BasedataEdit)this.getControl(BASEDATAID);
        bde.setQFilter(new QFilter(NUMBER, "in", (Object)idSet));
    }

    private QFilter getSolidifyObjFilter() {
        String sql = "select fnumber from t_meta_entitydesign where FINHERITPATH like '%360UHRKD8/UQ%';";
        List solidifyObjs = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
        return new QFilter(NUMBER, "in", (Object)solidifyObjs);
    }

    private void setDatatype(String systemId) {
        if (systemId == null) {
            return;
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)systemId)});
        if ("BASEDATA".equals(obj.getString(NUMBER))) {
            this.getModel().setValue("datatype", (Object)1);
        } else {
            this.getModel().setValue("datatype", (Object)2);
        }
    }

    private String getViewSchemaByAppSystem(String systemId) {
        String viewId = null;
        if (systemId == null) {
            return viewId;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)systemId);
        DynamicObject objSystem = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"name, orgfunc", (QFilter[])new QFilter[]{idFilter});
        viewId = objSystem.getString("orgfunc");
        return viewId;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operationKey;
        OperationResult operResult = afterDoOperationEventArgs.getOperationResult();
        if (operResult == null || !operResult.isSuccess()) {
            return;
        }
        String sOperation = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.isBlank((CharSequence)sOperation)) {
            return;
        }
        switch (operationKey = sOperation.toLowerCase(Locale.ENGLISH)) {
            case "draft": 
            case "save": {
                DynamicObject basedata = (DynamicObject)this.getModel().getValue(BASEDATAID);
                String entityType = (String)basedata.getPkValue();
                String baseDataCtrlPlugin = (String)this.getModel().getValue("plugin");
                BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPlugin);
                DynamicObject appsystem = (DynamicObject)this.getModel().getValue(APPSYSTEM);
                DynamicObject bizclould = appsystem.getDynamicObject("bizcloud");
                String type = BaseDataCtrlCacheMrg.getType4CtrlStrgy();
                BaseDataCtrlCacheMrg.clearCache((String)type);
                BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityType);
                BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)"BD_CTRL", (String)entityType);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("entityType", entityType);
                data.put("clould", (String)bizclould.getPkValue());
                this.getView().returnDataToParent(data);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue(BASEDATAID);
        if (null == basedata) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599", (String)"DefCtrlStrtgyFormPlugin_0", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        } else {
            String entityName = basedata.getString(NUMBER);
            Map map = EntityMetadataCache.getDataEntityType((String)entityName).getAllFields();
            OrgProp pro = (OrgProp)map.get("createorg");
            if (pro != null) {
                String orgFunc = pro.getOrgFunc();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u7ba1\u63a7\u89c6\u56fe\u65b9\u6848", (String)"DefCtrlStrtgyFormPlugin_1", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
                if (StringUtils.isEmpty((CharSequence)orgFunc)) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("treetype", "=", (Object)"16"));
                } else {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("treetype", "=", (Object)orgFunc));
                    if (OrgUnitServiceHelper.isGalaxyUltimate()) {
                        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isdefault", "=", (Object)"1"));
                    }
                }
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue(BASEDATAID);
        if (null == basedata) {
            return;
        }
        try {
            String entityId = basedata.getString("id");
            String selectProperties = "id";
            QFilter qFilter = new QFilter(CTRLSTRATEGY, "=", (Object)" ");
            QFilter[] qFilters = new QFilter[]{qFilter};
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityId, (String)selectProperties, (QFilter[])qFilters);
            if (null != obj) {
                evt.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_MODIFYCTRLSTRATEGY, (IConfirmCallBack)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u8d44\u6599\u5b58\u5728\u672a\u8bbe\u7f6e\u7ba1\u63a7\u7b56\u7565\u7684\u6570\u636e\uff0c\u7cfb\u7edf\u5c06\u6309\u7167\u201c\u5168\u5c40\u5171\u4eab\u201d\u7684\u63a7\u5236\u7b56\u7565\u4fee\u590d\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"DefCtrlStrtgyFormPlugin_2", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (CONFIRM_MODIFYCTRLSTRATEGY.equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            this.modifyCtrlstrategy();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"DefCtrlStrtgyFormPlugin_3", (String)BOS_BD_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void modifyCtrlstrategy() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue(BASEDATAID);
        String entityId = basedata.getString("id");
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        String baseDataTableName = dt.getAlias();
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        QFilter qFilter = new QFilter(CTRLSTRATEGY, "=", (Object)" ");
        QFilter[] qFilters = new QFilter[]{qFilter};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)entityId, (QFilter[])qFilters);
        DynamicObject[] objs = new DynamicObject[objMap.size()];
        Collection objCol = objMap.values();
        Iterator iter = objCol.iterator();
        int i = 0;
        while (iter.hasNext()) {
            objs[i] = (DynamicObject)iter.next();
            ++i;
        }
        StringBuilder modifySql = new StringBuilder();
        modifySql.append("update ").append(baseDataTableName).append(" set fctrlstrategy = ? ");
        modifySql.append(" where fctrlstrategy = ?");
        ArrayList<Object[]> params = new ArrayList<Object[]>(1);
        params.add(new Object[]{"5", " "});
        DB.executeBatch((DBRoute)dbRoute, (String)modifySql.toString(), params);
        BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])objs);
    }
}

