/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.bdctrl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.plugin.bdctrl.TreeBaseDataSaveValidator;
import kd.bos.form.plugin.bdctrl.op.AbstractBaseDataOpServicePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class TreeBaseDataSavePlugin
extends AbstractBaseDataOpServicePlugin {
    private Map<Long, Map<String, List<DynamicObject>>> useOrgParentMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
    private Map<Object, DynamicObject> parentMap = Collections.emptyMap();

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        eventArgs.getFieldKeys().add("parent");
        eventArgs.getFieldKeys().add("longnumber");
        eventArgs.getFieldKeys().add("isleaf");
        eventArgs.getFieldKeys().add("level");
        eventArgs.getFieldKeys().add("ctrlstrategy");
        eventArgs.getFieldKeys().add("parent.createorg");
        eventArgs.getFieldKeys().add("parent.number");
        eventArgs.getFieldKeys().add("parent.ctrlstrategy");
        eventArgs.getFieldKeys().add(BaseDataServiceHelper.getMasterIdPropName((String)this.billEntityType.getName()));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        TreeBaseDataSaveValidator validator = new TreeBaseDataSaveValidator();
        validator.setEntityKey(this.billEntityType.getName());
        e.addValidator((AbstractValidator)validator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List entities = e.getValidExtDataEntities();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        HashMap<Long, Set> org2parentNumMap = new HashMap<Long, Set>(16);
        HashSet<Long> parentIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : entities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            Long parentId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"parent");
            if (parentId == 0L) continue;
            parentIds.add(parentId);
            DynamicObject parent = data.getDynamicObject("parent");
            String parentNum = parent.getString("number");
            if (StringUtils.isEmpty((Object)parentNum)) continue;
            Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"useorg");
            org2parentNumMap.computeIfAbsent(useOrgId, k -> new HashSet(16)).add(parent.getString("number"));
        }
        if (!parentIds.isEmpty()) {
            this.parentMap = BusinessDataServiceHelper.loadFromCache((Object[])parentIds.toArray(new Object[0]), (String)this.billEntityType.getName());
        }
        if (!org2parentNumMap.isEmpty()) {
            for (Map.Entry entry : org2parentNumMap.entrySet()) {
                Long orgId = (Long)entry.getKey();
                QFilter[] filters = new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)this.billEntityType.getName(), (Long)orgId), new QFilter("number", "in", entry.getValue())};
                Map map = BusinessDataServiceHelper.loadFromCache((String)this.billEntityType.getName(), (QFilter[])filters);
                HashMap numberDataMap = new HashMap(16);
                map.values().forEach(r -> numberDataMap.computeIfAbsent(r.getString("number"), k -> new ArrayList(10)).add(r));
                this.useOrgParentMap.put(orgId, numberDataMap);
            }
        }
        entities.forEach(entity -> this.beforeExecuteOperationTransaction(e, (ExtendedDataEntity)entity));
    }

    protected DynamicObject restoreParentData(DynamicObject obj, Long parentId, BeforeOperationArgs e, QFilter baseDataFilter) {
        DynamicObject parent = this.parentMap.get(parentId);
        if (null != obj.get("parent")) {
            DynamicObject currParent;
            Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)obj, (String)"useorg");
            String number = parent.getString("number");
            Map<String, List<DynamicObject>> numberDataMap = this.useOrgParentMap.get(useOrgId);
            DynamicObject newParent = null;
            if (!CollectionUtils.isEmpty((Collection)numberDataMap.get(number))) {
                List<DynamicObject> dataList = numberDataMap.get(number);
                for (DynamicObject data : dataList) {
                    if (!Objects.equals(parentId, (Long)data.getPkValue())) continue;
                    newParent = data;
                    break;
                }
                if (null == newParent) {
                    newParent = dataList.get(0);
                }
            }
            if (null != (currParent = this.restoreParentData(obj, newParent, parentId, parent))) {
                parent = currParent;
            } else {
                this.cancelOP(e);
            }
        }
        return parent;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        this.triggerEventSubscribe();
    }
}

