/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.app.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.app.plugin.DeployUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.param.ParameterReader;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.DeployServiceFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.IMetadataDeployService;
import kd.bos.service.metadata.MetadataDeployFile;
import kd.bos.service.metadata.MetadataDeployResult;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.service.upgrade.DeployService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptWriter;
import kd.bos.util.ExceptionUtils;
import org.dom4j.Element;

public class AppImportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AppImportTask.class);
    private final long LIMITSIZ = 0x1400000L;
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String URLARR = "urlarr";
    private static final String BIZCLOUDID = "bizcloudid";
    private static final String DBSCHEMA = "dbschema";
    private static final String PREINSDATA = "preinsdata";
    private static final String INSTALLMSG = "installmsg";

    public void execute(RequestContext rc, Map<String, Object> map) throws KDBizException {
        if (StringUtils.equals((CharSequence)"old", (CharSequence)System.getProperty("dev.appinstall.mode", "old"))) {
            this.executeBak(rc, map);
            return;
        }
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u5e94\u7528\u5bfc\u5165\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282", (String)"AppImportTask_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), null);
        JSONObject result = new JSONObject();
        result.put("success", (Object)"true");
        String bizCloudId = (String)map.get(BIZCLOUDID);
        String urlArrStr = (String)map.get(URLARR);
        String errMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"AppImportTask_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)urlArrStr) || StringUtils.isBlank((CharSequence)bizCloudId)) {
            logger.info(String.format("%1$s\u3002urlArr: %2$s, bizCloudId: %3$s", errMsg, urlArrStr, bizCloudId));
            result.put("success", (Object)"false");
            result.put("error", (Object)errMsg);
            this.feedbackCustomdata((Map)result);
            return;
        }
        JSONArray urlArr = JSONArray.parseArray((String)urlArrStr);
        if (urlArr == null || urlArr.isEmpty()) {
            logger.info(String.format("%1$s\u3002urlArr: %2$s, bizCloudId: %3$s", errMsg, urlArrStr, bizCloudId));
            result.put("success", (Object)"false");
            result.put("error", (Object)errMsg);
            return;
        }
        try {
            result.putAll((Map)DeployUtil.install((JSONArray)urlArr, (String)bizCloudId));
            this.feedbackCustomdata((Map)result);
        }
        catch (Exception e) {
            String errorMsg = String.format("%1$s\u3002%2$s", errMsg, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(errorMsg);
            result.put("success", (Object)"false");
            result.put("error", (Object)errorMsg);
            this.feedbackCustomdata((Map)result);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{errMsg});
        }
    }

    private void executeBak(RequestContext rc, Map<String, Object> map) throws KDBizException {
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u5e94\u7528\u5bfc\u5165\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282", (String)"AppImportTask_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), null);
        JSONObject installMsg = new JSONObject();
        try {
            JSONObject message = this.install(map);
            installMsg.putAll((Map)message);
        }
        catch (Exception e) {
            HashMap<String, String> result = new HashMap<String, String>(2);
            String info = String.format(ResManager.loadKDString((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25: %s", (String)"AppImportTask_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage());
            installMsg.put("ERROR", (Object)info);
            result.putAll((Map<String, String>)installMsg);
            result.put("success", "false");
            result.put("error", e.getMessage());
            this.feedbackCustomdata(result);
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5e94\u7528\u5bfc\u5165\u5931\u8d25", (String)"AppImportTask_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0])});
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("success", "true");
        result.putAll((Map<String, String>)installMsg);
        result.put("oldMode", "true");
        this.feedbackCustomdata(result);
    }

    /*
     * Exception decompiling
     */
    private JSONObject install(Map<String, Object> map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void exePageScheme(Map<String, InputStream> pageSchemeInfo, List<Map<String, String>> successList, List<Map<String, String>> errorList) {
        PreInsDataScriptWriter preInsDataScriptWriter = new PreInsDataScriptWriter();
        for (Map.Entry<String, InputStream> entry : pageSchemeInfo.entrySet()) {
            String pageSchemeName = entry.getKey();
            HashMap<String, String> successInfo = new HashMap<String, String>();
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            try {
                InputStream pageSchemeStream = entry.getValue();
                Throwable throwable = null;
                try {
                    preInsDataScriptWriter.insertPreInsData(pageSchemeStream);
                    successInfo.put(pageSchemeName, ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"BizAppInstallPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    if (successList.contains(successInfo)) continue;
                    successList.add(successInfo);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pageSchemeStream == null) continue;
                    if (throwable != null) {
                        try {
                            pageSchemeStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pageSchemeStream.close();
                }
            }
            catch (Exception e) {
                errorInfo.put(pageSchemeName, e.getMessage());
                if (errorList.contains(errorInfo)) continue;
                errorList.add(errorInfo);
            }
        }
    }

    private boolean isIgnoreSql() {
        Map map = ParameterReader.loadPublicParameterFromCache();
        return map.get("ignoresql") != null && (Boolean)map.get("ignoresql") != false;
    }

    private JSONObject getMetadataContent(String metaName, Map<String, String> appInfo, ZipInputStream zipIn, Map<String, String> appSource, Map<String, String> cloudInfo, Map<String, String> pageInfo, Set<String> sourceAppIds, Map<String, String> scriptInfo, Map<String, String> wfInfo, Map<String, String> botpInfo, Map<String, String> scheduleInfo, Map<String, String> dbInfo, Map<String, String> preInfo, List<String> dataModelList, List<Map<String, String>> appXMLList, Map<String, InputStream> pageSchemeInfo, Map<String, byte[]> customMetaInfo) throws IOException {
        JSONObject message = new JSONObject();
        if (metaName.endsWith("app") || metaName.endsWith("appx")) {
            String content = this.getMetadataContext(metaName, zipIn);
            appInfo.put(metaName, content);
            if (metaName.endsWith("app")) {
                DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
                serializer.setColloctionIgnorePKValue(true);
                DeployAppMetadata deployNew = (DeployAppMetadata)serializer.deserializeFromString(content, null);
                DesignAppMeta designAppMeta = (DesignAppMeta)deployNew.getDesignMetas().get(0);
                appSource.put("appversion", DevportalUtil.getAppVerion(designAppMeta.getNumber()));
                String bizCloudId = appSource.get(BIZCLOUDID);
                if (designAppMeta.getIndustryId() != null) {
                    long bizAppIndustry = designAppMeta.getIndustryId();
                    long cloudIndustry = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"industry").getLong("industry_id");
                    if (cloudIndustry != 0L && bizAppIndustry != 0L && bizAppIndustry != cloudIndustry) {
                        message.put("ERROR", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u7684\u884c\u4e1a\u4e0e\u4e91\u7684\u884c\u4e1a\u4e0d\u5339\u914d\u3002", (String)"BizAppInstallPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        return message;
                    }
                }
            }
        } else if (metaName.endsWith("cld") || metaName.endsWith("cldx")) {
            String content = this.getMetadataContext(metaName, zipIn);
            cloudInfo.put(metaName, content);
        } else if (metaName.endsWith("dym") || metaName.endsWith("dymx")) {
            String content = this.getMetadataContext(metaName, zipIn);
            pageInfo.put(metaName, content);
            if (metaName.endsWith("dym")) {
                DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                serializer.setColloctionIgnorePKValue(true);
                DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
                String bizAppId = deployNew.getBizappId();
                sourceAppIds.add(bizAppId);
            }
        } else if (metaName.endsWith("ks") || metaName.endsWith("ts")) {
            String content = this.getMetadataContext(metaName, zipIn);
            scriptInfo.put(metaName, content);
            DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
            List designDatas = deployNew.getScripts();
            for (DynamicObject dyn : designDatas) {
                String bizAppId = dyn.getString("bizappid");
                sourceAppIds.add(bizAppId);
            }
        } else if (metaName.endsWith("process")) {
            String content = this.getMetadataContext(metaName, zipIn);
            wfInfo.put(metaName, content);
        } else if (metaName.endsWith("schdata")) {
            String content = this.getMetadataContext(metaName, zipIn);
            scheduleInfo.put(metaName, content);
        } else if (metaName.endsWith("cr") || metaName.endsWith("crx") || metaName.endsWith("wb") || metaName.endsWith("wbx")) {
            String content = this.getMetadataContext(metaName, zipIn);
            botpInfo.put(metaName, content);
            DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
            serializer.setColloctionIgnorePKValue(true);
            DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
            if (metaName.endsWith("cr")) {
                DesignConvertRuleMeta designConvertRuleMeta = (DesignConvertRuleMeta)deployNew.getDesignMetas().get(0);
                String bizAppId = designConvertRuleMeta.getBizappId();
                sourceAppIds.add(bizAppId);
            } else if (metaName.endsWith("wb")) {
                DesignWriteBackRuleMeta designWriteBackRuleMeta = (DesignWriteBackRuleMeta)deployNew.getDesignMetas().get(0);
                String bizAppId = designWriteBackRuleMeta.getBizappId();
                sourceAppIds.add(bizAppId);
            }
        } else if (metaName.indexOf(DBSCHEMA) != -1 && metaName.endsWith("sql")) {
            if (!this.isIgnoreSql()) {
                String content = this.getMetadataContext(metaName, zipIn);
                dbInfo.put(metaName, content);
            }
        } else if (metaName.indexOf(PREINSDATA) != -1 && metaName.endsWith("sql")) {
            if (!this.isIgnoreSql()) {
                String content = this.getMetadataContext(metaName, zipIn);
                preInfo.put(metaName, content);
            }
        } else if (metaName.endsWith(".xml") && !metaName.contains("t_bas_cardconfig") && !metaName.equals("appInfo.xml")) {
            if (metaName.endsWith("datamodel.xml")) {
                String content = this.getMetadataContext(metaName, zipIn);
                dataModelList.add(content);
            } else {
                HashMap<String, String> appXmlMap = new HashMap<String, String>();
                String content = this.getMetadataContext(metaName, zipIn);
                appXmlMap.put(metaName, content);
                appXMLList.add(appXmlMap);
            }
        } else if (metaName.contains("t_bas_cardconfig") && metaName.endsWith(".xml")) {
            int xmlIndex = metaName.indexOf("xml");
            String pageSchemeName = metaName.substring(xmlIndex + 4, metaName.length());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readLength = 0;
            byte[] buf = new byte[0x1400000];
            while ((readLength = zipIn.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, readLength);
            }
            byte[] ret = bos.toByteArray();
            ByteArrayInputStream pageSchemeStream = new ByteArrayInputStream(ret);
            pageSchemeInfo.put(pageSchemeName, pageSchemeStream);
        } else if (DeployServiceFactory.isExistService((String)metaName)) {
            byte[] content = this.getMetadataContext(zipIn);
            customMetaInfo.put(metaName, content);
        }
        return message;
    }

    private String getMetadataContext(String metaName, ZipInputStream zipIn) throws IOException {
        int readLength = 0;
        int len = 0;
        byte[] buf = new byte[0x1400000];
        while ((readLength = zipIn.read()) != -1) {
            buf[len] = (byte)readLength;
            ++len;
        }
        return new String(buf, 0, len, StandardCharsets.UTF_8);
    }

    private byte[] getMetadataContext(ZipInputStream zipIn) throws IOException {
        if (zipIn == null) {
            return new byte[0];
        }
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            byte[] content;
            byte[] data = new byte[4096];
            int count = -1;
            while ((count = zipIn.read(data, 0, 4096)) != -1) {
                outStream.write(data, 0, count);
            }
            byte[] byArray = content = outStream.toByteArray();
            return byArray;
        }
    }

    private List<String> readerSql(BufferedReader br, String separator) throws IOException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String line = null;
        boolean isFirstLine = true;
        StringBuilder sb = new StringBuilder();
        boolean commentLine = false;
        while ((line = br.readLine()) != null) {
            if (line.length() <= 0) continue;
            if (isFirstLine && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                isFirstLine = false;
            }
            String temp = line.trim();
            if (commentLine) {
                if (!temp.endsWith("*/")) continue;
                commentLine = false;
                continue;
            }
            if (temp.startsWith("/*")) {
                if (temp.endsWith("*/")) continue;
                commentLine = true;
                continue;
            }
            if (temp.startsWith("--")) continue;
            if (!(temp.endsWith(separator) && separator.equals("GO") || Strings.isNullOrEmpty((String)temp))) {
                sb.append(' ').append(line).append(' ');
            }
            if (!temp.endsWith(separator)) continue;
            String curSql = sb.toString();
            if (curSql.contains("INSERT INTO t_bas_cardconfig") && curSql.contains("'bos_card_qing'")) {
                int startIndex = curSql.indexOf("'{");
                int endIndex = curSql.lastIndexOf("}'");
                String configJsonStr = curSql.substring(startIndex + 1, endIndex + 1);
                String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"switchHomepageCardPathToId", (Object[])new Object[]{configJsonStr});
                sb.replace(startIndex + 1, endIndex + 1, resultStr);
            }
            sqlList.add(sb.toString());
            sb = new StringBuilder();
        }
        return sqlList;
    }

    private void exeSql(List<Element> sqlElements, Map<String, String> sqlInfo, String version, String appName, String pkname, List<Map<String, String>> successList, List<Map<String, String>> errorList, List<Map<String, String>> repeatSqlList) throws IOException {
        ArrayList<String> executedSqlList = new ArrayList<String>();
        for (Element element : sqlElements) {
            String errorLevel;
            String type = element.attributeValue("Type");
            String separator = element.attributeValue("Separator");
            if (separator == null) {
                separator = ";";
            }
            if ((errorLevel = element.attributeValue("ErrorLevel")) == null) {
                errorLevel = "";
            }
            String dbKey = element.attributeValue("dbkey");
            String plugin = element.attributeValue("Plugin");
            String sql = element.getText();
            for (Map.Entry<String, String> entry : sqlInfo.entrySet()) {
                String sqlName = entry.getKey();
                if (!sqlName.contains(sql)) continue;
                executedSqlList.add(sqlName);
                HashMap<String, String> successData = new HashMap<String, String>();
                HashMap<String, String> errorData = new HashMap<String, String>();
                HashMap<String, String> repeatData = new HashMap<String, String>();
                String sqlContext = sqlInfo.get(sqlName);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", type);
                params.put("dbkey", dbKey);
                params.put("el", errorLevel);
                sql = element.getText();
                if (sql.contains(DBSCHEMA)) {
                    sql = sql.substring(DBSCHEMA.length() + 1);
                } else if (sqlName.contains(PREINSDATA)) {
                    sql = sql.substring(PREINSDATA.length() + 1);
                }
                params.put("ksqlname", sql);
                params.put("version", version);
                params.put("appname", appName);
                params.put("pkname", pkname);
                if (StringUtils.isNotBlank((CharSequence)plugin)) {
                    params.put("plugin", plugin);
                }
                List<Object> sqlList = Collections.emptyList();
                Map exexMap = new HashMap();
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(sqlContext.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        sqlList = this.readerSql(br, separator);
                        exexMap = ((DeployService)ServiceFactory.getService(DeployService.class)).deploySql(params, sqlList);
                        if (((Boolean)exexMap.get("success")).booleanValue()) {
                            String errorInfo = (String)exexMap.get("errorinfo");
                            String checkInfo = (String)exexMap.get("checkinfo");
                            if (StringUtils.isBlank((CharSequence)errorInfo) && StringUtils.isBlank((CharSequence)checkInfo)) {
                                successData.put(sqlName, ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"BizAppInstallPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                                if (successList.contains(successData)) continue;
                                successList.add(successData);
                                continue;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)checkInfo)) continue;
                            String info = ResManager.loadKDString((String)"\u5df2\u88ab\u6267\u884c\u8fc7", (String)"BizAppInstallPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                            if (checkInfo.contains(info)) {
                                repeatData.put(sqlName, String.format(ResManager.loadKDString((String)"\u91cd\u590d\u6267\u884c\u3002%s", (String)"AppImportTask_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), checkInfo));
                                if (repeatSqlList.contains(repeatData)) continue;
                                repeatSqlList.add(repeatData);
                                continue;
                            }
                            successData.put(sqlName, String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c%s\u3002", (String)"AppImportTask_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), checkInfo));
                            if (successList.contains(successData)) continue;
                            successList.add(successData);
                            continue;
                        }
                        String resString = JSON.toJSONString(exexMap);
                        errorData.put(sqlName, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff1a%s", (String)"AppImportTask_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), resString));
                        if (errorList.contains(errorData)) continue;
                        errorList.add(errorData);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                    String errorInfo = "";
                    errorInfo = exexMap == null || exexMap.isEmpty() ? ex.getMessage() : JSON.toJSONString(exexMap);
                    errorData.put(sqlName, String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff1a%s", (String)"AppImportTask_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), errorInfo));
                    if (errorList.contains(errorData)) continue;
                    errorList.add(errorData);
                }
            }
        }
        if (sqlInfo != null && sqlInfo.size() > 0) {
            for (String executedSql : executedSqlList) {
                sqlInfo.remove(executedSql);
            }
        }
    }

    private void writeLog(String formId, String formNumber, String content, long logId) {
        try {
            if (StringUtils.isBlank((CharSequence)formId)) {
                logger.info("\u4ece\u5e94\u7528\u5bfc\u5165\u5143\u6570\u636eID\u4e3a\u7a7a\uff0c\u9000\u51fa.");
                return;
            }
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, content, (int)MetaLogType.AppImport.getValue(), logId, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private static void deployMetadataFile(String fileName, byte[] content) {
        IMetadataDeployService metadataDeployService = DeployServiceFactory.getService((String)fileName);
        if (metadataDeployService == null) {
            return;
        }
        MetadataDeployFile deployFile = new MetadataDeployFile();
        deployFile.setContentBytes(content);
        deployFile.setFileName(fileName);
        ArrayList<MetadataDeployFile> deployFileList = new ArrayList<MetadataDeployFile>(1);
        deployFileList.add(deployFile);
        MetadataDeployResult metaDeployResult = metadataDeployService.deploy(deployFileList);
        if (metaDeployResult != null && !metaDeployResult.isSuccess()) {
            String metaDeployMsg = String.format(ResManager.loadKDString((String)"\u6587\u4ef6:%1$s\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s, \u65e5\u5fd7\uff1a%3$s", (String)"AppImportTask_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), fileName, metaDeployResult.getErrorInfo(), metaDeployResult.getLog());
            if ("error".equals(metaDeployResult.getEl())) {
                throw new KDException(BosErrorCode.bOS, new Object[]{metaDeployMsg});
            }
        }
    }

    private static void writeAppLog(String appId, long logId) {
        try {
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addAppMetaLog(appId, (int)MetaLogType.AppImport.getValue(), logId, (int)MetaType.App.getValue());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }
}

