/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.page.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.config.EnvConfigurationUtil;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.pureplatform.PurePlatformBlackList;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.mservice.svc.picture.IImage;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class BizPageNewTemplatePcPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener,
TabSelectListener {
    private static final String BTN_LAST1 = "btnlast1";
    private static final String BTN_LAST2 = "btnlast2";
    private static final String BTN_NEXT = "btnnext";
    private static final String BTNOK = "btnok";
    private static final String TPLTREE = "tpltree";
    private static final String BIZTPLTREE = "biztpltree";
    private static final String TREETAB = "treetab";
    private static final String TPLTAB = "tpltab";
    private static final String BIZTPLTAB = "biztpltab";
    private static final String NUMBER = "number";
    private static final String PAGETYPE = "pagetype";
    private static final String MOBILE = "mobile";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BIZAPPID = "bizappid";
    private static final String KEY_FLOCALEID = ":FLOCALEID";
    private static final String ZH_CN = "zh_CN";
    private static final String KEY_FISTEMPLATE = ":FISTEMPLATE";
    private static final String MODELTYPE = "modeltype";
    private static final String KEY_SHOWBLANKPAGE = "showBlankPage";
    private static final String KEY_BOS_FLEXTPL = "bos_flextpl";
    private static Map<String, String> templateImageMap = new HashMap<String, String>(20);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_LAST1, BTN_LAST2, BTN_NEXT, BTNOK});
        TreeView tpltree = (TreeView)this.getView().getControl(TPLTREE);
        tpltree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView biztpltree = (TreeView)this.getView().getControl(BIZTPLTREE);
        biztpltree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getControl(TREETAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.renderTplTree();
    }

    public void tabSelected(TabSelectEvent e) {
        if (TPLTAB.equals(e.getTabKey()) || BIZTPLTAB.equals(e.getTabKey())) {
            this.renderTplTree();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        this.nodeClick(nodeId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property)) {
            String number = (String)e.getChangeSet()[0].getNewValue();
            number = DevportalUtil.autoIsvNumber(number);
            this.getModel().beginInit();
            this.getModel().setValue(NUMBER, (Object)number);
            this.getModel().endInit();
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnlast1": {
                this.lastStep1();
                break;
            }
            case "btnlast2": {
                this.lastStep2();
                break;
            }
            case "btnnext": {
                this.nextStep();
                break;
            }
            case "btnok": {
                this.finish();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("root");
    }

    private void nodeClick(Object nodeId) {
        Map<String, String> templateDesMap;
        String templateDescription;
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String pageType = configInfo.get(PAGETYPE).toString();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("root"), TreeNode.class);
        if (nodeId != null) {
            TreeNode treeNode = root.getTreeNode(nodeId.toString(), 3);
            if ("pc".equals(pageType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"pcinfo"});
                if ("blankPage".equals(nodeId)) {
                    this.getModel().setValue("tempnumpc", (Object)"");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"labelap", "tempnumpc"});
                } else {
                    this.getModel().setValue("tempnumpc", (Object)treeNode.getId());
                    this.getView().setVisible(Boolean.TRUE, new String[]{"labelap", "tempnumpc"});
                }
            } else if (MOBILE.equals(pageType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"mobinfo"});
                if ("blankPage".equals(nodeId)) {
                    this.getModel().setValue("tempnummob", (Object)"");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1", "tempnummob"});
                } else {
                    this.getModel().setValue("tempnummob", (Object)treeNode.getId());
                    this.getView().setVisible(Boolean.TRUE, new String[]{"labelap1", "tempnummob"});
                }
            }
        }
        String templateKey = (String)nodeId;
        if (nodeId != null && "blankPage".equals(nodeId)) {
            String modelType = this.getModelTypeOfFocusNode();
            templateKey = modelType + "_" + nodeId;
        }
        if (StringUtils.isNotBlank((CharSequence)(templateDescription = (templateDesMap = this.loadTemplateDescription()).get(templateKey)))) {
            if (MOBILE.equals(pageType)) {
                this.getModel().setValue("textareafield1", (Object)templateDescription);
            } else {
                this.getModel().setValue("textareafield", (Object)templateDescription);
            }
        } else if (MOBILE.equals(pageType)) {
            this.getModel().setValue("textareafield1", (Object)ResManager.loadKDString((String)"\u8bf4\u660e\u6587\u6848\uff0c\u6a21\u677f\u5185\u5bb9\u8bf4\u660e", (String)"BizPageNewTemplatePcPlugin_31", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.getModel().setValue("textareafield", (Object)ResManager.loadKDString((String)"\u8bf4\u660e\u6587\u6848\uff0c\u6a21\u677f\u5185\u5bb9\u8bf4\u660e", (String)"BizPageNewTemplatePcPlugin_31", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        String imageKey = nodeId + "_large";
        String imageUrl = templateImageMap.get(imageKey);
        IImage imageap3 = (IImage)this.getControl("imageap3");
        if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
            imageap3.setUrl(imageUrl);
        } else {
            imageap3.setUrl("/images/pc/emotion/no_template_500_280.png");
        }
    }

    private void lastStep1() {
        this.getView().close();
    }

    private void lastStep2() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_LAST2});
        this.getView().setVisible(Boolean.FALSE, new String[]{"info"});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_LAST1});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEXT});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap10"});
    }

    private void nextStep() {
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String pageType = configInfo.get(PAGETYPE).toString();
        Tab treeTab = (Tab)this.getControl(TREETAB);
        String currentTabKey = treeTab.getCurrentTab();
        TreeView tree = null;
        tree = TPLTAB.equals(currentTabKey) ? (TreeView)this.getView().getControl(TPLTREE) : (TreeView)this.getView().getControl(BIZTPLTREE);
        Map focusNodeNodeInfo = tree.getTreeState().getFocusNode();
        if (focusNodeNodeInfo == null || focusNodeNodeInfo.isEmpty()) {
            return;
        }
        String id = (String)focusNodeNodeInfo.get("id");
        this.getPageCache().put("treeNodeId", id);
        String name = focusNodeNodeInfo.get("text").toString();
        this.getModel().setValue("title1", (Object)name);
        String imageKey = id + "_small";
        String imageUrl = templateImageMap.get(imageKey);
        IImage imageap23 = (IImage)this.getControl("imageap23");
        if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
            imageap23.setUrl(imageUrl);
        } else {
            imageap23.setUrl("/images/pc/emotion/no_template_320_180.png");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_LAST1});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEXT});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_LAST2});
        this.getView().setVisible(Boolean.TRUE, new String[]{"info"});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTNOK});
        if (MOBILE.equals(pageType) && (id == null || !"blankPage".equals(id))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"copyradio", "inheriaradio"});
        }
    }

    private void renderTplTree() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodata"});
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String modelType = configInfo.get(MODELTYPE).toString();
        String pageType = configInfo.get(PAGETYPE).toString();
        if (MOBILE.equals(pageType)) {
            this.getModel().setValue("radiogroupfield", (Object)"2");
        }
        TreeNode root = new TreeNode("", modelType, ResManager.loadKDString((String)"\u9690\u85cf\u7684\u6839\u8282\u70b9", (String)"BizPageNewTemplatePcPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        root.setIsOpened(true);
        JSONArray templateArray = this.loadTemplate(modelType);
        if (templateArray.size() > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap14"});
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_NEXT});
            for (int i = 0; i < templateArray.size(); ++i) {
                JSONObject template = templateArray.getJSONObject(i);
                TreeNode node = new TreeNode(root.getId(), template.getString(NUMBER), template.getString("name"));
                node.setLongNumber(template.getString(MODELTYPE));
                if (modelType.equals("ReportFormModel") && "bos_rpttpl".equals(template.getString(NUMBER))) {
                    root.addChild(0, node);
                    continue;
                }
                root.addChild(node);
            }
            Tab treeTab = (Tab)this.getControl(TREETAB);
            String currentTabKey = treeTab.getCurrentTab();
            TreeView tree = null;
            tree = TPLTAB.equals(currentTabKey) ? (TreeView)this.getView().getControl(TPLTREE) : (TreeView)this.getView().getControl(BIZTPLTREE);
            tree.addNode(root);
            TreeNode firstnode = (TreeNode)root.getChildren().get(0);
            tree.focusNode(firstnode);
            this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
            this.nodeClick(firstnode.getId());
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"pcinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"mobinfo"});
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_NEXT});
        }
    }

    private JSONArray loadTemplate(String modelType) {
        AppMetadata appMetadata;
        String bizAppId;
        Map configInfo;
        Tab treeTab = (Tab)this.getControl(TREETAB);
        String currentTab = treeTab.getCurrentTab();
        if (currentTab == null) {
            treeTab.activeTab(TPLTAB);
        }
        JSONArray templateArray = new JSONArray();
        if ("WidgetFormModel".equals(modelType)) {
            if (TPLTAB.equals(currentTab)) {
                JSONObject template = new JSONObject();
                template.put(NUMBER, (Object)"bos_card_template_new");
                template.put("name", (Object)ResManager.loadKDString((String)"\u5361\u7247\u6a21\u677f", (String)"BizPageNewTemplatePcPlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                template.put(MODELTYPE, (Object)modelType);
                templateArray.add((Object)template);
            } else if (BIZTPLTAB.equals(currentTab)) {
                configInfo = this.getView().getFormShowParameter().getCustomParams();
                bizAppId = configInfo.get(BIZAPPID).toString();
                appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                StringBuilder rt = new StringBuilder();
                String bizCloudId = appMetadata.getBizCloudID();
                JSONArray bizAppObjects = DevportalUtil.getAppsInCloud(bizCloudId);
                if (bizAppObjects.size() > 0) {
                    for (int i = 0; i < bizAppObjects.size(); ++i) {
                        JSONObject appInfo = (JSONObject)bizAppObjects.get(i);
                        String appId = (String)appInfo.get((Object)"id");
                        if (bizAppId.equals(appId)) continue;
                        rt.append('\'');
                        rt.append(appId);
                        rt.append("',");
                    }
                }
                rt.append('\'');
                rt.append(bizAppId);
                rt.append('\'');
                Object[] params = new SqlParameter[]{new SqlParameter(":FINHERITPATH", 12, (Object)"%/910EZ6ZX680%"), new SqlParameter(KEY_FLOCALEID, 12, (Object)Lang.get().getLocale().toString()), new SqlParameter(KEY_FISTEMPLATE, 1, (Object)"1"), new SqlParameter(":ftype", 1, (Object)"2")};
                String selectSql = String.format("select a.fnumber,b.fname, c.fisinherit from t_meta_entitydesign a, t_meta_entitydesign_l b,t_meta_formdesign c where a.fbizappid in (%s) and a.finheritpath like ? and b.flocaleid=? and a.fistemplate=? and a.ftype!=? and a.fnumber=b.fnumber and a.fnumber = c.fnumber order by a.fnumber asc", rt);
                DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])params, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else if (TPLTAB.equals(currentTab)) {
            Object[] params = new SqlParameter[3];
            QFilter filter = new QFilter("masterId", "=", (Object)"0a1f79d7000024ac");
            Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{filter});
            StringBuilder ids = new StringBuilder();
            for (Object id : appMap.keySet()) {
                ids.append('\'');
                ids.append((String)id);
                ids.append("',");
            }
            ids.append("'0a1f79d7000024ac'");
            params[0] = new SqlParameter(KEY_FISTEMPLATE, 1, (Object)"1");
            params[1] = new SqlParameter(":FMODELTYPE", 12, (Object)("%" + modelType + "%"));
            params[2] = new SqlParameter(KEY_FLOCALEID, 12, (Object)Lang.get().getLocale().toString());
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select a.fnumber,");
            sqlBuilder.append("b.fname,");
            sqlBuilder.append("a.fmodeltype from t_meta_entitydesign a,");
            sqlBuilder.append("t_meta_entitydesign_l b");
            sqlBuilder.append(" where a.ftype != '2'");
            sqlBuilder.append(" and a.fbizappid in");
            sqlBuilder.append('(');
            sqlBuilder.append((CharSequence)ids);
            sqlBuilder.append(')');
            sqlBuilder.append(" and a.fistemplate=?");
            sqlBuilder.append(" and a.fmodeltype like ?");
            if ("BillFormModel".equals(modelType)) {
                sqlBuilder.append("and a.fmodeltype != 'LogBillFormModel'");
            }
            sqlBuilder.append(" and b.flocaleid=?");
            sqlBuilder.append(" and a.fnumber=b.fnumber");
            sqlBuilder.append(" order by a.fnumber asc");
            DB.query((DBRoute)DBRoute.meta, (String)sqlBuilder.toString(), (Object[])params, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else if (BIZTPLTAB.equals(currentTab)) {
            configInfo = this.getView().getFormShowParameter().getCustomParams();
            bizAppId = configInfo.get(BIZAPPID).toString();
            appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            StringBuilder rt = new StringBuilder();
            String bizCloudId = appMetadata.getBizCloudID();
            JSONArray bizAppObjects = DevportalUtil.getAppsInCloud(bizCloudId);
            if (bizAppObjects.size() > 0) {
                for (int i = 0; i < bizAppObjects.size(); ++i) {
                    JSONObject appInfo = (JSONObject)bizAppObjects.get(i);
                    String appId = (String)appInfo.get((Object)"id");
                    if (bizAppId.equals(appId)) continue;
                    rt.append('\'');
                    rt.append(appId);
                    rt.append("',");
                }
            }
            rt.append('\'');
            rt.append(bizAppId);
            rt.append('\'');
            Object[] params = new SqlParameter[]{new SqlParameter(KEY_FISTEMPLATE, 1, (Object)"1"), new SqlParameter(":FMODELTYPE", 12, (Object)("%" + modelType + "%")), new SqlParameter(KEY_FLOCALEID, 12, (Object)Lang.get().getLocale().toString()), new SqlParameter(":ftype", 1, (Object)"2")};
            String selectSql = String.format("select a.fnumber,b.fname,a.fmodeltype,c.fisinherit from t_meta_entitydesign a,t_meta_entitydesign_l b, t_meta_formdesign c where a.fbizappid in (%s) and a.fistemplate=? and a.fmodeltype like ? and b.flocaleid=? and c.ftype!=? and a.fnumber=b.fnumber and a.fnumber = c.fnumber order by a.fnumber asc", rt);
            DB.query((DBRoute)DBRoute.meta, (String)selectSql, (Object[])params, (ResultSetHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (TPLTAB.equals(currentTab) && !"ReportFormModel".equals(modelType) && !"LogBillFormModel".equals(modelType)) {
            boolean showBlankPage;
            configInfo = this.getView().getFormShowParameter().getCustomParams();
            boolean bl = showBlankPage = configInfo.get(KEY_SHOWBLANKPAGE) == null ? true : (Boolean)configInfo.get(KEY_SHOWBLANKPAGE);
            if (showBlankPage) {
                JSONObject template = new JSONObject();
                template.put(NUMBER, (Object)"blankPage");
                template.put("name", (Object)ResManager.loadKDString((String)"\u7a7a\u767d\u9875\u9762", (String)"BizPageNewTemplatePcPlugin_38", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                template.put(MODELTYPE, (Object)modelType);
                templateArray.add((Object)template);
            }
        }
        return templateArray;
    }

    private void finish() {
        if (EnvTypeHelper.isDeploying()) {
            String msg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"MainPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String bizAppId = configInfo.get(BIZAPPID).toString();
        String bizUnitId = configInfo.get("bizunitid").toString();
        String modelType = this.getModelTypeOfFocusNode();
        String pageType = configInfo.get(PAGETYPE).toString();
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue(NUMBER);
        if (StringUtils.isBlank((Object)name) && StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewTemplatePcPlugin_32", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((Object)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewTemplatePcPlugin_33", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizPageNewTemplatePcPlugin_34", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (number.endsWith("_mob")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u6807\u8bc6\u4e0d\u80fd\u7528\u201c_mob\u201d\u505a\u4e3a\u540e\u7f00\uff0c\u907f\u514d\u4e0e\u7cfb\u7edf\u5173\u952e\u5b57\u51b2\u7a81\u3002", (String)"BizPageNewTemplatePcPlugin_37", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String compentTitle = "pc".equals(pageType) ? "tempnumpc" : "tempnummob";
        String templateNumber = (String)this.getModel().getValue(compentTitle);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelType", modelType);
        map.put("id", number);
        map.put("name", name);
        map.put(BIZAPPID, bizAppId);
        map.put("bizunitid", bizUnitId);
        map.put("enableGlobalExtLimits", true);
        String treeNodeId = this.getPageCache().get("treeNodeId");
        if (StringUtils.isNotBlank((CharSequence)treeNodeId) && "blankPage".equals(treeNodeId)) {
            Map<String, Object> message = DevportalUtil.buildNewPage(map, bizAppId, bizUnitId, this.getView(), false);
            if (StringUtils.isNotBlank(message) && StringUtils.isBlank((Object)message.get("isvcheckresult"))) {
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)templateNumber)};
        DynamicObject templateFormObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id, number, type", (QFilter[])filters);
        if (templateFormObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"BizPageNewTemplatePcPlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String templateFormId = templateFormObject.getString("id");
        map.put("parentId", templateFormId);
        if ("2".equals(templateFormObject.get("type").toString())) {
            map.put("devType", "2");
        }
        String createModeRadio = (String)this.getModel().getValue("radiogroupfield");
        if (MOBILE.equals(pageType)) {
            if ("1".equals(createModeRadio)) {
                Map<String, Object> message = DevportalUtil.buildNewPage(map, bizAppId, bizUnitId, this.getView(), false);
                if (StringUtils.isBlank((Object)message.get("isvcheckresult"))) {
                    this.getView().returnDataToParent(message);
                    this.getView().close();
                }
            } else if ("2".equals(createModeRadio)) {
                LocaleString formName = new LocaleString(name.getLocaleValue());
                Map<String, Object> message = DevportalUtil.copyMobleForm(templateFormId, bizAppId, bizUnitId, number, formName);
                if (StringUtils.isNotBlank(message)) {
                    if (StringUtils.isNotBlank((Object)message.get("checkresult"))) {
                        String checkResult = (String)message.get("checkresult");
                        this.getView().showTipNotification(checkResult);
                        return;
                    }
                    this.getView().returnDataToParent(message);
                    this.getView().close();
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u65b9\u5f0f\u3002", (String)"BizPageNewTemplatePcPlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        } else {
            Map<String, Object> message = DevportalUtil.buildNewPage(map, bizAppId, bizUnitId, this.getView(), false);
            if (StringUtils.isBlank((Object)message.get("isvcheckresult"))) {
                this.getView().returnDataToParent(message);
                this.getView().close();
            }
        }
    }

    private String getModelTypeOfFocusNode() {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("root"), TreeNode.class);
        Tab treeTab = (Tab)this.getControl(TREETAB);
        String currentTabKey = treeTab.getCurrentTab();
        TreeView tree = null;
        tree = TPLTAB.equals(currentTabKey) ? (TreeView)this.getView().getControl(TPLTREE) : (TreeView)this.getView().getControl(BIZTPLTREE);
        String focusNodeNodeId = tree.getTreeState().getFocusNodeId();
        TreeNode node = root.getTreeNode(focusNodeNodeId, 3);
        return node.getLongNumber();
    }

    private Map<String, String> loadTemplateDescription() {
        HashMap<String, String> templateDesMap = new HashMap<String, String>(28);
        templateDesMap.put("DynamicFormModel_blankPage", ResManager.loadKDString((String)"\u7a7a\u767d\u7684\u52a8\u6001\u8868\u5355\u9875\u9762\uff0c\u65e0\u9884\u7f6e\u5185\u5bb9\uff0c\u529f\u80fd\u5927\u591a\u4f7f\u7528\u63d2\u4ef6\u5b9e\u73b0\uff0c\u9002\u7528\u4e8e\u5b8c\u5168\u81ea\u5b9a\u4e49\u7684\u9875\u9762\u5f00\u53d1\u3002", (String)"BizPageNewTemplatePcPlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_dialogtpl", ResManager.loadKDString((String)"\u5185\u5bb9\u5f39\u7a97\u4ee5\u5f39\u51fa\u7a97\u7684\u5f62\u5f0f\u8ddf\u7528\u6237\u8fdb\u884c\u9875\u9762\u4ea4\u4e92\uff0c\u9002\u7528\u4e8e\u6709\u805a\u5408\u4fe1\u606f\u9700\u8981\u66f4\u52a0\u76f4\u89c2\u7684\u67e5\u770b\u6216\u5f55\u5165\u7684\u60c5\u51b5\u3002\u5f39\u7a97\u53ef\u4ee5\u5305\u542b\u5404\u79cdUI\u5143\u7d20\uff0c\u4f8b\u5982\u5b57\u6bb5\u3001\u8868\u683c\u3001\u56fe\u50cf\u548c\u56fe\u8868\u3002\n\u672c\u6a21\u677f\u5bbd\u5ea6780\u3001\u9ad8\u5ea6430\uff0c\u5e26\u3010\u786e\u5b9a\u3011\u3001\u3010\u53d6\u6d88\u3011\u6309\u94ae\u3002", (String)"BizPageNewTemplatePcPlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_dialogtpl_middle", ResManager.loadKDString((String)"\u5185\u5bb9\u5f39\u7a97\u4ee5\u5f39\u51fa\u7a97\u7684\u5f62\u5f0f\u8ddf\u7528\u6237\u8fdb\u884c\u9875\u9762\u4ea4\u4e92\uff0c\u9002\u7528\u4e8e\u6709\u805a\u5408\u4fe1\u606f\u9700\u8981\u66f4\u52a0\u76f4\u89c2\u7684\u67e5\u770b\u6216\u5f55\u5165\u7684\u60c5\u51b5\u3002\u5f39\u7a97\u53ef\u4ee5\u5305\u542b\u5404\u79cdUI\u5143\u7d20\uff0c\u4f8b\u5982\u5b57\u6bb5\u3001\u8868\u683c\u3001\u56fe\u50cf\u548c\u56fe\u8868\u3002\n\u672c\u6a21\u677f\u5bbd\u5ea6460\u3001\u9ad8\u5ea6430\uff0c\u5e26\u3010\u786e\u5b9a\u3011\u3001\u3010\u53d6\u6d88\u3011\u6309\u94ae\u3002", (String)"BizPageNewTemplatePcPlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_portal_apphome_grid", ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u9875\u9762\uff0c\u9884\u7f6e\u6807\u51c6\u83dc\u5355\u4e0e\u9996\u9875\u5e03\u5c40\uff0c\u9884\u7f6e\u6805\u683c\u5e03\u5c40\uff0c\u53ef\u5feb\u901f\u81ea\u5b9a\u4e49\u5361\u7247\u5f0f\u9996\u9875\uff0c\u9875\u9762\u5e03\u5c40\u80fd\u81ea\u9002\u5e94\u4e0d\u540c\u7684\u5c4f\u5e55\u5c3a\u5bf8\u3002\n\u5907\u6ce8\uff1a\u521b\u5efa\u5e94\u7528\u65f6\u4f1a\u81ea\u52a8\u751f\u6210\u4e00\u4e2a\u5e94\u7528\u9996\u9875\u9875\u9762\u3002", (String)"BizPageNewTemplatePcPlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_portal_gridcontainer", ResManager.loadKDString((String)"\u9884\u7f6e\u6805\u683c\u5bb9\u5668\u7684\u52a8\u6001\u8868\u5355\u9875\u9762\uff0c\u53ef\u5feb\u901f\u81ea\u5b9a\u4e49\u5361\u7247\u5f0f\u9875\u9762\uff0c\u9875\u9762\u5e03\u5c40\u80fd\u81ea\u9002\u5e94\u4e0d\u540c\u7684\u5c4f\u5e55\u5c3a\u5bf8\uff0c\u5e38\u7528\u4e8e\u5361\u7247\u5f0f\u7684\u9875\u9762\u8bbe\u8ba1\u3002", (String)"BizPageNewTemplatePcPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_wizardtpl", ResManager.loadKDString((String)"\u9884\u7f6e\u6b65\u9aa4\u6761\u7684\u52a8\u6001\u8868\u5355\u9875\u9762\u3002\u5f53\u7528\u6237\u9700\u8981\u5206\u6b65\u5904\u7406\u5927\u91cf\u590d\u6742\u7684\u5f55\u5165\u8fdb\u7a0b\u65f6\uff0c\u9700\u8981\u5448\u73b0\u660e\u786e\u7684\u6b65\u9aa4\u5173\u7cfb\uff0c\u5c31\u9700\u8981\u4f7f\u7528\u5411\u5bfc\u5f0f\u5f55\u5165\u3002", (String)"BizPageNewTemplatePcPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("BillFormModel_blankPage", ResManager.loadKDString((String)"\u7a7a\u767d\u9875\u9762\u65e0\u9884\u7f6e\u5b57\u6bb5\uff0c\u81ea\u5e26\u8868\u5355\u3001\u5217\u8868\u3001\u79fb\u52a8\u8868\u5355\u3001\u79fb\u52a8\u5217\u8868\u6846\u67b6\u903b\u8f91\u3002\u9002\u7528\u4e8e\u5b57\u6bb5\u3001\u64cd\u4f5c\u5b8c\u5168\u81ea\u5b9a\u4e49\u7684\u5355\u636e\u9875\u9762\u5f00\u53d1\u3002", (String)"BizPageNewTemplatePcPlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_billorgtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u5355\u636e\u6a21\u677f\uff0c\u5df2\u9884\u7f6e\u7ec4\u7ec7\u5b57\u6bb5\uff0c\u540c\u65f6\u5c06\u5176\u8bbe\u7f6e\u4e3a\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u652f\u6301\u6309\u7ec4\u7ec7\u9694\u79bb\u6570\u636e\u3002\n\u5178\u578b\u9875\u9762\uff1a\u91c7\u8d2d\u8ba2\u5355\u3001\u8d22\u52a1\u5e94\u6536\u5355\u3002", (String)"BizPageNewTemplatePcPlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_billtpl", ResManager.loadKDString((String)"\u9884\u7f6e\u5355\u636e\u5e38\u7528\u64cd\u4f5c\u3001\u5e38\u7528\u5b57\u6bb5\u3001\u6807\u51c6\u5355\u636e\u5e03\u5c40\u3001\u6807\u51c6\u5217\u8868\u3002", (String)"BizPageNewTemplatePcPlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("BaseFormModel_blankPage", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7a7a\u767d\u9875\u9762\u65e0\u9884\u7f6e\u5b57\u6bb5\uff0c\u6570\u636e\u80fd\u4f5c\u4e3a\u4f01\u4e1a\u7684\u57fa\u7840\u8d44\u6599\u88ab\u5176\u4ed6\u8868\u5355\u5f15\u7528\u3002", (String)"BizPageNewTemplatePcPlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_basegrouporgtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u57fa\u7840\u8d44\u6599\u6a21\u677f\uff0c\u589e\u52a0\u5206\u7ec4\u5b57\u6bb5\uff0c\u7ec4\u522b\u4e4b\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\uff0c\u652f\u6301\u6309\u7ec4\u7ec7\u8fdb\u884c\u57fa\u7840\u8d44\u6599\u7ba1\u63a7\uff0c\u5206\u7ec4\u9700\u8981\u7ed1\u5b9a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u3002\n\u5178\u578b\u9875\u9762\uff1a\u7269\u6599\u3001\u5ba2\u6237\u3001\u4f9b\u5e94\u5546\u3002", (String)"BizPageNewTemplatePcPlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_basegrouptpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u57fa\u7840\u8d44\u6599\u6a21\u677f\uff0c\u589e\u52a0\u5206\u7ec4\u5b57\u6bb5\uff0c\u7ec4\u522b\u4e4b\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\uff0c\u65e0\u9700\u6309\u7ec4\u7ec7\u9694\u79bb\uff0c\u5206\u7ec4\u9700\u8981\u7ed1\u5b9a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u3002\n\u5178\u578b\u9875\u9762\uff1a\u6c47\u7387\u3001\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"BizPageNewTemplatePcPlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_baseorgtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u57fa\u7840\u8d44\u6599\u6a21\u677f\uff0c\u9884\u7f6e\u591a\u4e2a\u7ec4\u7ec7\u5b57\u6bb5\uff0c\u652f\u6301\u6309\u7ec4\u7ec7\u8fdb\u884c\u57fa\u7840\u8d44\u6599\u7ba1\u63a7\u3002\n\u5178\u578b\u9875\u9762\uff1a\u51ed\u8bc1\u7c7b\u578b\u3001\u4e1a\u52a1\u7ec4\u3002", (String)"BizPageNewTemplatePcPlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_basetpl", ResManager.loadKDString((String)"\u6700\u57fa\u7840\u7684\u57fa\u7840\u8d44\u6599\u6a21\u677f\uff0c\u6570\u636e\u95f4\u65e0\u4efb\u4f55\u5173\u7cfb\uff0c\u65e0\u9700\u6309\u7ec4\u7ec7\u9694\u79bb\uff0c\u4e0d\u9700\u8981\u505a\u5206\u7ec4\u7ba1\u7406\u3002\n\u5178\u578b\u9875\u9762\uff1a\u5e01\u79cd\u3001\u56fd\u5bb6\u5730\u533a\u3001\u7a0e\u7387\u3001\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"BizPageNewTemplatePcPlugin_17", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_basetreeorgtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u57fa\u7840\u8d44\u6599\u6a21\u677f\uff0c\u6570\u636e\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\uff0c\u652f\u6301\u6309\u7ec4\u7ec7\u8fdb\u884c\u57fa\u7840\u8d44\u6599\u7ba1\u63a7\u3002\n\u5178\u578b\u9875\u9762\uff1a\u8d39\u7528\u9879\u76ee\u3001\u8d44\u91d1\u7528\u9014\u3002", (String)"BizPageNewTemplatePcPlugin_18", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_basetreetpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u57fa\u7840\u8d44\u6599\u6a21\u677f\uff0c\u6570\u636e\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\uff0c\u65e0\u9700\u6309\u7ec4\u7ec7\u9694\u79bb\u3002\n\u5178\u578b\u9875\u9762\uff1a\u884c\u653f\u7ec4\u7ec7\u3001\u4e1a\u52a1\u5355\u5143\u3002", (String)"BizPageNewTemplatePcPlugin_19", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("ReportFormModel_blankPage", ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u662f\u5e73\u53f0\u6700\u57fa\u7840\u7684\u62a5\u8868\u6a21\u677f\uff0c\u9884\u7f6e\u5e73\u94fa\u578b\u8fc7\u6ee4\u63a7\u4ef6\uff0c\u5728\u6253\u5f00/\u9884\u89c8\u9875\u9762\u7684\u65f6\u9700\u70b9\u51fb\u201c\u67e5\u8be2\u201d\u6309\u94ae\u624d\u4f1a\u52a0\u8f7d\u6570\u636e\uff0c\u9002\u7528\u7528\u6237\u67e5\u8be2\u8303\u56f4\u8f83\u591a\u53d8\uff0c\u9700\u8981\u7528\u6237\u624b\u52a8\u8bbe\u7f6e\u67e5\u8be2\u7ef4\u5ea6\u7684\u62a5\u8868\u3002\n\u5178\u578b\u9875\u9762\uff1a\u79d1\u76ee\u4f59\u989d\u8868\u3001\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u8868\u3001\u8f85\u52a9\u603b\u8d26\u3001\u7269\u6599\u6536\u53d1\u660e\u7ec6\u8868\u3001\u5373\u65f6\u5e93\u5b58\u67e5\u8be2\u3002", (String)"BizPageNewTemplatePcPlugin_20", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_commfilterrpttpl", ResManager.loadKDString((String)"\u7ee7\u627f\u4e8e\u62a5\u8868\u6a21\u677f\uff0c\u9884\u7f6e\u901a\u7528\u8fc7\u6ee4\u63a7\u4ef6\uff08\u652f\u6301\u5e38\u7528\u6761\u4ef6\u548c\u65b9\u6848\u67e5\u8be2\uff09\uff0c\u5728\u6253\u5f00/\u9884\u89c8\u9875\u9762\u7684\u65f6\u4f1a\u81ea\u52a8\u52a0\u8f7d\u6570\u636e\uff0c\u9002\u7528\u4e8e\u7528\u6237\u67e5\u8be2\u8303\u56f4\u8f83\u56fa\u5b9a\uff0c\u4e0d\u9700\u8981\u7528\u6237\u9891\u7e41\u4fee\u6539\u67e5\u8be2\u7ef4\u5ea6\u7684\u62a5\u8868\u3002\n\u5178\u578b\u9875\u9762\uff1a\u501f\u8fd8\u6b3e\u67e5\u8be2\u3001\u53d1\u7968\u67e5\u8be2\u3001\u6838\u7b97\u7ef4\u5ea6\u4e0e\u79d1\u76ee\u7ec4\u5408\u8868\u3002", (String)"BizPageNewTemplatePcPlugin_21", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_grouprpttpl", ResManager.loadKDString((String)"\u7ee7\u627f\u4e8e\u62a5\u8868\u6a21\u677f\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\u89c6\u56fe\uff0c\u9002\u7528\u4e8e\u6709\u5c42\u7ea7\u5173\u7cfb\u7684\u62a5\u8868\u3002\n\u5178\u578b\u9875\u9762\uff1a\u8f85\u52a9\u603b\u8d26\u3002", (String)"BizPageNewTemplatePcPlugin_22", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_rptqingtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u4e8e\u62a5\u8868\u6a21\u677f\uff0c\u9884\u7f6e\u8f7b\u5206\u6790\u63a7\u4ef6\uff0c\u9002\u7528\u4e8e\u56fe\u5f62\u5316\u7684\u6570\u636e\u5206\u6790\u62a5\u8868\u3002\n\u5178\u578b\u9875\u9762\uff1a\u591a\u7ef4\u6570\u636e\u5206\u6790\u8868\u3002", (String)"BizPageNewTemplatePcPlugin_23", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_rpttpl", ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u662f\u5e73\u53f0\u6700\u57fa\u7840\u7684\u62a5\u8868\u6a21\u677f\uff0c\u9884\u7f6e\u5e73\u94fa\u578b\u8fc7\u6ee4\u63a7\u4ef6\uff0c\u5728\u6253\u5f00/\u9884\u89c8\u9875\u9762\u7684\u65f6\u9700\u70b9\u51fb\u201c\u67e5\u8be2\u201d\u6309\u94ae\u624d\u4f1a\u52a0\u8f7d\u6570\u636e\uff0c\u9002\u7528\u7528\u6237\u67e5\u8be2\u8303\u56f4\u8f83\u591a\u53d8\uff0c\u9700\u8981\u7528\u6237\u624b\u52a8\u8bbe\u7f6e\u67e5\u8be2\u7ef4\u5ea6\u7684\u62a5\u8868\u3002\n\u5178\u578b\u9875\u9762\uff1a\u79d1\u76ee\u4f59\u989d\u8868\u3001\u7269\u6599\u6536\u53d1\u660e\u7ec6\u8868\u3001\u5373\u65f6\u5e93\u5b58\u67e5\u8be2\u3002", (String)"BizPageNewTemplatePcPlugin_24", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("MobileFormModel_blankPage", ResManager.loadKDString((String)"\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355\uff0c\u65e0\u5b9e\u4f53\u8868\uff0c\u529f\u80fd\u5927\u591a\u4f7f\u7528\u63d2\u4ef6\u5b9e\u73b0\uff0c\u7a7a\u767d\u9875\u9762\u65e0\u9884\u7f6e\u5e03\u5c40\u3002", (String)"BizPageNewTemplatePcPlugin_25", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_mobiletpl", ResManager.loadKDString((String)"\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355\uff0c\u65e0\u5b9e\u4f53\u8868\uff0c\u529f\u80fd\u5927\u591a\u4f7f\u7528\u63d2\u4ef6\u5b9e\u73b0\u3002\n\u9884\u7f6e\u5e38\u7528\u5b57\u6bb5\uff1a\u5355\u636e\u7c7b\u578b\u3001\u4fe1\u606f\u9009\u62e9\u3001\u4fee\u6539\u65e5\u671f\u7b49\u3002\n\u9884\u7f6e\u5e38\u7528\u64cd\u4f5c\uff1a\u63d0\u4ea4\u3002", (String)"BizPageNewTemplatePcPlugin_26", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_personalinfotpl", ResManager.loadKDString((String)"\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355\uff0c\u65e0\u5b9e\u4f53\u8868\uff0c\u529f\u80fd\u5927\u591a\u4f7f\u7528\u63d2\u4ef6\u5b9e\u73b0\u3002\n\u9884\u7f6e\u5e38\u7528\u5b57\u6bb5\uff1a\u59d3\u540d\u3001\u7c4d\u8d2f\u3001\u751f\u65e5\u3001\u8bc1\u4ef6\u53f7\u7801\u3001\u8054\u7cfb\u65b9\u5f0f\u3001\u8054\u7cfb\u5730\u5740\u3001\u90e8\u95e8\u3001\u804c\u4f4d\u7b49\u3002\n\u9884\u7f6e\u5e38\u7528\u64cd\u4f5c\uff1a\u63d0\u4ea4\u3002", (String)"BizPageNewTemplatePcPlugin_27", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_reimbursetpl", ResManager.loadKDString((String)"\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355\uff0c\u65e0\u5b9e\u4f53\u8868\uff0c\u529f\u80fd\u5927\u591a\u4f7f\u7528\u63d2\u4ef6\u5b9e\u73b0\u3002\n\u9884\u7f6e\u5e38\u7528\u5b57\u6bb5\uff1a\u8d39\u7528\u9879\u76ee\u3001\u5dee\u65c5\u8d39\u7c7b\u578b\u3001\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u7a0e\u7387\u3001\u7a0e\u989d\u3001\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u7b49\u3002\n\u9884\u7f6e\u5e38\u7528\u64cd\u4f5c\uff1a\u63d0\u4ea4\u3002", (String)"BizPageNewTemplatePcPlugin_28", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("MobUserGuideFormModel_blankPage", ResManager.loadKDString((String)"\u79fb\u52a8\u7248\u7684\u4e00\u79cd\u7279\u6b8a\u7684\u52a8\u6001\u8868\u5355\uff0c\u8bbe\u7f6e\u7528\u6237\u9996\u6b21\u8fdb\u5165\u67d0\u4e2a\u79fb\u52a8\u5355\u636e\u65f6\uff0c\u5f15\u5bfc\u5176\u5b66\u4e60\u4f7f\u7528\u3002", (String)"BizPageNewTemplatePcPlugin_29", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_logbilltpl", ResManager.loadKDString((String)"\u65e5\u5fd7\u8868\u5355\u6a21\u677f\u5185\u7f6e\u5e38\u7528\u7684\u65e5\u5fd7\u5b57\u6bb5\uff0c\u5305\u62ec\u64cd\u4f5c\u4eba\uff0c\u64cd\u4f5c\u540d\u79f0\uff0c\u64cd\u4f5c\u63cf\u8ff0\u548c\u64cd\u4f5c\u65f6\u95f4\uff1b\u5e76\u81ea\u5e26\u8868\u5355\u3001\u5217\u8868\u6846\u67b6\u903b\u8f91\u3002\u9002\u7528\u4e8e\u5e38\u7528\u65e5\u5fd7\u7684\u5feb\u901f\u5f00\u53d1\uff0c\u4ee5\u53ca\u4e2a\u6027\u5316\u65e5\u5fd7\u8868\u5355/\u5217\u8868\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5\u6dfb\u52a0\u3002", (String)"BizPageNewTemplatePcPlugin_35", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("LogBillFormModel_blankPage", ResManager.loadKDString((String)"\u7a7a\u767d\u65e5\u5fd7\u8868\u5355\u65e0\u9884\u7f6e\u5b57\u6bb5\uff0c\u81ea\u5e26\u8868\u5355\u3001\u5217\u8868\u6846\u67b6\u903b\u8f91\u3002\u9002\u7528\u4e8e\u5b57\u6bb5\u3001\u64cd\u4f5c\u5b8c\u5168\u81ea\u5b9a\u4e49\u7684\u65e5\u5fd7\u9875\u9762\u5f00\u53d1\u3002", (String)"BizPageNewTemplatePcPlugin_36", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_kmtpl", ResManager.loadKDString((String)"\u57fa\u7840\u7684\u77e5\u8bc6\u5e93\u6a21\u677f\uff0c\u65e0\u9700\u6309\u7ec4\u7ec7\u9694\u79bb\uff0c\u65e0\u9700\u6309\u5206\u7ec4\u7ba1\u7406\u3002", (String)"BizPageNewTemplatePcPlugin_50", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_kmorgtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u77e5\u8bc6\u5e93\u6a21\u677f\uff0c\u9884\u7f6e\u7ec4\u7ec7\u5b57\u6bb5\uff0c\u652f\u6301\u6309\u7ec4\u7ec7\u8fdb\u884c\u77e5\u8bc6\u5e93\u7ba1\u63a7\u3002", (String)"BizPageNewTemplatePcPlugin_51", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_kmgrouptpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u77e5\u8bc6\u5e93\u6a21\u677f\uff0c\u589e\u52a0\u5206\u7ec4\u5b57\u6bb5\uff0c\u7ec4\u522b\u4e4b\u524d\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\uff0c\u65e0\u9700\u6309\u7ec4\u7ec7\u9694\u79bb\uff0c\u5206\u7ec4\u9700\u8981\u7ed1\u5b9a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"BizPageNewTemplatePcPlugin_52", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("bos_kmgrouporgtpl", ResManager.loadKDString((String)"\u7ee7\u627f\u81ea\u77e5\u8bc6\u5e93\u6a21\u677f\uff0c\u589e\u52a0\u5206\u7ec4\u5b57\u6bb5\uff0c\u7ec4\u522b\u4e4b\u95f4\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u9884\u7f6e\u5de6\u6811\u53f3\u8868\u578b\u5217\u8868\uff0c\u652f\u6301\u6309\u7ec4\u7ec7\u8fdb\u884c\u77e5\u8bc6\u5e93\u7ba1\u63a7\uff0c\u5206\u7ec4\u9700\u8981\u7ed1\u5b9a\u5173\u8054\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"BizPageNewTemplatePcPlugin_53", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        templateDesMap.put("KMModel_blankPage", ResManager.loadKDString((String)"\u65e0\u9884\u7f6e\u5b57\u6bb5\uff0c\u9002\u7528\u4e8e\u5b57\u6bb5\u3001\u64cd\u4f5c\u5b8c\u5168\u81ea\u5b9a\u4e49\u7684\u77e5\u8bc6\u5e93\u9875\u9762\u5f00\u53d1\u3002", (String)"BizPageNewTemplatePcPlugin_54", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        return templateDesMap;
    }

    private static void loadTemplateImage() {
        templateImageMap.put("bos_billtpl_large", "/images/pc/other/bos_jcl_480_26.png");
        templateImageMap.put("bos_billtpl_small", "/images/pc/other/bos_jcs_350_194.png");
        templateImageMap.put("bos_billorgtpl_large", "/images/pc/other/bos_zzl_480_266.png");
        templateImageMap.put("bos_billorgtpl_small", "/images/pc/other/bos_zzs_350_194.png");
    }

    private boolean isExclusion(String number) {
        return EnvConfigurationUtil.isPurePlatform() && PurePlatformBlackList.getMobileTplBlackList().contains(number);
    }

    static /* synthetic */ boolean access$000(BizPageNewTemplatePcPlugin x0, String x1) {
        return x0.isExclusion(x1);
    }

    static {
        BizPageNewTemplatePcPlugin.loadTemplateImage();
    }
}

