/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.KingScriptEdit;
import org.apache.commons.lang3.StringUtils;

public class KingScriptConfig {
    public static final String VIEWSTATUS_EDIT = "edit";
    public static final String VIEWSTATUS_NEW = "new";
    private String scriptId;
    private String scriptName;
    private String scriptNumber;
    private String description;
    private String content;
    private String className;
    private String bizAppId;
    private String viewStatus;
    private String modifiDateTime;
    private String designerName;
    private String editorOpenType;
    private UpdateBuild updateBuild;

    public static KingScriptConfig createTempConfigFromDesigner(String designerName, String editorOpenType, String bizAppId) {
        KingScriptConfig designerConfig = new KingScriptConfig();
        designerConfig.designerName = designerName;
        designerConfig.editorOpenType = editorOpenType;
        designerConfig.bizAppId = bizAppId;
        return designerConfig;
    }

    public static KingScriptConfig createConfig(KingScriptConfig designerConfig, IPageCache pageCache, String scriptId, DynamicObject scriptObj, String viewStatus) {
        KingScriptConfig scriptConfig = new KingScriptConfig();
        scriptConfig.updateBuild = new UpdateBuild(scriptConfig);
        if (designerConfig.designerName != null) {
            scriptConfig.designerName = designerConfig.designerName;
        }
        if (designerConfig.editorOpenType != null) {
            scriptConfig.editorOpenType = designerConfig.editorOpenType;
        }
        if (designerConfig.bizAppId != null) {
            scriptConfig.bizAppId = designerConfig.getBizAppId();
        }
        scriptConfig.scriptId = scriptId;
        scriptConfig.scriptName = scriptObj.getString("txt_scriptname");
        scriptConfig.scriptNumber = scriptObj.getString("txt_scriptnumber");
        scriptConfig.description = scriptObj.getString("description");
        scriptConfig.content = scriptObj.getString("txt_scriptcontext_tag");
        scriptConfig.className = scriptObj.getString("classname");
        String bizAppIdTmp = scriptObj.getString("bizappid");
        if (StringUtils.isNotBlank((CharSequence)bizAppIdTmp)) {
            scriptConfig.bizAppId = bizAppIdTmp;
        }
        scriptConfig.viewStatus = viewStatus;
        scriptConfig.modifiDateTime = String.valueOf(scriptObj.getDate("modifydate").getTime());
        scriptConfig.update(pageCache);
        return scriptConfig;
    }

    public static KingScriptConfig getConfig(IPageCache pageCache) {
        KingScriptConfig scriptConfig = new KingScriptConfig();
        scriptConfig.scriptId = pageCache.get("scriptId");
        scriptConfig.scriptName = pageCache.get("scriptName");
        scriptConfig.scriptNumber = pageCache.get("scriptNumber");
        scriptConfig.description = pageCache.get("description");
        scriptConfig.content = pageCache.get("content");
        scriptConfig.className = pageCache.get("className");
        scriptConfig.bizAppId = pageCache.get("bizAppId");
        scriptConfig.viewStatus = pageCache.get("viewStatus");
        scriptConfig.modifiDateTime = pageCache.get("openmodifytime" + scriptConfig.scriptId);
        scriptConfig.designerName = pageCache.get("designerName");
        scriptConfig.editorOpenType = pageCache.get("editorOpenType");
        scriptConfig.updateBuild = new UpdateBuild(scriptConfig);
        return scriptConfig;
    }

    public static String getScriptId(IPageCache pageCache) {
        return pageCache.get("scriptId");
    }

    public static String getViewStatus(IPageCache pageCache) {
        return pageCache.get("viewStatus");
    }

    public static String getOpenmodifytime(IPageCache pageCache) {
        return pageCache.get("openmodifytime" + KingScriptConfig.getScriptId(pageCache));
    }

    public static String getClassName(IPageCache pageCache) {
        return pageCache.get("className");
    }

    public static String getDesignerName(IPageCache pageCache) {
        return pageCache.get("designerName");
    }

    public static String getEditorOpenType(IPageCache pageCache) {
        return pageCache.get("editorOpenType");
    }

    private void update(IPageCache pageCache) {
        pageCache.put("scriptId", this.scriptId);
        pageCache.put("scriptName", this.scriptName);
        pageCache.put("scriptNumber", this.scriptNumber);
        pageCache.put("description", this.description);
        pageCache.put("content", this.content);
        pageCache.put("className", this.className);
        pageCache.put("viewStatus", this.viewStatus);
        pageCache.put("openmodifytime" + this.scriptId, this.modifiDateTime);
        if (this.designerName != null) {
            pageCache.put("designerName", this.designerName);
        }
        if (this.editorOpenType != null) {
            pageCache.put("editorOpenType", this.editorOpenType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bizAppId)) {
            pageCache.put("bizAppId", this.bizAppId);
        }
    }

    public String getCodeNow(IFormView formView) {
        KingScriptEdit codeEdit = (KingScriptEdit)formView.getControl("kingscripteditap");
        String content = codeEdit.getText();
        if (content == null) {
            content = this.getContent();
        }
        return content;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getScriptNumber() {
        return this.scriptNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContent() {
        return this.content;
    }

    public String getClassName() {
        return this.className;
    }

    public String getBizAppId() {
        return this.bizAppId;
    }

    public String getViewStatus() {
        return this.viewStatus;
    }

    public String getModifiDateTime() {
        return this.modifiDateTime;
    }

    public String getDesignerName() {
        return this.designerName;
    }

    public String getEditorOpenType() {
        return this.editorOpenType;
    }

    public UpdateBuild getUpdateBuild() {
        return this.updateBuild;
    }

    static /* synthetic */ String access$000(KingScriptConfig x0) {
        return x0.scriptId;
    }

    static /* synthetic */ String access$100(KingScriptConfig x0) {
        return x0.scriptName;
    }

    static /* synthetic */ String access$200(KingScriptConfig x0) {
        return x0.scriptNumber;
    }

    static /* synthetic */ String access$300(KingScriptConfig x0) {
        return x0.description;
    }

    static /* synthetic */ String access$400(KingScriptConfig x0) {
        return x0.content;
    }

    static /* synthetic */ String access$500(KingScriptConfig x0) {
        return x0.className;
    }

    static /* synthetic */ String access$600(KingScriptConfig x0) {
        return x0.bizAppId;
    }

    static /* synthetic */ String access$700(KingScriptConfig x0) {
        return x0.viewStatus;
    }

    static /* synthetic */ String access$800(KingScriptConfig x0) {
        return x0.modifiDateTime;
    }

    static /* synthetic */ String access$900(KingScriptConfig x0) {
        return x0.designerName;
    }

    static /* synthetic */ String access$1000(KingScriptConfig x0) {
        return x0.editorOpenType;
    }

    static /* synthetic */ String access$002(KingScriptConfig x0, String x1) {
        x0.scriptId = x1;
        return x0.scriptId;
    }

    static /* synthetic */ String access$102(KingScriptConfig x0, String x1) {
        x0.scriptName = x1;
        return x0.scriptName;
    }

    static /* synthetic */ String access$202(KingScriptConfig x0, String x1) {
        x0.scriptNumber = x1;
        return x0.scriptNumber;
    }

    static /* synthetic */ String access$302(KingScriptConfig x0, String x1) {
        x0.description = x1;
        return x0.description;
    }

    static /* synthetic */ String access$402(KingScriptConfig x0, String x1) {
        x0.content = x1;
        return x0.content;
    }

    static /* synthetic */ String access$502(KingScriptConfig x0, String x1) {
        x0.className = x1;
        return x0.className;
    }

    static /* synthetic */ String access$602(KingScriptConfig x0, String x1) {
        x0.bizAppId = x1;
        return x0.bizAppId;
    }

    static /* synthetic */ String access$702(KingScriptConfig x0, String x1) {
        x0.viewStatus = x1;
        return x0.viewStatus;
    }

    static /* synthetic */ String access$802(KingScriptConfig x0, String x1) {
        x0.modifiDateTime = x1;
        return x0.modifiDateTime;
    }

    static /* synthetic */ String access$902(KingScriptConfig x0, String x1) {
        x0.designerName = x1;
        return x0.designerName;
    }

    static /* synthetic */ String access$1002(KingScriptConfig x0, String x1) {
        x0.editorOpenType = x1;
        return x0.editorOpenType;
    }

    static /* synthetic */ void access$1100(KingScriptConfig x0, IPageCache x1) {
        x0.update(x1);
    }
}

