/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.devportal.script.npm.AbstractKingScriptBasePlugin;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.devportal.script.npm.helper.KingScriptConfigHelper;
import kd.bos.devportal.script.npm.helper.KingScriptMutexViewHelper;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class KingScriptConfigPlugin
extends AbstractKingScriptBasePlugin {
    private static Log logger = LogFactory.getLog(KingScriptConfigPlugin.class);
    protected static final String CODE = "kingscripteditap";
    private static final String GET_CODEEDITOR_CONFIG = "getCodeEditorConfig";
    protected static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        KingScriptEdit edit = (KingScriptEdit)this.getControl(CODE);
        edit.addScriptEditorListener((KingScriptEditorListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String scriptId = (String)e.getFormShowParameter().getCustomParam("bizscriptid");
        Object plugin = e.getFormShowParameter().getCustomParam("plugin");
        Object isOnlyCodeEditor = e.getFormShowParameter().getCustomParam("isOnlyCodeEditor");
        if (isOnlyCodeEditor != null && Boolean.TRUE.toString().equals(isOnlyCodeEditor.toString())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)scriptId) && plugin instanceof Map) {
            Map pluginMap = (Map)plugin;
            scriptId = (String)pluginMap.get("FPK");
        }
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            DynamicObject scriptObj = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
            String content = scriptObj.getString("txt_scriptcontext_tag");
            String encryptContent = scriptObj.getString("txt_scriptcompile_tag");
            if (StringUtils.isBlank((CharSequence)content) && StringUtils.isNotBlank((CharSequence)encryptContent)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u811a\u672c\u5df2\u90e8\u7f72\uff0c\u65e0\u6cd5\u4f7f\u7528\u5728\u7ebf\u7f16\u8f91\u5668\u6253\u5f00\u3002", (String)"KingScriptConfigPlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (RequestContext.get().getLang() == Lang.en_US) {
            Image imageap = (Image)this.getView().getControl("imageap");
            imageap.setUrl("/images/pc/other/logo_script_en.png");
        }
        KingScriptConfig designerConfig = this.initDesignerParam();
        String scriptId = (String)this.getView().getFormShowParameter().getCustomParam("bizscriptid");
        Object plugin = this.getView().getFormShowParameter().getCustomParam("plugin");
        Object isOnlyCodeEditor = this.getView().getFormShowParameter().getCustomParam("isOnlyCodeEditor");
        if (isOnlyCodeEditor != null && Boolean.TRUE.toString().equals(isOnlyCodeEditor.toString())) {
            Object scriptContext = this.getView().getFormShowParameter().getCustomParam("scriptContext");
            this.editCode(scriptContext.toString());
        } else if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            this.loadScript(designerConfig, scriptId);
        } else if (plugin instanceof Map) {
            Map pluginMap = (Map)plugin;
            scriptId = (String)pluginMap.get("FPK");
            this.loadScript(designerConfig, scriptId);
        } else {
            String templateId = KingScriptConfigHelper.getTemplateId(designerConfig, this.getView());
            if (StringUtils.isNotBlank((CharSequence)templateId)) {
                DynamicObject scriptObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"ide_pluginscript");
                KingScriptConfig scriptConfig = KingScriptConfig.createConfig(designerConfig, this.getPageCache(), templateId, scriptObj, "new");
                StringBuffer title = this.initTitleContent();
                title.append(scriptConfig.getContent() == null ? "" : scriptConfig.getContent());
                this.editCode(title.toString());
            }
        }
        String viewStatus = KingScriptConfig.getViewStatus(this.getPageCache());
        if ("edit".equals(viewStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"scriptnumber"});
        }
    }

    private KingScriptConfig initDesignerParam() {
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        String designerName = propertyEditHelper.getSubDesignerName(this.getView());
        IFormView designerView = propertyEditHelper.getDesignFormView(this.getView());
        String bizAppId = propertyEditHelper.getBizAppId(this.getView());
        if (bizAppId == null) {
            bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        }
        return KingScriptConfig.createTempConfigFromDesigner(designerName, designerView != null ? "designer" : null, bizAppId);
    }

    private void loadScript(KingScriptConfig designerConfig, String scriptId) {
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            DynamicObject scriptObj = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
            KingScriptConfig scriptConfig = KingScriptConfig.createConfig(designerConfig, this.getPageCache(), scriptId, scriptObj, "edit");
            this.editTitle(scriptConfig);
            this.editCode(scriptConfig.getContent());
        }
    }

    private void editTitle(KingScriptConfig scriptConfig) {
        String isEditTitle = (String)this.getView().getFormShowParameter().getCustomParam("editTitle");
        if (StringUtils.isNotBlank((CharSequence)isEditTitle) && !Boolean.parseBoolean(isEditTitle)) {
            return;
        }
        this.getModel().setValue("scriptnumber", (Object)scriptConfig.getScriptNumber());
        this.getModel().setValue("scriptname", (Object)scriptConfig.getScriptName());
        this.getModel().setValue("description", (Object)scriptConfig.getDescription());
    }

    private void editCode(String content) {
        String isEditCode = (String)this.getView().getFormShowParameter().getCustomParam("editCode");
        if (StringUtils.isNotBlank((CharSequence)isEditCode) && !Boolean.parseBoolean(isEditCode)) {
            return;
        }
        KingScriptEdit codeEdit = (KingScriptEdit)this.getControl(CODE);
        codeEdit.setText(content);
    }

    private StringBuffer initTitleContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("/**\n * @author ").append(RequestContext.get().getUserName()).append("\n * @date ").append(new SimpleDateFormat("yyyy-MM-dd").format(new Date())).append("\n */\n");
        return sb;
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "getCodeEditorConfig": {
                this.setCodeEditorConfig();
            }
        }
    }

    private void setCodeEditorConfig() {
        Object isOnlyViewEditor;
        ArrayList args = new ArrayList(10);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        KingScriptConfig scriptConfig = KingScriptConfig.getConfig(this.getPageCache());
        boolean debugEnable = KingScriptConfigHelper.isDebugEnable(scriptConfig.getClassName());
        boolean editEnable = KingScriptConfigHelper.isEditEnable(scriptConfig.getScriptId());
        boolean codeDemo = KingScriptConfigHelper.isCodeDemoEnable();
        boolean doSuccess = KingScriptMutexViewHelper.doMutexView((IFormView)this.getView(), (KingScriptConfig)scriptConfig, (boolean)editEnable);
        if (!doSuccess) {
            editEnable = false;
            debugEnable = false;
            codeDemo = false;
        }
        map.put("scriptPath", scriptConfig.getClassName());
        map.put("scriptCode", scriptConfig.getScriptNumber());
        map.put("scriptName", scriptConfig.getScriptName());
        map.put("debugEnable", debugEnable);
        map.put("editEnable", editEnable);
        map.put("codeDemoEnable", codeDemo);
        map.put("appid", scriptConfig.getBizAppId());
        map.put("theme", "Dark");
        Object isOnlyCodeEditor = this.getView().getFormShowParameter().getCustomParam("isOnlyCodeEditor");
        if (isOnlyCodeEditor != null && Boolean.TRUE.toString().equals(isOnlyCodeEditor.toString())) {
            map.put("debugEnable", false);
            map.put("codeDemoEnable", false);
            map.put("theme", "Light");
        }
        if ((isOnlyViewEditor = this.getView().getFormShowParameter().getCustomParam("isOnlyViewEditor")) != null && Boolean.TRUE.toString().equals(isOnlyViewEditor.toString())) {
            map.put("debugEnable", false);
            map.put("codeDemoEnable", false);
        }
        args.add(map);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getControl(CODE).getKey(), "setCodeEditorConfig", new Object[]{args});
    }
}

